/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.KeyVariableNamer;
import dagger.internal.codegen.binding.MapKeys;
import dagger.internal.codegen.binding.MultiboundMapBinding;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequestRepresentations;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.xprocessing.Accessibility;
import dagger.internal.codegen.xprocessing.XCodeBlocks;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XExpression;
import dagger.internal.codegen.xprocessing.XFunSpecs;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XFunSpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import java.util.Collection;
import javax.lang.model.element.Modifier;

final class MapRequestRepresentation
extends RequestRepresentation {
    private static final int MAX_IMMUTABLE_MAP_OF_KEY_VALUE_PAIRS = 5;
    private final XProcessingEnv processingEnv;
    private final MultiboundMapBinding binding;
    private final ImmutableMap<DependencyRequest, ContributionBinding> dependencies;
    private final ComponentRequestRepresentations componentRequestRepresentations;
    private final CompilerOptions compilerOptions;
    private final boolean useLazyClassKey;
    private final ComponentImplementation.ShardImplementation shard;

    @AssistedInject
    MapRequestRepresentation(@Assisted MultiboundMapBinding binding, XProcessingEnv processingEnv, BindingGraph graph, ComponentImplementation componentImplementation, ComponentRequestRepresentations componentRequestRepresentations, CompilerOptions compilerOptions) {
        this.binding = binding;
        this.processingEnv = processingEnv;
        BindingKind bindingKind = this.binding.kind();
        Preconditions.checkArgument((boolean)bindingKind.equals((Object)BindingKind.MULTIBOUND_MAP), (Object)((Object)bindingKind));
        this.componentRequestRepresentations = componentRequestRepresentations;
        this.compilerOptions = compilerOptions;
        this.dependencies = Maps.toMap(binding.dependencies(), dep -> graph.contributionBinding(dep.key()));
        this.useLazyClassKey = MapKeys.useLazyClassKey(binding, graph);
        this.shard = componentImplementation.shardImplementation(binding);
    }

    @Override
    XExpression getDependencyExpression(XClassName requestingClass) {
        XExpression dependencyExpression = this.getUnderlyingMapExpression(requestingClass);
        if (this.useLazyClassKey) {
            return XExpression.create(dependencyExpression.type(), XCodeBlock.of("%T.<%T>of(%L)", XTypeNames.LAZY_CLASS_KEY_MAP, this.valueTypeName(), dependencyExpression.codeBlock()));
        }
        return dependencyExpression;
    }

    private XExpression getUnderlyingMapExpression(XClassName requestingClass) {
        boolean isImmutableMapAvailable = this.isImmutableMapAvailable();
        if (isImmutableMapAvailable && this.dependencies.size() <= 5) {
            return XExpression.create(this.immutableMapType(), XCodeBlock.builder().add("%T.", XTypeNames.IMMUTABLE_MAP).add(this.maybeTypeParameters(requestingClass)).add("of(%L)", this.dependencies.keySet().stream().map(dependency -> this.keyAndValueExpression((DependencyRequest)dependency, requestingClass)).collect(XCodeBlocks.toParametersCodeBlock())).build());
        }
        switch (this.dependencies.size()) {
            case 0: {
                return this.collectionsStaticFactoryInvocation(requestingClass, XCodeBlock.of("emptyMap()", new Object[0]));
            }
            case 1: {
                return this.collectionsStaticFactoryInvocation(requestingClass, XCodeBlock.of("singletonMap(%L)", this.keyAndValueExpression((DependencyRequest)Iterables.getOnlyElement((Iterable)this.dependencies.keySet()), requestingClass)));
            }
        }
        String builderName = "mapBuilder";
        XCodeBlock.Builder builderMethodCalls = XCodeBlock.builder();
        for (DependencyRequest dependency2 : this.dependencies.keySet()) {
            builderMethodCalls.addStatement("%N.put(%L)", builderName, this.keyAndValueExpression(dependency2, requestingClass));
        }
        String methodName = this.shard.getUniqueMethodName(KeyVariableNamer.name(this.binding.key()) + "Builder");
        XClassName returnType = isImmutableMapAvailable ? XTypeNames.IMMUTABLE_MAP : XTypeNames.JAVA_UTIL_MAP;
        XClassName builderType = isImmutableMapAvailable ? XTypeNames.IMMUTABLE_MAP_BUILDER : XTypeNames.MAP_BUILDER;
        XFunSpec methodSpec = XFunSpecs.methodBuilder(methodName).addModifiers((Collection<Modifier>)(!this.shard.isShardClassPrivate() ? ImmutableSet.of((Object)((Object)Modifier.PRIVATE)) : ImmutableSet.of())).returns(returnType).addCode(XCodeBlock.builder().addStatement("%T %N = %L", builderType, builderName, this.mapBuilderInvocation(requestingClass)).add(builderMethodCalls.build()).addStatement("return %N.build()", builderName).build()).build();
        this.shard.addMethod(ComponentImplementation.MethodSpecKind.PRIVATE_METHOD, methodSpec);
        XType expressionType = isImmutableMapAvailable ? this.immutableMapType() : this.binding.key().type().xprocessing();
        boolean isSameClass = requestingClass.equals(this.shard.name());
        XCodeBlock codeBlock = isSameClass ? XCodeBlock.of("%N()", methodName) : XCodeBlock.of("%L.%N()", this.shard.shardFieldReference(), methodName);
        return XExpression.create(expressionType, codeBlock);
    }

    private XCodeBlock mapBuilderInvocation(XClassName requestingClass) {
        XCodeBlock.Builder builder = XCodeBlock.builder();
        XCodeBlock typeParam = this.maybeTypeParameters(requestingClass);
        if (this.isImmutableMapAvailable()) {
            builder.add("%T.", XTypeNames.IMMUTABLE_MAP).add(typeParam);
            if (this.isImmutableMapBuilderWithExpectedSizeAvailable()) {
                builder.add("builderWithExpectedSize(%L)", this.dependencies.size());
            } else {
                builder.add("builder()", new Object[0]);
            }
        } else {
            builder.add("%T.", XTypeNames.MAP_BUILDER).add(typeParam);
            builder.add("newMapBuilder(%L)", this.dependencies.size());
        }
        return builder.build();
    }

    private XType immutableMapType() {
        MapType mapType = MapType.from(this.binding.key());
        return this.processingEnv.getDeclaredType(this.processingEnv.requireTypeElement(XTypeNames.IMMUTABLE_MAP), mapType.keyType(), mapType.valueType());
    }

    private XCodeBlock keyAndValueExpression(DependencyRequest dependency, XClassName requestingClass) {
        return XCodeBlock.of("%L, %L", this.useLazyClassKey ? MapKeys.getLazyClassMapKeyExpression((ContributionBinding)this.dependencies.get((Object)dependency)) : MapKeys.getMapKeyExpression((ContributionBinding)this.dependencies.get((Object)dependency), requestingClass, this.processingEnv), this.componentRequestRepresentations.getDependencyExpression(BindingRequest.bindingRequest(dependency), requestingClass).codeBlock());
    }

    private XExpression collectionsStaticFactoryInvocation(XClassName requestingClass, XCodeBlock methodInvocation) {
        return XExpression.create(this.binding.key().type().xprocessing(), XConverters.toJavaPoet(XCodeBlock.builder().add("%T.", XTypeNames.JAVA_UTIL_COLLECTIONS).add(this.maybeTypeParameters(requestingClass)).add(methodInvocation).build()));
    }

    private XCodeBlock maybeTypeParameters(XClassName requestingClass) {
        XType bindingKeyType = this.binding.key().type().xprocessing();
        return Accessibility.isTypeAccessibleFrom(bindingKeyType, requestingClass.getPackageName()) ? XCodeBlock.of("<%T, %T>", this.keyTypeName(), this.valueTypeName()) : XCodeBlock.of("", new Object[0]);
    }

    private XTypeName keyTypeName() {
        if (this.useLazyClassKey) {
            return XTypeName.STRING;
        }
        return MapType.from(this.binding.key()).keyType().asTypeName();
    }

    private XTypeName valueTypeName() {
        return MapType.from(this.binding.key()).valueType().asTypeName();
    }

    private boolean isImmutableMapBuilderWithExpectedSizeAvailable() {
        return this.isImmutableMapAvailable() && this.processingEnv.requireTypeElement(XTypeNames.IMMUTABLE_MAP).getDeclaredMethods().stream().anyMatch(method -> XElements.getSimpleName(method).contentEquals("builderWithExpectedSize"));
    }

    private boolean isImmutableMapAvailable() {
        return this.processingEnv.findTypeElement(XTypeNames.IMMUTABLE_MAP) != null;
    }

    @AssistedFactory
    static interface Factory {
        public MapRequestRepresentation create(MultiboundMapBinding var1);
    }
}

