/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.KeyVariableNamer;
import dagger.internal.codegen.binding.MapKeys;
import dagger.internal.codegen.binding.MultiboundMapBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequestRepresentations;
import dagger.internal.codegen.writing.MultibindingFactoryCreationExpression;
import dagger.internal.codegen.xprocessing.XCodeBlocks;
import dagger.internal.codegen.xprocessing.XFunSpecs;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XFunSpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XParameterSpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XProcessingEnv;
import java.util.Collection;
import javax.lang.model.element.Modifier;

final class MapFactoryCreationExpression
extends MultibindingFactoryCreationExpression {
    private final XProcessingEnv processingEnv;
    private final ComponentImplementation componentImplementation;
    private final ComponentImplementation.ShardImplementation shardImplementation;
    private final CompilerOptions compilerOptions;
    private final BindingGraph graph;
    private final MultiboundMapBinding binding;
    private final boolean useLazyClassKey;
    private String methodName;

    @AssistedInject
    MapFactoryCreationExpression(@Assisted MultiboundMapBinding binding, XProcessingEnv processingEnv, ComponentImplementation componentImplementation, ComponentRequestRepresentations componentRequestRepresentations, CompilerOptions compilerOptions, BindingGraph graph) {
        super(binding, componentImplementation, componentRequestRepresentations, compilerOptions);
        this.processingEnv = processingEnv;
        this.binding = (MultiboundMapBinding)Preconditions.checkNotNull((Object)binding);
        this.componentImplementation = componentImplementation;
        this.shardImplementation = componentImplementation.shardImplementation(binding);
        this.compilerOptions = compilerOptions;
        this.graph = graph;
        this.useLazyClassKey = MapKeys.useLazyClassKey(binding, graph);
    }

    @Override
    public XCodeBlock creationExpression() {
        return XCodeBlock.of("%N(%L)", this.methodName(), XCodeBlocks.parameterNames(this.shardImplementation.constructorParameters()));
    }

    private String methodName() {
        if (this.methodName == null) {
            this.methodName = this.shardImplementation.getUniqueMethodName(KeyVariableNamer.name(this.binding.key()) + "Builder");
            UniqueNameSet uniqueNameSet = new UniqueNameSet();
            this.shardImplementation.constructorParameters().stream().map(XParameterSpec::getName).forEach(uniqueNameSet::claim);
            String builderName = uniqueNameSet.getUniqueName("builder");
            XCodeBlock.Builder builderMethodCalls = XCodeBlock.builder();
            for (DependencyRequest dependency : this.binding.dependencies()) {
                builderMethodCalls.addStatement("%N.put(%L, %L)", builderName, this.keyExpression(dependency), this.valueExpression(dependency));
            }
            XFunSpec methodSpec = XFunSpecs.methodBuilder(this.methodName).addParameters((Collection<XParameterSpec>)this.shardImplementation.constructorParameters()).addModifiers((Collection<Modifier>)(!this.shardImplementation.isShardClassPrivate() ? ImmutableSet.of((Object)((Object)Modifier.PRIVATE)) : ImmutableSet.of())).returns(this.useLazyClassKey ? this.lazyMapFactoryType() : this.mapFactoryType()).addCode(XCodeBlock.builder().addStatement("%T %N = %T.builder(%L)", this.mapFactoryBuilderType(), builderName, SourceFiles.mapFactoryClassName(this.binding), this.binding.dependencies().size()).add(builderMethodCalls.build()).addStatement("%L", this.useLazyClassKey ? XCodeBlock.of("return %T.of(%N.build())", MapFactoryCreationExpression.lazyMapFactoryClassName(this.binding), builderName) : XCodeBlock.of("return %N.build()", builderName)).build()).build();
            this.shardImplementation.addMethod(ComponentImplementation.MethodSpecKind.INITIALIZE_HELPER_METHOD, methodSpec);
        }
        return this.methodName;
    }

    private XTypeName lazyMapFactoryType() {
        return this.useRawType() ? MapFactoryCreationExpression.lazyMapFactoryClassName(this.binding) : MapFactoryCreationExpression.lazyMapFactoryClassName(this.binding).parametrizedBy(this.valueTypeName());
    }

    private XTypeName mapFactoryType() {
        return this.useRawType() ? SourceFiles.mapFactoryClassName(this.binding) : SourceFiles.mapFactoryClassName(this.binding).parametrizedBy(this.keyTypeName(), this.valueTypeName());
    }

    private XTypeName mapFactoryBuilderType() {
        return this.useRawType() ? SourceFiles.mapFactoryClassName(this.binding).nestedClass("Builder") : SourceFiles.mapFactoryClassName(this.binding).nestedClass("Builder").parametrizedBy(this.keyTypeName(), this.valueTypeName());
    }

    private XTypeName keyTypeName() {
        if (this.useLazyClassKey) {
            return XTypeName.STRING;
        }
        return MapType.from(this.binding.key()).keyType().asTypeName();
    }

    private XTypeName valueTypeName() {
        return MapType.from(this.binding.key()).unwrappedFrameworkValueTypeName();
    }

    private XCodeBlock keyExpression(DependencyRequest dependency) {
        ContributionBinding contributionBinding = this.graph.contributionBinding(dependency.key());
        return this.useLazyClassKey ? MapKeys.getLazyClassMapKeyExpression(this.graph.contributionBinding(dependency.key())) : MapKeys.getMapKeyExpression(contributionBinding, this.componentImplementation.name(), this.processingEnv);
    }

    private XCodeBlock valueExpression(DependencyRequest dependency) {
        XCodeBlock valueExpression = this.multibindingDependencyExpression(dependency);
        return valueExpression;
    }

    private static XClassName lazyMapFactoryClassName(MultiboundMapBinding binding) {
        MapType mapType = MapType.from(binding.key());
        switch (binding.bindingType()) {
            case PROVISION: {
                return mapType.valuesAreProvider() ? XTypeNames.LAZY_CLASS_KEY_MAP_PROVIDER_FACTORY : XTypeNames.LAZY_CLASS_KEY_MAP_FACTORY;
            }
            case PRODUCTION: {
                return mapType.valuesAreFrameworkType() ? (mapType.valuesAreTypeOf(XTypeNames.PRODUCER) ? XTypeNames.LAZY_MAP_OF_PRODUCER_PRODUCER : XTypeNames.LAZY_MAP_OF_PRODUCED_PRODUCER) : XTypeNames.LAZY_MAP_PRODUCER;
            }
        }
        throw new IllegalArgumentException(binding.bindingType().toString());
    }

    @AssistedFactory
    static interface Factory {
        public MapFactoryCreationExpression create(MultiboundMapBinding var1);
    }
}

