/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.FieldSpec;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.FrameworkField;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.FrameworkInstanceSupplier;
import dagger.internal.codegen.writing.MemberSelect;
import dagger.internal.codegen.xprocessing.XAnnotationSpecs;
import dagger.internal.codegen.xprocessing.XPropertySpecs;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XPropertySpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import java.util.Optional;
import javax.lang.model.element.Modifier;

class FrameworkFieldInitializer
implements FrameworkInstanceSupplier {
    private final CompilerOptions compilerOptions;
    private final ComponentImplementation.ShardImplementation shardImplementation;
    private final ContributionBinding binding;
    private final FrameworkInstanceCreationExpression frameworkInstanceCreationExpression;
    private XPropertySpec propertySpec;
    private InitializationState fieldInitializationState = InitializationState.UNINITIALIZED;

    FrameworkFieldInitializer(CompilerOptions compilerOptions, ComponentImplementation componentImplementation, ContributionBinding binding, FrameworkInstanceCreationExpression frameworkInstanceCreationExpression) {
        this.compilerOptions = (CompilerOptions)Preconditions.checkNotNull((Object)compilerOptions);
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)binding);
        this.shardImplementation = ((ComponentImplementation)Preconditions.checkNotNull((Object)componentImplementation)).shardImplementation(binding);
        this.frameworkInstanceCreationExpression = (FrameworkInstanceCreationExpression)Preconditions.checkNotNull((Object)frameworkInstanceCreationExpression);
    }

    @Override
    public final MemberSelect memberSelect() {
        this.initializeField();
        return MemberSelect.localField(this.shardImplementation, ((FieldSpec)Preconditions.checkNotNull((Object)XConverters.toJavaPoet((XPropertySpec)this.propertySpec))).name);
    }

    private void initializeField() {
        switch (this.fieldInitializationState.ordinal()) {
            case 0: {
                this.fieldInitializationState = InitializationState.INITIALIZING;
                XCodeBlock.Builder codeBuilder = XCodeBlock.builder();
                XCodeBlock fieldInitialization = this.frameworkInstanceCreationExpression.creationExpression();
                XCodeBlock initCode = XCodeBlock.of("this.%N = %L;", this.getOrCreateField(), fieldInitialization);
                if (this.fieldInitializationState == InitializationState.DELEGATED) {
                    XCodeBlock delegateFactory = XCodeBlock.of("%N", this.propertySpec);
                    XCodeBlock delegate = fieldInitialization;
                    codeBuilder.add("%T.setDelegate(%L, %L);", this.delegateType(), delegateFactory, delegate);
                } else {
                    codeBuilder.add(initCode);
                }
                this.shardImplementation.addInitialization(codeBuilder.build());
                this.fieldInitializationState = InitializationState.INITIALIZED;
                break;
            }
            case 1: {
                this.propertySpec = this.getOrCreateField();
                this.fieldInitializationState = InitializationState.DELEGATED;
                this.shardImplementation.addInitialization(XCodeBlock.of("this.%N = new %T<>();", this.propertySpec, this.delegateType()));
                break;
            }
        }
    }

    private XPropertySpec getOrCreateField() {
        if (this.propertySpec != null) {
            return this.propertySpec;
        }
        FrameworkField contributionBindingField = FrameworkField.forBinding(this.binding, this.frameworkInstanceCreationExpression.alternativeFrameworkClass(), this.compilerOptions);
        XTypeName fieldType = this.frameworkFieldType(contributionBindingField);
        if (this.binding.kind() == BindingKind.ASSISTED_INJECTION) {
            XTypeName[] typeParameters = (XTypeName[])this.binding.key().type().xprocessing().getTypeArguments().stream().map(XType::asTypeName).toArray(XTypeName[]::new);
            fieldType = typeParameters.length == 0 ? SourceFiles.generatedClassNameForBinding(this.binding) : SourceFiles.generatedClassNameForBinding(this.binding).parametrizedBy(typeParameters);
        }
        XPropertySpecs.Builder contributionField = XPropertySpecs.builder(this.shardImplementation.getUniqueFieldName(this.frameworkInstanceCreationExpression.preferredFieldName().orElse(contributionBindingField.name())), fieldType, new Modifier[0]);
        if (!this.shardImplementation.isShardClassPrivate()) {
            contributionField.addModifiers(Modifier.PRIVATE);
        }
        if (this.useRawFrameworkFieldType()) {
            contributionField.addAnnotation(XAnnotationSpecs.suppressWarnings(XAnnotationSpecs.Suppression.RAWTYPES, new XAnnotationSpecs.Suppression[0]));
        }
        this.propertySpec = contributionField.build();
        this.shardImplementation.addField(ComponentImplementation.FieldSpecKind.FRAMEWORK_FIELD, this.propertySpec);
        return this.propertySpec;
    }

    private XTypeName frameworkFieldType(FrameworkField frameworkField) {
        return this.useRawFrameworkFieldType() ? frameworkField.type().getRawTypeName() : frameworkField.type();
    }

    private boolean useRawFrameworkFieldType() {
        return !this.shardImplementation.isTypeAccessible(this.binding.key().type().xprocessing());
    }

    private XClassName delegateType() {
        return this.isProvider() ? XTypeNames.DELEGATE_FACTORY : XTypeNames.DELEGATE_PRODUCER;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isProvider() {
        if (!this.binding.bindingType().equals((Object)BindingType.PROVISION)) return false;
        if (this.frameworkInstanceCreationExpression.alternativeFrameworkClass().map(XTypeNames.JAVAX_PROVIDER::equals).orElse(true) == false) return false;
        return true;
    }

    private static enum InitializationState {
        UNINITIALIZED,
        INITIALIZING,
        DELEGATED,
        INITIALIZED;

    }

    static interface FrameworkInstanceCreationExpression {
        public XCodeBlock creationExpression();

        default public Optional<XClassName> alternativeFrameworkClass() {
            return Optional.empty();
        }

        default public Optional<String> preferredFieldName() {
            return Optional.empty();
        }
    }
}

