/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.base.OptionalType;
import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.FrameworkType;
import dagger.internal.codegen.binding.FrameworkTypeMapper;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.writing.BindingRepresentation;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequirementExpressions;
import dagger.internal.codegen.writing.MembersInjectionBindingRepresentation;
import dagger.internal.codegen.writing.ParentComponent;
import dagger.internal.codegen.writing.PerComponentImplementation;
import dagger.internal.codegen.writing.ProductionBindingRepresentation;
import dagger.internal.codegen.writing.ProvisionBindingRepresentation;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.xprocessing.Accessibility;
import dagger.internal.codegen.xprocessing.XCodeBlocks;
import dagger.internal.codegen.xprocessing.XExpression;
import dagger.internal.codegen.xprocessing.XFunSpecs;
import dagger.internal.codegen.xprocessing.XProcessingEnvs;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XFunSpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeKt;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;

@PerComponentImplementation
public final class ComponentRequestRepresentations {
    private final Optional<ComponentRequestRepresentations> parent;
    private final BindingGraph graph;
    private final ComponentImplementation componentImplementation;
    private final ComponentRequirementExpressions componentRequirementExpressions;
    private final MembersInjectionBindingRepresentation.Factory membersInjectionBindingRepresentationFactory;
    private final ProvisionBindingRepresentation.Factory provisionBindingRepresentationFactory;
    private final ProductionBindingRepresentation.Factory productionBindingRepresentationFactory;
    private final Map<Binding, BindingRepresentation> representations = new HashMap<Binding, BindingRepresentation>();
    private final XProcessingEnv processingEnv;
    private final CompilerOptions compilerOptions;

    @Inject
    ComponentRequestRepresentations(@ParentComponent Optional<ComponentRequestRepresentations> parent, BindingGraph graph, ComponentImplementation componentImplementation, ComponentRequirementExpressions componentRequirementExpressions, MembersInjectionBindingRepresentation.Factory membersInjectionBindingRepresentationFactory, ProvisionBindingRepresentation.Factory provisionBindingRepresentationFactory, ProductionBindingRepresentation.Factory productionBindingRepresentationFactory, XProcessingEnv processingEnv, CompilerOptions compilerOptions) {
        this.parent = parent;
        this.graph = graph;
        this.componentImplementation = componentImplementation;
        this.membersInjectionBindingRepresentationFactory = membersInjectionBindingRepresentationFactory;
        this.provisionBindingRepresentationFactory = provisionBindingRepresentationFactory;
        this.productionBindingRepresentationFactory = productionBindingRepresentationFactory;
        this.componentRequirementExpressions = (ComponentRequirementExpressions)Preconditions.checkNotNull((Object)componentRequirementExpressions);
        this.processingEnv = processingEnv;
        this.compilerOptions = compilerOptions;
    }

    public XExpression getDependencyExpression(BindingRequest request, XClassName requestingClass) {
        return this.getRequestRepresentation(request).getDependencyExpression(requestingClass);
    }

    XExpression getDependencyExpressionForComponentMethod(BindingRequest request, ComponentDescriptor.ComponentMethodDescriptor componentMethod, ComponentImplementation componentImplementation) {
        return this.getRequestRepresentation(request).getDependencyExpressionForComponentMethod(componentMethod, componentImplementation);
    }

    XCodeBlock getCreateMethodArgumentsCodeBlock(ContributionBinding binding, XClassName requestingClass) {
        return XCodeBlocks.makeParametersCodeBlock(this.getCreateMethodArgumentsCodeBlocks(binding, requestingClass));
    }

    private ImmutableList<XCodeBlock> getCreateMethodArgumentsCodeBlocks(ContributionBinding binding, XClassName requestingClass) {
        ImmutableList.Builder arguments = ImmutableList.builder();
        if (binding.requiresModuleInstance()) {
            arguments.add((Object)this.componentRequirementExpressions.getExpressionDuringInitialization(ComponentRequirement.forModule(binding.contributingModule().get().getType()), requestingClass));
        }
        binding.dependencies().stream().map(dependency -> ComponentRequestRepresentations.frameworkRequest(binding, dependency)).map(request -> this.getDependencyExpression((BindingRequest)request, requestingClass)).map(XExpression::codeBlock).forEach(arg_0 -> ((ImmutableList.Builder)arguments).add(arg_0));
        return arguments.build();
    }

    private static BindingRequest frameworkRequest(ContributionBinding binding, DependencyRequest dependency) {
        FrameworkType frameworkType = FrameworkTypeMapper.forBindingType(binding.bindingType()).getFrameworkType(dependency.kind());
        return BindingRequest.bindingRequest(dependency.key(), frameworkType);
    }

    XExpression getDependencyArgumentExpression(DependencyRequest dependencyRequest, XClassName requestingClass) {
        XType dependencyType = dependencyRequest.key().type().xprocessing();
        BindingRequest bindingRequest = BindingRequest.bindingRequest(dependencyRequest);
        XExpression dependencyExpression = this.getDependencyExpression(bindingRequest, requestingClass);
        if (dependencyRequest.kind().equals((Object)RequestKind.INSTANCE) && !Accessibility.isTypeAccessibleFrom(dependencyType, requestingClass.getPackageName()) && Accessibility.isRawTypeAccessible(dependencyType, requestingClass.getPackageName())) {
            return dependencyExpression.castTo(dependencyType.getRawType());
        }
        return dependencyExpression;
    }

    public XFunSpec getComponentMethod(ComponentDescriptor.ComponentMethodDescriptor componentMethod) {
        return XFunSpecs.overriding(componentMethod.methodElement(), this.graph.componentTypeElement().getType(), this.compilerOptions).addCode(this.getComponentMethodCodeBlock(componentMethod)).build();
    }

    private XCodeBlock getComponentMethodCodeBlock(ComponentDescriptor.ComponentMethodDescriptor componentMethod) {
        XExpression expression = this.getComponentMethodExpression(componentMethod);
        if (XTypeKt.isVoid(componentMethod.methodElement().getReturnType())) {
            return XCodeBlocks.isEmpty(expression.codeBlock()) ? expression.codeBlock() : XCodeBlock.of("%L;", expression.codeBlock());
        }
        return XCodeBlock.of("return %L;", expression.codeBlock());
    }

    private XExpression getComponentMethodExpression(ComponentDescriptor.ComponentMethodDescriptor componentMethod) {
        Preconditions.checkArgument((boolean)componentMethod.dependencyRequest().isPresent());
        BindingRequest request = BindingRequest.bindingRequest(componentMethod.dependencyRequest().get());
        RequestRepresentation requestRepresentation = this.getRequestRepresentation(request);
        XExpression expression = requestRepresentation.getDependencyExpressionForComponentMethod(componentMethod, this.componentImplementation);
        XType returnType = componentMethod.methodElement().asMemberOf(this.componentImplementation.graph().componentTypeElement().getType()).getReturnType();
        if (XTypeKt.isVoid(returnType)) {
            return expression;
        }
        if (XProcessingEnvs.isPreJava8SourceVersion(this.processingEnv) && (MapType.isMapOfProvider(returnType) || OptionalType.isOptionalProviderType(returnType))) {
            return expression.castTo(returnType.getRawType());
        }
        return !expression.type().isAssignableTo(returnType) ? expression.castTo(returnType) : expression;
    }

    RequestRepresentation getRequestRepresentation(BindingRequest request) {
        Optional<Binding> localBinding;
        Optional<Binding> optional = localBinding = request.isRequestKind(RequestKind.MEMBERS_INJECTION) ? this.graph.localMembersInjectionBinding(request.key()) : this.graph.localContributionBinding(request.key());
        if (localBinding.isPresent()) {
            return this.getBindingRepresentation(localBinding.get()).getRequestRepresentation(request);
        }
        Preconditions.checkArgument((boolean)this.parent.isPresent(), (String)"no expression found for %s", (Object)request);
        return this.parent.get().getRequestRepresentation(request);
    }

    private BindingRepresentation getBindingRepresentation(Binding binding) {
        return Util.reentrantComputeIfAbsent(this.representations, binding, this::getBindingRepresentationUncached);
    }

    private BindingRepresentation getBindingRepresentationUncached(Binding binding) {
        switch (binding.bindingType()) {
            case MEMBERS_INJECTION: {
                return this.membersInjectionBindingRepresentationFactory.create((MembersInjectionBinding)binding);
            }
            case PROVISION: {
                return this.provisionBindingRepresentationFactory.create((ContributionBinding)binding);
            }
            case PRODUCTION: {
                return this.productionBindingRepresentationFactory.create((ContributionBinding)binding);
            }
        }
        throw new AssertionError();
    }
}

