/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.AssistedFactoryBinding;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.AssistedInjectionBinding;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.writing.AssistedInjectionParameters;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.writing.SimpleMethodRequestRepresentation;
import dagger.internal.codegen.xprocessing.Accessibility;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XExpression;
import dagger.internal.codegen.xprocessing.XFunSpecs;
import dagger.internal.codegen.xprocessing.XTypeSpecs;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XParameterSpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeSpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import java.util.Collection;
import java.util.Optional;

final class AssistedFactoryRequestRepresentation
extends RequestRepresentation {
    private final AssistedFactoryBinding binding;
    private final BindingGraph graph;
    private final SimpleMethodRequestRepresentation.Factory simpleMethodRequestRepresentationFactory;
    private final ComponentImplementation componentImplementation;
    private final CompilerOptions compilerOptions;

    @AssistedInject
    AssistedFactoryRequestRepresentation(@Assisted AssistedFactoryBinding binding, BindingGraph graph, ComponentImplementation componentImplementation, SimpleMethodRequestRepresentation.Factory simpleMethodRequestRepresentationFactory, CompilerOptions compilerOptions) {
        this.binding = (AssistedFactoryBinding)Preconditions.checkNotNull((Object)binding);
        this.graph = graph;
        this.componentImplementation = componentImplementation;
        this.simpleMethodRequestRepresentationFactory = simpleMethodRequestRepresentationFactory;
        this.compilerOptions = compilerOptions;
    }

    @Override
    XExpression getDependencyExpression(XClassName requestingClass) {
        Optional<Binding> localBinding = this.graph.localContributionBinding(this.binding.assistedInjectKey());
        Preconditions.checkArgument((boolean)localBinding.isPresent(), (Object)"assisted factory should have a dependency on an assisted injection binding");
        XExpression assistedInjectionExpression = this.simpleMethodRequestRepresentationFactory.create((AssistedInjectionBinding)localBinding.get()).getDependencyExpression(requestingClass.peerClass(""));
        return XExpression.create(assistedInjectionExpression.type(), XCodeBlock.of("%L", this.anonymousfactoryImpl(localBinding.get(), assistedInjectionExpression)));
    }

    private XTypeSpec anonymousfactoryImpl(Binding assistedBinding, XExpression assistedInjectionExpression) {
        XTypeElement factory = XElements.asTypeElement(this.binding.bindingElement().get());
        XType factoryType = this.binding.key().type().xprocessing();
        XMethodElement factoryMethod = AssistedInjectionAnnotations.assistedFactoryMethod(factory);
        XType returnType = factoryMethod.asMemberOf(factoryType).getReturnType();
        ComponentImplementation.ShardImplementation shardImplementation = this.componentImplementation.shardImplementation(assistedBinding);
        XTypeSpecs.Builder builder = XTypeSpecs.anonymousClassBuilder().addFunction(XFunSpecs.overridingWithoutParameters(factoryMethod, factoryType, this.compilerOptions).addParameters((Collection<XParameterSpec>)AssistedInjectionParameters.assistedFactoryParameterSpecs(this.binding, shardImplementation)).addStatement("return %L", this.requiresCast(returnType, shardImplementation.name()) ? assistedInjectionExpression.castTo(returnType).codeBlock() : assistedInjectionExpression.codeBlock()).build());
        if (factory.isInterface()) {
            builder.addSuperinterface(factoryType.asTypeName());
        } else {
            builder.superclass(factoryType.asTypeName());
        }
        return builder.build();
    }

    private boolean requiresCast(XType returnType, XClassName requestingClass) {
        return !Accessibility.isTypeAccessibleFrom(returnType, requestingClass.getPackageName());
    }

    @AssistedFactory
    static interface Factory {
        public AssistedFactoryRequestRepresentation create(AssistedFactoryBinding var1);
    }
}

