/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.AnnotationExpression;
import dagger.internal.codegen.xprocessing.XCodeBlocks;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XFunSpecs;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypeSpecs;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XFunSpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeSpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeKt;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.compat.XConverters;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

public class AnnotationCreatorGenerator
extends SourceFileGenerator<XTypeElement> {
    private static final XClassName AUTO_ANNOTATION = XClassName.get("com.google.auto.value", "AutoAnnotation");

    @Inject
    AnnotationCreatorGenerator(XFiler filer, XProcessingEnv processingEnv) {
        super(filer, processingEnv);
    }

    @Override
    public XElement originatingElement(XTypeElement annotationType) {
        return annotationType;
    }

    @Override
    public ImmutableList<XTypeSpec> topLevelTypes(XTypeElement annotationType) {
        XClassName generatedTypeName = AnnotationExpression.getAnnotationCreatorClassName(annotationType);
        XTypeSpecs.Builder annotationCreatorBuilder = XTypeSpecs.classBuilder(generatedTypeName).addModifiers(Modifier.PUBLIC, Modifier.FINAL).addFunction(XFunSpecs.constructorBuilder().addModifiers(Modifier.PRIVATE).build());
        for (XTypeElement annotationElement : this.annotationsToCreate(annotationType)) {
            annotationCreatorBuilder.addFunction(this.buildCreateMethod(generatedTypeName, annotationElement));
        }
        return ImmutableList.of((Object)annotationCreatorBuilder.build());
    }

    private XFunSpec buildCreateMethod(XClassName generatedTypeName, XTypeElement annotationElement) {
        String createMethodName = AnnotationExpression.createMethodName(annotationElement);
        XFunSpecs.Builder createMethod = XFunSpecs.methodBuilder(createMethodName).addAnnotation(AUTO_ANNOTATION).addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(annotationElement.getType().asTypeName());
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (XMethodElement annotationMember : annotationElement.getDeclaredMethods()) {
            String parameterName = XElements.getSimpleName(annotationMember);
            XTypeName parameterType = this.maybeRewrapKClass(annotationMember.getReturnType()).asTypeName();
            createMethod.addParameter(parameterName, parameterType);
            parameters.add((Object)XCodeBlock.of("%N", parameterName));
        }
        XClassName autoAnnotationClass = generatedTypeName.peerClass("AutoAnnotation_" + generatedTypeName.getSimpleName() + "_" + createMethodName);
        createMethod.addStatement("return %L", XCodeBlock.ofNewInstance(autoAnnotationClass, "%L", XCodeBlocks.makeParametersCodeBlock((Iterable<XCodeBlock>)parameters.build())));
        return createMethod.build();
    }

    protected Set<XTypeElement> annotationsToCreate(XTypeElement annotationElement) {
        return AnnotationCreatorGenerator.nestedAnnotationElements(annotationElement, new LinkedHashSet<XTypeElement>());
    }

    @CanIgnoreReturnValue
    private static Set<XTypeElement> nestedAnnotationElements(XTypeElement annotationElement, Set<XTypeElement> annotationElements) {
        if (annotationElements.add(annotationElement)) {
            for (XMethodElement method : annotationElement.getDeclaredMethods()) {
                XType returnType = method.getReturnType();
                XTypeElement maybeAnnotationType = XTypeKt.isArray(returnType) ? XTypes.asArray(returnType).getComponentType().getTypeElement() : returnType.getTypeElement();
                if (maybeAnnotationType == null || !maybeAnnotationType.isAnnotationClass()) continue;
                AnnotationCreatorGenerator.nestedAnnotationElements(maybeAnnotationType, annotationElements);
            }
        }
        return annotationElements;
    }

    private XType maybeRewrapKClass(XType type) {
        return XTypeKt.isArray(type) ? XConverters.getProcessingEnv(type).getArrayType(this.maybeRewrapKClass(XTypes.asArray(type).getComponentType())) : (XTypes.isTypeOf(type, XTypeNames.KCLASS) ? XTypes.rewrapType(type, XTypeNames.CLASS) : type);
    }
}

