/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.compileroption.ValidationType;
import dagger.internal.codegen.model.BindingGraph;
import dagger.internal.codegen.validation.ExternalBindingGraphPlugins;
import dagger.internal.codegen.validation.ValidationBindingGraphPlugins;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class BindingGraphValidator {
    private final ValidationBindingGraphPlugins validationPlugins;
    private final ExternalBindingGraphPlugins externalPlugins;
    private final CompilerOptions compilerOptions;

    @Inject
    BindingGraphValidator(ValidationBindingGraphPlugins validationPlugins, ExternalBindingGraphPlugins externalPlugins, CompilerOptions compilerOptions) {
        this.validationPlugins = validationPlugins;
        this.externalPlugins = externalPlugins;
        this.compilerOptions = compilerOptions;
    }

    public boolean shouldDoFullBindingGraphValidation(XTypeElement component) {
        return this.requiresFullBindingGraphValidation() || this.compilerOptions.pluginsVisitFullBindingGraphs(component);
    }

    private boolean requiresFullBindingGraphValidation() {
        return !this.compilerOptions.fullBindingGraphValidationType().equals((Object)ValidationType.NONE);
    }

    public boolean isValid(BindingGraph fullGraph) {
        return this.visitValidationPlugins((Optional<BindingGraph>)Optional.absent(), (Supplier<BindingGraph>)((Supplier)() -> fullGraph)) && this.visitExternalPlugins(fullGraph);
    }

    public boolean isValid(BindingGraph prunedGraph, Supplier<BindingGraph> fullGraphSupplier) {
        return this.visitValidationPlugins((Optional<BindingGraph>)Optional.of((Object)prunedGraph), fullGraphSupplier) && this.visitExternalPlugins(prunedGraph);
    }

    private boolean visitValidationPlugins(Optional<BindingGraph> prunedGraph, Supplier<BindingGraph> fullGraphSupplier) {
        if (!prunedGraph.isPresent() && !this.requiresFullBindingGraphValidation()) {
            return true;
        }
        return this.validationPlugins.visit(prunedGraph, fullGraphSupplier);
    }

    private boolean visitExternalPlugins(BindingGraph graph) {
        if (graph.isFullBindingGraph() && !this.requiresFullBindingGraphValidation() && !this.compilerOptions.pluginsVisitFullBindingGraphs(graph.rootComponentNode().componentPath().currentComponent().xprocessing())) {
            return true;
        }
        return this.externalPlugins.visit(graph);
    }
}

