/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.base.Preconditions;
import dagger.internal.codegen.base.ClearableCache;
import dagger.internal.codegen.base.ValidationReport;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XExecutableParameterElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class AssistedValidator
implements ClearableCache {
    private final InjectionAnnotations injectionAnnotations;
    private final Map<XExecutableParameterElement, ValidationReport> cache = new HashMap<XExecutableParameterElement, ValidationReport>();

    @Inject
    AssistedValidator(InjectionAnnotations injectionAnnotations) {
        this.injectionAnnotations = injectionAnnotations;
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }

    public boolean containsCache(XExecutableParameterElement assisted) {
        return this.cache.containsKey(assisted);
    }

    public ValidationReport validate(XExecutableParameterElement assisted) {
        Preconditions.checkArgument((boolean)assisted.hasAnnotation(XTypeNames.ASSISTED));
        return this.cache.computeIfAbsent(assisted, this::validateUncached);
    }

    private ValidationReport validateUncached(XExecutableParameterElement assisted) {
        ValidationReport.Builder report = ValidationReport.about(assisted);
        XExecutableElement enclosingElement = assisted.getEnclosingElement();
        if (!(this.isAssistedInjectConstructor(enclosingElement) || this.isAssistedFactoryCreateMethod(enclosingElement) || this.isKotlinDataClassCopyMethod(enclosingElement))) {
            report.addError("@Assisted parameters can only be used within an @AssistedInject-annotated constructor.", assisted);
        }
        this.injectionAnnotations.getQualifiers(assisted).forEach(qualifier -> report.addError("Qualifiers cannot be used with @Assisted parameters.", assisted, (XAnnotation)qualifier));
        return report.build();
    }

    private boolean isAssistedInjectConstructor(XExecutableElement executableElement) {
        return XElementKt.isConstructor(executableElement) && executableElement.hasAnnotation(XTypeNames.ASSISTED_INJECT);
    }

    private boolean isAssistedFactoryCreateMethod(XExecutableElement executableElement) {
        if (XElementKt.isMethod(executableElement)) {
            XTypeElement enclosingElement = XElements.closestEnclosingTypeElement(executableElement);
            return AssistedInjectionAnnotations.isAssistedFactoryType(enclosingElement) && AssistedInjectionAnnotations.assistedFactoryMethod(enclosingElement).equals(executableElement);
        }
        return false;
    }

    private boolean isKotlinDataClassCopyMethod(XExecutableElement executableElement) {
        return XElementKt.isMethod(executableElement) && XElements.getSimpleName(XElements.asMethod(executableElement)).contentEquals("copy") && XElements.closestEnclosingTypeElement(executableElement.getEnclosingElement()).isDataClass();
    }
}

