/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.processingstep;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.base.DaggerSuperficialValidation;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.base.ValidationReport;
import dagger.internal.codegen.binding.AssistedFactoryBinding;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.AssistedInjectionBinding;
import dagger.internal.codegen.binding.BindingFactory;
import dagger.internal.codegen.binding.MethodSignatureFormatter;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.processingstep.TypeCheckingProcessingStep;
import dagger.internal.codegen.validation.InjectValidator;
import dagger.internal.codegen.xprocessing.Accessibility;
import dagger.internal.codegen.xprocessing.XCodeBlocks;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XFunSpecs;
import dagger.internal.codegen.xprocessing.XMethodElements;
import dagger.internal.codegen.xprocessing.XProcessingEnvs;
import dagger.internal.codegen.xprocessing.XPropertySpecs;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypeSpecs;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XFunSpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeSpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XConstructorElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XMessager;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XVariableElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

final class AssistedFactoryProcessingStep
extends TypeCheckingProcessingStep<XTypeElement> {
    private final XProcessingEnv processingEnv;
    private final XMessager messager;
    private final XFiler filer;
    private final BindingFactory bindingFactory;
    private final MethodSignatureFormatter methodSignatureFormatter;
    private final DaggerSuperficialValidation superficialValidation;
    private final InjectValidator injectValidator;

    @Inject
    AssistedFactoryProcessingStep(XProcessingEnv processingEnv, XMessager messager, XFiler filer, BindingFactory bindingFactory, MethodSignatureFormatter methodSignatureFormatter, DaggerSuperficialValidation superficialValidation, InjectValidator injectValidator) {
        this.processingEnv = processingEnv;
        this.messager = messager;
        this.filer = filer;
        this.bindingFactory = bindingFactory;
        this.methodSignatureFormatter = methodSignatureFormatter;
        this.superficialValidation = superficialValidation;
        this.injectValidator = injectValidator;
    }

    @Override
    protected boolean requiresPreValidation() {
        return false;
    }

    public ImmutableSet<XClassName> annotationClassNames() {
        return ImmutableSet.of((Object)XTypeNames.ASSISTED_FACTORY);
    }

    @Override
    protected void process(XTypeElement factory, ImmutableSet<XClassName> annotations) {
        ValidationReport report = new AssistedFactoryValidator().validate(factory);
        report.printMessagesTo(this.messager);
        if (report.isClean()) {
            new AssistedFactoryImplGenerator().generate(this.bindingFactory.assistedFactoryBinding(factory, Optional.empty()));
        }
    }

    private final class AssistedFactoryValidator {
        private AssistedFactoryValidator() {
        }

        ValidationReport validate(XTypeElement factory) {
            ImmutableSet<XMethodElement> abstractFactoryMethods;
            ValidationReport.Builder report = ValidationReport.about(factory);
            if (!factory.isAbstract()) {
                return report.addError("The @AssistedFactory-annotated type must be either an abstract class or interface.", factory).build();
            }
            if (factory.isNested() && !factory.isStatic()) {
                report.addError("Nested @AssistedFactory-annotated types must be static. ", factory);
            }
            if ((abstractFactoryMethods = AssistedInjectionAnnotations.assistedFactoryMethods(factory)).isEmpty()) {
                report.addError("The @AssistedFactory-annotated type is missing an abstract, non-default method whose return type matches the assisted injection type.", factory);
            }
            for (XMethodElement method : abstractFactoryMethods) {
                ValidationReport injectReport;
                AssistedFactoryProcessingStep.this.superficialValidation.validateElement(method);
                XType returnType = method.asMemberOf(factory.getType()).getReturnType();
                if (XTypes.isDeclared(returnType) && !(injectReport = AssistedFactoryProcessingStep.this.injectValidator.validate(returnType.getTypeElement())).isClean()) {
                    report.addSubreport(injectReport);
                }
                if (!this.isAssistedInjectionType(returnType)) {
                    report.addError(String.format("Invalid return type: %s. An assisted factory's abstract method must return a type with an @AssistedInject-annotated constructor.", XTypes.toStableString(returnType)), method);
                }
                if (!XMethodElements.hasTypeParameters(method)) continue;
                report.addError("@AssistedFactory does not currently support type parameters in the creator method. See https://github.com/google/dagger/issues/2279", method);
            }
            if (abstractFactoryMethods.size() > 1) {
                report.addError("The @AssistedFactory-annotated type should contain a single abstract, non-default method but found multiple: " + abstractFactoryMethods.stream().map(AssistedFactoryProcessingStep.this.methodSignatureFormatter::formatWithoutReturnType).collect(DaggerStreams.toImmutableList()), factory);
            }
            if (!report.build().isClean()) {
                return report.build();
            }
            AssistedInjectionAnnotations.AssistedFactoryMetadata metadata = AssistedInjectionAnnotations.AssistedFactoryMetadata.create(factory.getType());
            HashSet<AssistedInjectionAnnotations.AssistedParameter> uniqueAssistedParameters = new HashSet<AssistedInjectionAnnotations.AssistedParameter>();
            for (AssistedInjectionAnnotations.AssistedParameter assistedParameter : metadata.assistedFactoryAssistedParameters()) {
                if (uniqueAssistedParameters.add(assistedParameter)) continue;
                report.addError("@AssistedFactory method has duplicate @Assisted types: " + assistedParameter, assistedParameter.element());
            }
            if (!ImmutableSet.copyOf(metadata.assistedInjectAssistedParameters()).equals((Object)ImmutableSet.copyOf(metadata.assistedFactoryAssistedParameters()))) {
                report.addError(String.format("The parameters in the factory method must match the @Assisted parameters in %s.\n    Actual: %s#%s(%s)\n  Expected: %s#%s(%s)", XTypes.toStableString(metadata.assistedInjectType()), metadata.factory().getQualifiedName(), XElements.getSimpleName(metadata.factoryMethod()), metadata.factoryMethod().getParameters().stream().map(XVariableElement::getType).map(XTypes::toStableString).collect(Collectors.joining(", ")), metadata.factory().getQualifiedName(), XElements.getSimpleName(metadata.factoryMethod()), metadata.assistedInjectAssistedParameters().stream().map(AssistedInjectionAnnotations.AssistedParameter::type).map(XTypes::toStableString).collect(Collectors.joining(", "))), metadata.factoryMethod());
            }
            return report.build();
        }

        private boolean isAssistedInjectionType(XType type) {
            return XTypes.isDeclared(type) && AssistedInjectionAnnotations.isAssistedInjectionType(type.getTypeElement());
        }
    }

    private final class AssistedFactoryImplGenerator
    extends SourceFileGenerator<AssistedFactoryBinding> {
        AssistedFactoryImplGenerator() {
            super(AssistedFactoryProcessingStep.this.filer, AssistedFactoryProcessingStep.this.processingEnv);
        }

        @Override
        public XElement originatingElement(AssistedFactoryBinding binding) {
            return binding.bindingElement().get();
        }

        @Override
        public ImmutableList<XTypeSpec> topLevelTypes(AssistedFactoryBinding binding) {
            XTypeElement factory = XElements.asTypeElement(binding.bindingElement().get());
            XClassName generatedClassName = SourceFiles.generatedClassNameForBinding(binding);
            XTypeSpecs.Builder builder = XTypeSpecs.classBuilder(generatedClassName).addModifiers(Modifier.PUBLIC, Modifier.FINAL).addTypeVariableNames((Collection<XTypeName>)XTypeElements.typeVariableNames(factory));
            if (factory.isInterface()) {
                builder.addSuperinterface(factory.getType().asTypeName());
            } else {
                builder.superclass(factory.getType().asTypeName());
            }
            AssistedInjectionAnnotations.AssistedFactoryMetadata metadata = AssistedInjectionAnnotations.AssistedFactoryMetadata.create(factory.getType());
            String delegateName = "delegateFactory";
            XTypeName delegateType = this.delegateFactoryTypeName(metadata.assistedInjectType());
            builder.addProperty(XPropertySpecs.of(delegateName, delegateType, Modifier.PRIVATE, Modifier.FINAL)).addFunction(XFunSpecs.constructorBuilder().addParameter(delegateName, delegateType).addStatement("this.%1N = %1N", delegateName).build()).addFunction(this.createMethod(metadata, delegateName)).addFunction(this.staticCreateMethod("create", XTypeNames.javaxProviderOf(this.accessibleFactoryTypeName(factory)), generatedClassName, metadata, delegateName, delegateType)).addFunction(this.staticCreateMethod("createFactoryProvider", XTypeNames.daggerProviderOf(this.accessibleFactoryTypeName(factory)), generatedClassName, metadata, delegateName, delegateType));
            return ImmutableList.of((Object)builder.build());
        }

        private XFunSpec staticCreateMethod(String methodName, XTypeName returnType, XClassName generatedClassName, AssistedInjectionAnnotations.AssistedFactoryMetadata metadata, String delegateName, XTypeName delegateType) {
            return XFunSpecs.methodBuilder(methodName).addModifiers(Modifier.PUBLIC, Modifier.STATIC).addParameter(delegateName, delegateType).addTypeVariableNames((Collection<XTypeName>)XTypeElements.typeVariableNames(metadata.assistedInjectElement())).returns(returnType).addStatement("return %T.%Lcreate(%L)", XTypeNames.INSTANCE_FACTORY, XProcessingEnvs.isPreJava8SourceVersion(AssistedFactoryProcessingStep.this.processingEnv) ? XCodeBlock.of("<%T>", Accessibility.accessibleTypeName(metadata.factoryType(), generatedClassName, AssistedFactoryProcessingStep.this.processingEnv)) : XCodeBlock.of("", new Object[0]), XCodeBlock.ofNewInstance(generatedClassName, "%N", delegateName)).build();
        }

        private XTypeName accessibleFactoryTypeName(XTypeElement factory) {
            return factory.getType().asTypeName();
        }

        private XFunSpec createMethod(AssistedInjectionAnnotations.AssistedFactoryMetadata metadata, String delegateName) {
            Object[] objectArray = new Object[2];
            objectArray[0] = delegateName;
            objectArray[1] = metadata.assistedInjectAssistedParameters().stream().map(arg_0 -> metadata.assistedFactoryAssistedParametersMap().get(arg_0)).map(param -> XCodeBlock.of("%N", param.getJvmName())).collect(XCodeBlocks.toParametersCodeBlock());
            XCodeBlock instance = XCodeBlock.of("%N.get(%L)", objectArray);
            return XFunSpecs.overriding(metadata.factoryMethod(), metadata.factoryType(), AssistedFactoryProcessingStep.this.compilerOptions).addStatement("return %L", instance).build();
        }

        private XTypeName delegateFactoryTypeName(XType assistedInjectType) {
            AssistedInjectionBinding binding = AssistedFactoryProcessingStep.this.bindingFactory.assistedInjectionBinding((XConstructorElement)Iterables.getOnlyElement(AssistedInjectionAnnotations.assistedInjectedConstructors(assistedInjectType.getTypeElement())), Optional.empty());
            XClassName generatedFactoryClassName = SourceFiles.generatedClassNameForBinding(binding);
            return assistedInjectType.getTypeArguments().isEmpty() ? generatedFactoryClassName : generatedFactoryClassName.parametrizedBy((XTypeName[])((ImmutableList)assistedInjectType.getTypeArguments().stream().map(XType::asTypeName).collect(DaggerStreams.toImmutableList())).toArray((Object[])new XTypeName[0]));
        }
    }
}

