/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.model;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import dagger.internal.codegen.model.AutoValue_Scope;
import dagger.internal.codegen.model.DaggerAnnotation;
import dagger.internal.codegen.model.DaggerTypeElement;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;

@AutoValue
public abstract class Scope {
    private static final XClassName PRODUCTION_SCOPE = XClassName.get("dagger.producers", "ProductionScope");
    private static final XClassName SINGLETON = XClassName.get("jakarta.inject", "Singleton");
    private static final XClassName SINGLETON_JAVAX = XClassName.get("javax.inject", "Singleton");
    private static final XClassName REUSABLE = XClassName.get("dagger", "Reusable");
    private static final XClassName SCOPE = XClassName.get("jakarta.inject", "Scope");
    private static final XClassName SCOPE_JAVAX = XClassName.get("javax.inject", "Scope");

    public static Scope scope(DaggerAnnotation scopeAnnotation) {
        Preconditions.checkArgument((boolean)Scope.isScope(scopeAnnotation));
        return new AutoValue_Scope(scopeAnnotation);
    }

    public static boolean isScope(DaggerAnnotation scopeAnnotation) {
        return Scope.isScope(scopeAnnotation.annotationTypeElement());
    }

    public static boolean isScope(DaggerTypeElement scopeAnnotationType) {
        return scopeAnnotationType.xprocessing().hasAnnotation(SCOPE) || scopeAnnotationType.xprocessing().hasAnnotation(SCOPE_JAVAX);
    }

    public abstract DaggerAnnotation scopeAnnotation();

    public final boolean isSingleton() {
        return this.isScope(SINGLETON) || this.isScope(SINGLETON_JAVAX);
    }

    public final boolean isReusable() {
        return this.isScope(REUSABLE);
    }

    public final boolean isProductionScope() {
        return this.isScope(PRODUCTION_SCOPE);
    }

    private boolean isScope(XClassName annotation) {
        return XAnnotations.asClassName(this.scopeAnnotation().xprocessing()).equals(annotation);
    }

    public final String toString() {
        return this.scopeAnnotation().toString();
    }
}

