/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.kotlin;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.kotlin.FunctionMetadata;
import dagger.internal.codegen.kotlin.KotlinMetadataFactory;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XFieldElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import javax.inject.Inject;

public final class KotlinMetadataUtil {
    private final KotlinMetadataFactory metadataFactory;

    @Inject
    KotlinMetadataUtil(KotlinMetadataFactory metadataFactory) {
        this.metadataFactory = metadataFactory;
    }

    public boolean hasMetadata(XElement element) {
        return XElements.closestEnclosingTypeElement(element).hasAnnotation(XTypeNames.KOTLIN_METADATA);
    }

    public ImmutableSet<XAnnotation> getSyntheticPropertyAnnotations(XFieldElement fieldElement, XClassName annotationType) {
        return this.metadataFactory.create(fieldElement).getSyntheticAnnotationMethod(fieldElement).map(methodElement -> methodElement.getAnnotationsAnnotatedWith(annotationType)).map(ImmutableSet::copyOf).orElse(ImmutableSet.of());
    }

    public boolean isMissingSyntheticPropertyForAnnotations(XFieldElement fieldElement) {
        return this.metadataFactory.create(fieldElement).isMissingSyntheticAnnotationMethod(fieldElement);
    }

    public ImmutableMap<String, String> getAllMethodNamesBySignature(XTypeElement element) {
        Preconditions.checkState((boolean)this.hasMetadata(element), (Object)"Can not call getAllMethodNamesBySignature for non-Kotlin class");
        return (ImmutableMap)this.metadataFactory.create(element).classMetadata().getFunctionsBySignature().values().stream().collect(DaggerStreams.toImmutableMap(FunctionMetadata::getSignature, FunctionMetadata::getName));
    }
}

