/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.componentgenerator;

import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import dagger.internal.codegen.base.ComponentCreatorKind;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.ComponentCreatorDescriptor;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.MethodSignature;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.writing.ComponentNames;
import dagger.internal.codegen.xprocessing.Accessibility;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XFunSpecs;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypeSpecs;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XFunSpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeSpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XExecutableParameterElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import java.util.HashSet;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

final class ComponentHjarGenerator
extends SourceFileGenerator<ComponentDescriptor> {
    private final XProcessingEnv processingEnv;
    private final CompilerOptions compilerOptions;

    @Inject
    ComponentHjarGenerator(XFiler filer, XProcessingEnv processingEnv, CompilerOptions compilerOptions) {
        super(filer, processingEnv);
        this.processingEnv = processingEnv;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public XElement originatingElement(ComponentDescriptor input) {
        return input.typeElement();
    }

    @Override
    public ImmutableList<XTypeSpec> topLevelTypes(ComponentDescriptor componentDescriptor) {
        boolean noArgFactoryMethod;
        ComponentCreatorKind creatorKind;
        XClassName builderMethodReturnType;
        XClassName generatedTypeName = ComponentNames.getTopLevelClassName(componentDescriptor);
        XTypeSpecs.Builder generatedComponent = XTypeSpecs.classBuilder(generatedTypeName).addModifiers(Modifier.FINAL).addFunction(ComponentHjarGenerator.privateConstructor());
        if (componentDescriptor.typeElement().isPublic()) {
            generatedComponent.addModifiers(Modifier.PUBLIC);
        }
        XTypeElement componentElement = componentDescriptor.typeElement();
        if (this.compilerOptions.generatedClassExtendsComponent()) {
            generatedComponent.superType(componentElement);
        }
        if (componentDescriptor.creatorDescriptor().isPresent()) {
            ComponentCreatorDescriptor creatorDescriptor = componentDescriptor.creatorDescriptor().get();
            builderMethodReturnType = creatorDescriptor.typeElement().asClassName();
            creatorKind = creatorDescriptor.kind();
            noArgFactoryMethod = creatorDescriptor.factoryParameters().isEmpty();
        } else {
            XClassName builderClassName;
            XTypeSpecs.Builder builder = XTypeSpecs.classBuilder("Builder").addModifiers(Modifier.STATIC, Modifier.FINAL).addFunction(ComponentHjarGenerator.privateConstructor());
            if (componentDescriptor.typeElement().isPublic()) {
                builder.addModifiers(Modifier.PUBLIC);
            }
            builderMethodReturnType = builderClassName = generatedTypeName.nestedClass("Builder");
            creatorKind = ComponentCreatorKind.BUILDER;
            noArgFactoryMethod = true;
            ComponentHjarGenerator.componentRequirements(componentDescriptor).map(requirement -> ComponentHjarGenerator.builderSetterMethod(requirement.typeElement(), builderClassName)).forEach(builder::addFunction);
            builder.addFunction(ComponentHjarGenerator.builderBuildMethod(componentDescriptor));
            generatedComponent.addType(builder.build());
        }
        generatedComponent.addFunction(ComponentHjarGenerator.staticCreatorMethod(builderMethodReturnType, creatorKind));
        if (noArgFactoryMethod && !this.hasBindsInstanceMethods(componentDescriptor) && ComponentHjarGenerator.componentRequirements(componentDescriptor).noneMatch(ComponentRequirement::requiresAPassedInstance)) {
            generatedComponent.addFunction(ComponentHjarGenerator.createMethod(componentDescriptor));
        }
        if (this.compilerOptions.generatedClassExtendsComponent()) {
            XType componentType = componentElement.getType();
            HashSet methodSignatures = Sets.newHashSetWithExpectedSize((int)componentDescriptor.componentMethods().size());
            componentDescriptor.componentMethods().stream().filter(method -> methodSignatures.add(MethodSignature.forComponentMethod(method, componentType, this.processingEnv))).forEach(method -> generatedComponent.addFunction(this.emptyComponentMethod(componentElement, method.methodElement())));
            if (componentDescriptor.isProduction()) {
                generatedComponent.addSuperinterface(XTypeNames.CANCELLATION_LISTENER).addFunction(ComponentHjarGenerator.onProducerFutureCancelledMethod());
            }
        }
        return ImmutableList.of((Object)generatedComponent.build());
    }

    private XFunSpec emptyComponentMethod(XTypeElement typeElement, XMethodElement baseMethod) {
        return XFunSpecs.overriding(baseMethod, typeElement.getType(), this.compilerOptions).build();
    }

    private static XFunSpec privateConstructor() {
        return XFunSpecs.constructorBuilder().addModifiers(Modifier.PRIVATE).build();
    }

    private static Stream<ComponentRequirement> componentRequirements(ComponentDescriptor component) {
        Preconditions.checkArgument((!component.isSubcomponent() ? 1 : 0) != 0);
        return Stream.concat(component.dependencies().stream(), component.modules().stream().filter(module -> !module.moduleElement().isAbstract() && Accessibility.isElementAccessibleFrom((XElement)module.moduleElement(), component.typeElement().getClassName().packageName())).map(module -> ComponentRequirement.forModule(module.moduleElement().getType())).filter(requirement -> component.creatorDescriptor().isPresent() || requirement.requiresModuleInstance()));
    }

    private boolean hasBindsInstanceMethods(ComponentDescriptor componentDescriptor) {
        return componentDescriptor.creatorDescriptor().isPresent() && XTypeElements.getAllUnimplementedMethods(componentDescriptor.creatorDescriptor().get().typeElement()).stream().anyMatch(method -> ComponentHjarGenerator.isBindsInstance(method));
    }

    private static boolean isBindsInstance(XMethodElement method) {
        return method.hasAnnotation(XTypeNames.BINDS_INSTANCE) || method.getParameters().size() == 1 && ((XExecutableParameterElement)Iterables.getOnlyElement(method.getParameters())).hasAnnotation(XTypeNames.BINDS_INSTANCE);
    }

    private static XFunSpec builderSetterMethod(XTypeElement componentRequirement, XClassName builderClass) {
        String simpleName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, XElements.getSimpleName(componentRequirement));
        return XFunSpecs.methodBuilder(simpleName).addModifiers(Modifier.PUBLIC).addParameter(simpleName, (XTypeName)componentRequirement.asClassName()).returns(builderClass).build();
    }

    private static XFunSpec builderBuildMethod(ComponentDescriptor component) {
        return XFunSpecs.methodBuilder("build").addModifiers(Modifier.PUBLIC).returns(component.typeElement().asClassName()).build();
    }

    private static XFunSpec staticCreatorMethod(XTypeName creatorMethodReturnType, ComponentCreatorKind creatorKind) {
        return XFunSpecs.methodBuilder(Ascii.toLowerCase((String)creatorKind.typeName())).addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(creatorMethodReturnType).build();
    }

    private static XFunSpec createMethod(ComponentDescriptor componentDescriptor) {
        return XFunSpecs.methodBuilder("create").addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(componentDescriptor.typeElement().asClassName()).build();
    }

    private static XFunSpec onProducerFutureCancelledMethod() {
        return XFunSpecs.methodBuilder("onProducerFutureCancelled").addModifiers(Modifier.PUBLIC).addParameter("mayInterruptIfRunning", XTypeName.PRIMITIVE_BOOLEAN).build();
    }
}

