/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.bindinggraphvalidation;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.binding.ComponentNodeImpl;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.model.BindingGraph;
import dagger.internal.codegen.model.DiagnosticReporter;
import dagger.internal.codegen.validation.ValidationBindingGraphPlugin;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XExecutableType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.tools.Diagnostic;

final class SubcomponentFactoryMethodValidator
extends ValidationBindingGraphPlugin {
    private final Map<BindingGraph.ComponentNode, Set<XTypeElement>> inheritedModulesCache = new HashMap<BindingGraph.ComponentNode, Set<XTypeElement>>();

    @Inject
    SubcomponentFactoryMethodValidator() {
    }

    @Override
    public String pluginName() {
        return "Dagger/SubcomponentFactoryMethodMissingModule";
    }

    @Override
    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        if (!bindingGraph.rootComponentNode().isRealComponent() || bindingGraph.rootComponentNode().isSubcomponent()) {
            return;
        }
        bindingGraph.network().edges().stream().flatMap(DaggerStreams.instancesOf(BindingGraph.ChildFactoryMethodEdge.class)).forEach(edge -> {
            ImmutableSet<XTypeElement> missingModules = this.findMissingModules((BindingGraph.ChildFactoryMethodEdge)edge, bindingGraph);
            if (!missingModules.isEmpty()) {
                this.reportMissingModuleParameters((BindingGraph.ChildFactoryMethodEdge)edge, missingModules, bindingGraph, diagnosticReporter);
            }
        });
    }

    private ImmutableSet<XTypeElement> findMissingModules(BindingGraph.ChildFactoryMethodEdge edge, BindingGraph graph) {
        ImmutableSet<XTypeElement> factoryMethodParameters = this.subgraphFactoryMethodParameters(edge, graph);
        BindingGraph.ComponentNode child = (BindingGraph.ComponentNode)graph.network().incidentNodes((Object)edge).target();
        Sets.SetView<XTypeElement> modulesOwnedByChild = this.ownedModules(child, graph);
        return (ImmutableSet)graph.bindings().stream().filter(binding -> binding.componentPath().equals(child.componentPath())).filter(binding -> binding.requiresModuleInstance()).map(binding -> binding.contributingModule().get().xprocessing()).distinct().filter(module -> modulesOwnedByChild.contains(module)).filter(module -> !factoryMethodParameters.contains(module)).filter(moduleType -> !ComponentRequirement.componentCanMakeNewInstances(moduleType)).collect(DaggerStreams.toImmutableSet());
    }

    private ImmutableSet<XTypeElement> subgraphFactoryMethodParameters(BindingGraph.ChildFactoryMethodEdge edge, BindingGraph bindingGraph) {
        BindingGraph.ComponentNode parent = (BindingGraph.ComponentNode)bindingGraph.network().incidentNodes((Object)edge).source();
        XType parentType = parent.componentPath().currentComponent().xprocessing().getType();
        XExecutableType factoryMethodType = edge.factoryMethod().xprocessing().asMemberOf(parentType);
        return (ImmutableSet)factoryMethodType.getParameterTypes().stream().map(XType::getTypeElement).collect(DaggerStreams.toImmutableSet());
    }

    private Sets.SetView<XTypeElement> ownedModules(BindingGraph.ComponentNode component, BindingGraph graph) {
        return Sets.difference(((ComponentNodeImpl)component).componentDescriptor().moduleTypes(), this.inheritedModules(component, graph));
    }

    private Set<XTypeElement> inheritedModules(BindingGraph.ComponentNode component, BindingGraph graph) {
        return Util.reentrantComputeIfAbsent(this.inheritedModulesCache, component, this.uncachedInheritedModules(graph));
    }

    private Function<BindingGraph.ComponentNode, Set<XTypeElement>> uncachedInheritedModules(BindingGraph graph) {
        return componentNode -> componentNode.componentPath().atRoot() ? ImmutableSet.of() : (Set)graph.componentNode(componentNode.componentPath().parent()).map(parent -> Sets.union(this.ownedModules((BindingGraph.ComponentNode)parent, graph), this.inheritedModules((BindingGraph.ComponentNode)parent, graph))).get();
    }

    private void reportMissingModuleParameters(BindingGraph.ChildFactoryMethodEdge edge, ImmutableSet<XTypeElement> missingModules, BindingGraph graph, DiagnosticReporter diagnosticReporter) {
        diagnosticReporter.reportSubcomponentFactoryMethod(Diagnostic.Kind.ERROR, edge, "%s requires modules which have no visible default constructors. Add the following modules as parameters to this method: %s", ((BindingGraph.Node)graph.network().incidentNodes((Object)edge).target()).componentPath().currentComponent().xprocessing().getQualifiedName(), missingModules.stream().map(XTypeElement::getQualifiedName).collect(Collectors.joining(", ")));
    }
}

