/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.bindinggraphvalidation;

import dagger.internal.codegen.base.ValidationReport;
import dagger.internal.codegen.model.Binding;
import dagger.internal.codegen.model.BindingGraph;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.DiagnosticReporter;
import dagger.internal.codegen.validation.InjectValidator;
import dagger.internal.codegen.validation.ValidationBindingGraphPlugin;
import javax.inject.Inject;

final class InjectBindingValidator
extends ValidationBindingGraphPlugin {
    private final InjectValidator injectValidator;

    @Inject
    InjectBindingValidator(InjectValidator injectValidator) {
        this.injectValidator = injectValidator;
    }

    @Override
    public String pluginName() {
        return "Dagger/InjectBinding";
    }

    @Override
    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        bindingGraph.bindings().stream().filter(binding -> binding.kind().equals((Object)BindingKind.INJECTION)).forEach(binding -> this.validateInjectionBinding((Binding)binding, diagnosticReporter));
    }

    private void validateInjectionBinding(Binding node, DiagnosticReporter diagnosticReporter) {
        ValidationReport typeReport = this.injectValidator.validateWhenGeneratingCode(node.key().type().xprocessing().getTypeElement());
        for (ValidationReport.Item item : typeReport.allItems()) {
            diagnosticReporter.reportBinding(item.kind(), node, item.message());
        }
    }
}

