/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.DependencyVariableNamer;
import dagger.internal.codegen.binding.FrameworkField;
import dagger.internal.codegen.binding.FrameworkTypeMapper;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.MultiboundMapBinding;
import dagger.internal.codegen.binding.MultiboundSetBinding;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.xprocessing.Accessibility;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XPropertySpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XFieldElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.SourceVersion;

public final class SourceFiles {
    private static final Joiner CLASS_FILE_NAME_JOINER = Joiner.on((char)'_');

    @Inject
    SourceFiles() {
    }

    public static ImmutableMap<DependencyRequest, FrameworkField> generateBindingFieldsForDependencies(Binding binding, CompilerOptions compilerOptions) {
        Preconditions.checkArgument((!binding.unresolved().isPresent() ? 1 : 0) != 0, (String)"binding must be unresolved: %s", (Object)binding);
        FrameworkTypeMapper frameworkTypeMapper = FrameworkTypeMapper.forBindingType(binding.bindingType());
        XClassName requestingClass = binding.bindingTypeElement().get().asClassName();
        return Maps.toMap(binding.dependencies(), dependency -> {
            XClassName frameworkClassName = frameworkTypeMapper.getFrameworkType(dependency.kind()).frameworkClassName();
            XType type = dependency.key().type().xprocessing();
            return FrameworkField.create(DependencyVariableNamer.name(dependency), frameworkClassName, Accessibility.isTypeAccessibleFrom(type, requestingClass.getPackageName()) ? Optional.of(type) : Optional.empty(), compilerOptions);
        });
    }

    public XCodeBlock frameworkTypeUsageStatement(XCodeBlock frameworkTypeMemberSelect, RequestKind dependencyKind) {
        switch (dependencyKind) {
            case LAZY: {
                return XCodeBlock.of("%T.lazy(%L)", XTypeNames.DOUBLE_CHECK, frameworkTypeMemberSelect);
            }
            case INSTANCE: 
            case FUTURE: {
                return XCodeBlock.of("%L.get()", frameworkTypeMemberSelect);
            }
            case PROVIDER: 
            case PRODUCER: {
                return frameworkTypeMemberSelect;
            }
            case PROVIDER_OF_LAZY: {
                return XCodeBlock.of("%T.create(%L)", XTypeNames.PROVIDER_OF_LAZY, frameworkTypeMemberSelect);
            }
        }
        throw new AssertionError((Object)dependencyKind);
    }

    public ImmutableMap<DependencyRequest, XCodeBlock> frameworkFieldUsages(ImmutableSet<DependencyRequest> dependencies, ImmutableMap<DependencyRequest, XPropertySpec> fields) {
        return Maps.toMap(dependencies, dep -> this.frameworkTypeUsageStatement(XCodeBlock.of("%N", fields.get(dep)), dep.kind()));
    }

    public static String generatedProxyMethodName(ContributionBinding binding) {
        switch (binding.kind()) {
            case INJECTION: 
            case ASSISTED_INJECTION: {
                return "newInstance";
            }
            case PROVISION: {
                XMethodElement method = XElements.asMethod(binding.bindingElement().get());
                String simpleName = XElements.getSimpleName(method);
                return simpleName.contentEquals("get") || simpleName.contentEquals("create") ? "proxy" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, simpleName) : simpleName;
            }
        }
        throw new AssertionError((Object)("Unexpected binding kind: " + binding));
    }

    public static XClassName generatedClassNameForBinding(Binding binding) {
        switch (binding.kind()) {
            case INJECTION: 
            case ASSISTED_INJECTION: 
            case PROVISION: 
            case PRODUCTION: {
                return SourceFiles.factoryNameForElement(XElements.asExecutable(binding.bindingElement().get()));
            }
            case ASSISTED_FACTORY: {
                return SourceFiles.siblingClassName(XElements.asTypeElement(binding.bindingElement().get()), "_Impl");
            }
            case MEMBERS_INJECTION: {
                return SourceFiles.membersInjectorNameForType(((MembersInjectionBinding)binding).membersInjectedType());
            }
        }
        throw new AssertionError();
    }

    public static XClassName factoryNameForElement(XExecutableElement element) {
        return SourceFiles.elementBasedClassName(element, "Factory");
    }

    public static XClassName elementBasedClassName(XExecutableElement element, String suffix) {
        XClassName enclosingClassName = element.getEnclosingElement().asClassName();
        String methodName = XElementKt.isConstructor(element) ? "" : CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, XElements.getSimpleName(element));
        return XClassName.Companion.get(enclosingClassName.getPackageName(), SourceFiles.classFileName(enclosingClassName) + "_" + methodName + suffix);
    }

    public static XTypeName parameterizedGeneratedTypeNameForBinding(Binding binding) {
        XClassName className = SourceFiles.generatedClassNameForBinding(binding);
        ImmutableList<XTypeName> typeParameters = SourceFiles.bindingTypeElementTypeVariableNames(binding);
        return typeParameters.isEmpty() ? className : className.parametrizedBy((XTypeName[])Iterables.toArray(typeParameters, XTypeName.class));
    }

    public static XClassName membersInjectorNameForType(XTypeElement typeElement) {
        return SourceFiles.siblingClassName(typeElement, "_MembersInjector");
    }

    public static String memberInjectedFieldSignatureForVariable(XFieldElement field) {
        return field.getEnclosingElement().getClassName().canonicalName() + "." + XElements.getSimpleName(field);
    }

    public static String membersInjectorMethodName(MembersInjectionBinding.InjectionSite injectionSite) {
        int index = injectionSite.indexAmongAtInjectMembersWithSameSimpleName();
        String indexString = index == 0 ? "" : String.valueOf(index + 1);
        return "inject" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, XElements.getSimpleName(injectionSite.element())) + indexString;
    }

    public static String classFileName(XClassName className) {
        return CLASS_FILE_NAME_JOINER.join(className.getSimpleNames());
    }

    public static XClassName generatedMonitoringModuleName(XTypeElement componentElement) {
        return SourceFiles.siblingClassName(componentElement, "_MonitoringModule");
    }

    private static XClassName siblingClassName(XTypeElement typeElement, String suffix) {
        XClassName className = typeElement.asClassName();
        return XClassName.Companion.get(className.getPackageName(), SourceFiles.classFileName(className) + suffix);
    }

    public static XClassName setFactoryClassName(MultiboundSetBinding binding) {
        switch (binding.bindingType()) {
            case PROVISION: {
                return XTypeNames.SET_FACTORY;
            }
            case PRODUCTION: {
                SetType setType = SetType.from(binding.key());
                return setType.elementsAreTypeOf(XTypeNames.PRODUCED) ? XTypeNames.SET_OF_PRODUCED_PRODUCER : XTypeNames.SET_PRODUCER;
            }
        }
        throw new IllegalArgumentException(binding.bindingType().toString());
    }

    public static XClassName mapFactoryClassName(MultiboundMapBinding binding) {
        MapType mapType = MapType.from(binding.key());
        switch (binding.bindingType()) {
            case PROVISION: {
                if (mapType.valuesAreProviderOfLazy()) {
                    return XTypeNames.MAP_PROVIDER_LAZY_FACTORY;
                }
                if (mapType.valuesAreLazy()) {
                    return XTypeNames.MAP_LAZY_FACTORY;
                }
                if (mapType.valuesAreProvider()) {
                    return XTypeNames.MAP_PROVIDER_FACTORY;
                }
                return XTypeNames.MAP_FACTORY;
            }
            case PRODUCTION: {
                return mapType.valuesAreFrameworkType() ? (mapType.valuesAreTypeOf(XTypeNames.PRODUCER) ? XTypeNames.MAP_OF_PRODUCER_PRODUCER : XTypeNames.MAP_OF_PRODUCED_PRODUCER) : XTypeNames.MAP_PRODUCER;
            }
        }
        throw new IllegalArgumentException(binding.bindingType().toString());
    }

    public static ImmutableList<XTypeName> bindingTypeElementTypeVariableNames(Binding binding) {
        ContributionBinding contributionBinding;
        if (binding instanceof ContributionBinding && (contributionBinding = (ContributionBinding)binding).kind() != BindingKind.INJECTION && contributionBinding.kind() != BindingKind.ASSISTED_INJECTION && !contributionBinding.requiresModuleInstance()) {
            return ImmutableList.of();
        }
        return XTypeElements.typeVariableNames(binding.bindingTypeElement().get());
    }

    public static String simpleVariableName(XTypeElement typeElement) {
        return SourceFiles.simpleVariableName(typeElement.asClassName());
    }

    public static String simpleVariableName(XClassName className) {
        String candidateName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, className.getSimpleName());
        String variableName = SourceFiles.protectAgainstKeywords(candidateName);
        Verify.verify((boolean)SourceVersion.isName(variableName), (String)"'%s' was expected to be a valid variable name", (Object)variableName);
        return variableName;
    }

    public static String protectAgainstKeywords(String candidateName) {
        switch (candidateName) {
            case "package": {
                return "pkg";
            }
            case "boolean": {
                return "b";
            }
            case "double": {
                return "d";
            }
            case "byte": {
                return "b";
            }
            case "int": {
                return "i";
            }
            case "short": {
                return "s";
            }
            case "char": {
                return "c";
            }
            case "void": {
                return "v";
            }
            case "class": {
                return "clazz";
            }
            case "float": {
                return "f";
            }
            case "long": {
                return "l";
            }
        }
        return SourceVersion.isKeyword(candidateName) ? candidateName + '_' : candidateName;
    }
}

