/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Preconditions;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.AutoValue_MultibindingDeclaration;
import dagger.internal.codegen.binding.Declaration;
import dagger.internal.codegen.binding.KeyFactory;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XMethodType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import java.util.Optional;
import javax.inject.Inject;

@AutoValue
public abstract class MultibindingDeclaration
extends Declaration
implements ContributionType.HasContributionType {
    @Override
    public abstract Key key();

    @Override
    public abstract ContributionType contributionType();

    @Memoized
    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public static final class Factory {
        private final KeyFactory keyFactory;

        @Inject
        Factory(KeyFactory keyFactory) {
            this.keyFactory = keyFactory;
        }

        MultibindingDeclaration forMultibindsMethod(XMethodElement moduleMethod, XTypeElement moduleElement) {
            Preconditions.checkArgument((boolean)moduleMethod.hasAnnotation(XTypeNames.MULTIBINDS));
            return this.forDeclaredMethod(moduleMethod, moduleMethod.asMemberOf(moduleElement.getType()), moduleElement);
        }

        private MultibindingDeclaration forDeclaredMethod(XMethodElement method, XMethodType methodType, XTypeElement contributingType) {
            XType returnType = methodType.getReturnType();
            Preconditions.checkArgument((SetType.isSet(returnType) || MapType.isMap(returnType) ? 1 : 0) != 0, (String)"%s must return a set or map", (Object)method);
            return new AutoValue_MultibindingDeclaration(Optional.of(method), Optional.of(contributingType), this.keyFactory.forMultibindsMethod(method, methodType), this.contributionType(returnType));
        }

        private ContributionType contributionType(XType returnType) {
            if (MapType.isMap(returnType)) {
                return ContributionType.MAP;
            }
            if (SetType.isSet(returnType)) {
                return ContributionType.SET;
            }
            throw new IllegalArgumentException("Must be Map or Set: " + returnType);
        }
    }
}

