/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import dagger.internal.codegen.binding.AutoValue_ComponentRequirement;
import dagger.internal.codegen.binding.BoundInstanceBinding;
import dagger.internal.codegen.binding.ComponentDependencyBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.xprocessing.Nullability;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XParameterSpecs;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XParameterSpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XAnnotated;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import java.util.Optional;

@AutoValue
public abstract class ComponentRequirement {
    private Nullability nullability = Nullability.NOT_NULLABLE;

    public abstract Kind kind();

    final boolean isBoundInstance() {
        return this.kind().isBoundInstance();
    }

    abstract Equivalence.Wrapper<XType> wrappedType();

    public XType type() {
        return (XType)this.wrappedType().get();
    }

    public XTypeElement typeElement() {
        return this.type().getTypeElement();
    }

    public Nullability getNullability() {
        return this.nullability;
    }

    public abstract NullPolicy nullPolicy();

    public boolean requiresAPassedInstance() {
        if (!this.kind().isModule()) {
            return true;
        }
        return this.requiresModuleInstance() && !ComponentRequirement.componentCanMakeNewInstances(this.typeElement());
    }

    public boolean requiresModuleInstance() {
        return ComponentRequirement.requiresModuleInstance(this.typeElement());
    }

    public static boolean requiresModuleInstance(XTypeElement typeElement) {
        if (typeElement.isKotlinObject() || typeElement.isCompanionObject()) {
            return false;
        }
        return XTypeElements.getAllNonPrivateInstanceMethods(typeElement).stream().filter(ComponentRequirement::isBindingMethod).anyMatch(method -> !method.isAbstract() && !method.isStatic());
    }

    private static boolean isBindingMethod(XMethodElement method) {
        return XElements.hasAnyAnnotation((XAnnotated)method, XTypeNames.PROVIDES, XTypeNames.PRODUCES, XTypeNames.BINDS, XTypeNames.MULTIBINDS, XTypeNames.BINDS_OPTIONAL_OF);
    }

    public abstract Optional<Key> key();

    public abstract String variableName();

    public XParameterSpec toParameterSpec() {
        return XParameterSpecs.of(this.variableName(), this.type().asTypeName());
    }

    public static ComponentRequirement forDependency(ComponentDependencyBinding binding) {
        return ComponentRequirement.forDependency(binding.key().type().xprocessing());
    }

    public static ComponentRequirement forDependency(XType type) {
        Preconditions.checkArgument((boolean)XTypes.isDeclared((XType)Preconditions.checkNotNull((Object)type)));
        return ComponentRequirement.create(Kind.DEPENDENCY, type, NullPolicy.THROW);
    }

    public static ComponentRequirement forModule(XType type) {
        Preconditions.checkArgument((boolean)XTypes.isDeclared((XType)Preconditions.checkNotNull((Object)type)));
        NullPolicy nullPolicy = ComponentRequirement.componentCanMakeNewInstances(type.getTypeElement()) ? NullPolicy.NEW : (ComponentRequirement.requiresModuleInstance(type.getTypeElement()) ? NullPolicy.THROW : NullPolicy.ALLOW);
        return ComponentRequirement.create(Kind.MODULE, type, nullPolicy);
    }

    public static ComponentRequirement forBoundInstance(BoundInstanceBinding binding) {
        Preconditions.checkArgument((boolean)binding.kind().equals((Object)BindingKind.BOUND_INSTANCE));
        return ComponentRequirement.forBoundInstance(binding.key(), binding.isNullable(), binding.bindingElement().get(), binding.nullability());
    }

    static ComponentRequirement forBoundInstance(Key key, boolean nullable, XElement elementForVariableName, Nullability nullability) {
        return ComponentRequirement.create(Kind.BOUND_INSTANCE, key.type().xprocessing(), nullable ? NullPolicy.ALLOW : NullPolicy.THROW, Optional.of(key), nullability, XElements.getSimpleName(elementForVariableName));
    }

    private static ComponentRequirement create(Kind kind, XType type, NullPolicy nullPolicy) {
        return ComponentRequirement.create(kind, type, nullPolicy, Optional.empty(), Nullability.NOT_NULLABLE, SourceFiles.simpleVariableName(type.getTypeElement().asClassName()));
    }

    private static ComponentRequirement create(Kind kind, XType type, NullPolicy nullPolicy, Optional<Key> key, Nullability nullability, String variableName) {
        AutoValue_ComponentRequirement requirement = new AutoValue_ComponentRequirement(kind, (Equivalence.Wrapper<XType>)XTypes.equivalence().wrap((Object)type), nullPolicy, key, variableName);
        requirement.nullability = nullability;
        return requirement;
    }

    public static boolean componentCanMakeNewInstances(XTypeElement typeElement) {
        return typeElement.isClass() && !typeElement.isAbstract() && !ComponentRequirement.requiresEnclosingInstance(typeElement) && ComponentRequirement.hasVisibleDefaultConstructor(typeElement);
    }

    private static boolean requiresEnclosingInstance(XTypeElement typeElement) {
        return XTypeElements.isNested(typeElement) && !typeElement.isStatic();
    }

    private static boolean hasVisibleDefaultConstructor(XTypeElement typeElement) {
        return typeElement.getConstructors().stream().anyMatch(constructor -> !constructor.isPrivate() && constructor.getParameters().isEmpty());
    }

    public static enum Kind {
        DEPENDENCY,
        MODULE,
        BOUND_INSTANCE;


        public boolean isBoundInstance() {
            return this.equals((Object)BOUND_INSTANCE);
        }

        public boolean isModule() {
            return this.equals((Object)MODULE);
        }
    }

    public static enum NullPolicy {
        NEW,
        THROW,
        ALLOW;

    }
}

