/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XExpressionType;
import dagger.internal.codegen.xprocessing.XProcessingEnvs;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import javax.inject.Inject;

public final class BindsTypeChecker {
    private final XProcessingEnv processingEnv;

    @Inject
    BindsTypeChecker(XProcessingEnv processingEnv) {
        this.processingEnv = processingEnv;
    }

    public boolean isAssignable(XExpressionType rightHandSide, XType leftHandSide, ContributionType contributionType) {
        return rightHandSide.isAssignableTo(this.desiredAssignableType(leftHandSide, contributionType));
    }

    public boolean isAssignable(XType rightHandSide, XType leftHandSide, ContributionType contributionType) {
        return XTypes.isAssignableTo(rightHandSide, this.desiredAssignableType(leftHandSide, contributionType));
    }

    private XType desiredAssignableType(XType leftHandSide, ContributionType contributionType) {
        switch (contributionType) {
            case UNIQUE: {
                return leftHandSide;
            }
            case SET: {
                XType parameterizedSetType = this.processingEnv.getDeclaredType(this.setElement(), leftHandSide);
                return this.methodParameterType(parameterizedSetType, "add");
            }
            case SET_VALUES: {
                return this.methodParameterType(XTypes.rewrapType(leftHandSide, XTypeName.MUTABLE_SET), "addAll");
            }
            case MAP: {
                XType parameterizedMapType = this.processingEnv.getDeclaredType(this.mapElement(), this.unboundedWildcard(), leftHandSide);
                return (XType)this.methodParameterTypes(parameterizedMapType, "put").get(1);
            }
        }
        throw new AssertionError((Object)("Unknown contribution type: " + (Object)((Object)contributionType)));
    }

    private ImmutableList<XType> methodParameterTypes(XType type, String methodName) {
        ImmutableList methods = (ImmutableList)XTypeElements.getAllMethods(type.getTypeElement()).stream().filter(method -> methodName.contentEquals(XElements.getSimpleName(method))).collect(DaggerStreams.toImmutableList());
        if (methods.size() != 1) {
            throw new IllegalStateException("Expected exactly one factory method for " + XElements.toStableString(type.getTypeElement()) + " but found: " + methods.stream().map(method -> XElements.toStableString(method.getEnclosingElement()) + "#" + XElements.toStableString(method)).collect(DaggerStreams.toImmutableList()));
        }
        return ImmutableList.copyOf(((XMethodElement)Iterables.getOnlyElement((Iterable)methods)).asMemberOf(type).getParameterTypes());
    }

    private XType methodParameterType(XType type, String methodName) {
        return (XType)Iterables.getOnlyElement(this.methodParameterTypes(type, methodName));
    }

    private XTypeElement setElement() {
        return this.processingEnv.requireTypeElement(XTypeName.MUTABLE_SET);
    }

    private XTypeElement mapElement() {
        return this.processingEnv.requireTypeElement(XTypeName.MUTABLE_MAP);
    }

    private XType unboundedWildcard() {
        return XProcessingEnvs.getUnboundedWildcardType(this.processingEnv);
    }
}

