/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import dagger.internal.codegen.base.TarjanSCCs;
import dagger.internal.codegen.binding.BindingNode;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.model.BindingGraph;
import java.util.HashMap;
import java.util.Map;

final class BindingGraphTransformations {
    static MutableNetwork<BindingGraph.Node, BindingGraph.Edge> withFixedBindingTypes(MutableNetwork<BindingGraph.Node, BindingGraph.Edge> network) {
        ImmutableSet<BindingNode> bindingsToFix = BindingGraphTransformations.bindingsWithMissingBindingTypes(network);
        if (bindingsToFix.isEmpty()) {
            return network;
        }
        MutableNetwork<BindingGraph.Node, BindingGraph.Edge> fixedNetwork = BindingGraphTransformations.withFixedBindingTypes(network, bindingsToFix);
        Preconditions.checkState((boolean)BindingGraphTransformations.bindingsWithMissingBindingTypes(fixedNetwork).isEmpty());
        return fixedNetwork;
    }

    private static MutableNetwork<BindingGraph.Node, BindingGraph.Edge> withFixedBindingTypes(Network<BindingGraph.Node, BindingGraph.Edge> network, ImmutableSet<BindingNode> bindingsToFix) {
        ImmutableList<ImmutableSet<BindingNode>> topologicallySortedBindingsToFix = TarjanSCCs.compute(bindingsToFix, binding -> (Iterable)network.successors(binding).stream().flatMap(DaggerStreams.instancesOf(BindingNode.class)).filter(arg_0 -> ((ImmutableSet)bindingsToFix).contains(arg_0)).collect(DaggerStreams.toImmutableSet()));
        HashMap replacements = Maps.newHashMapWithExpectedSize((int)bindingsToFix.size());
        for (ImmutableSet connectedBindings : topologicallySortedBindingsToFix) {
            BindingType successorBindingType = connectedBindings.stream().flatMap(binding -> network.successors(binding).stream()).flatMap(DaggerStreams.instancesOf(BindingNode.class)).filter(binding -> !connectedBindings.contains(binding)).map(binding -> replacements.getOrDefault(binding, binding)).anyMatch(BindingNode::isProduction) ? BindingType.PRODUCTION : BindingType.PROVISION;
            for (BindingNode bindingNode : connectedBindings) {
                replacements.put(bindingNode, bindingNode.withBindingType(successorBindingType));
            }
        }
        return BindingGraphTransformations.withReplacedBindings(network, (ImmutableMap<? extends BindingGraph.Node, ? extends BindingGraph.Node>)ImmutableMap.copyOf((Map)replacements));
    }

    private static ImmutableSet<BindingNode> bindingsWithMissingBindingTypes(Network<BindingGraph.Node, BindingGraph.Edge> network) {
        return (ImmutableSet)network.nodes().stream().flatMap(DaggerStreams.instancesOf(BindingNode.class)).filter(binding -> binding.delegate().optionalBindingType().isEmpty()).collect(DaggerStreams.toImmutableSet());
    }

    private static MutableNetwork<BindingGraph.Node, BindingGraph.Edge> withReplacedBindings(Network<BindingGraph.Node, BindingGraph.Edge> network, ImmutableMap<? extends BindingGraph.Node, ? extends BindingGraph.Node> replacementNodes) {
        MutableNetwork newNetwork = NetworkBuilder.from(network).build();
        for (BindingGraph.Node node : network.nodes()) {
            newNetwork.addNode((Object)(replacementNodes.containsKey((Object)node) ? (BindingGraph.Node)replacementNodes.get((Object)node) : node));
        }
        for (BindingGraph.Edge edge : network.edges()) {
            EndpointPair incidentNodes = network.incidentNodes((Object)edge);
            BindingGraph.Node source = (BindingGraph.Node)incidentNodes.source();
            BindingGraph.Node target = (BindingGraph.Node)incidentNodes.target();
            newNetwork.addEdge((Object)(replacementNodes.containsKey((Object)source) ? (BindingGraph.Node)replacementNodes.get((Object)source) : source), (Object)(replacementNodes.containsKey((Object)target) ? (BindingGraph.Node)replacementNodes.get((Object)target) : target), (Object)edge);
        }
        return newNetwork;
    }

    private BindingGraphTransformations() {
    }
}

