/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XAnnotationValues;
import dagger.internal.codegen.xprocessing.XCodeBlocks;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XAnnotationValue;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeKt;

public final class AnnotationExpression {
    private final XAnnotation annotation;
    private final XClassName creatorClass;

    AnnotationExpression(XAnnotation annotation) {
        this.annotation = annotation;
        this.creatorClass = AnnotationExpression.getAnnotationCreatorClassName(annotation.getType().getTypeElement());
    }

    XCodeBlock getAnnotationInstanceExpression() {
        return this.getAnnotationInstanceExpression(this.annotation);
    }

    private XCodeBlock getAnnotationInstanceExpression(XAnnotation annotation) {
        return XCodeBlock.of("%T.%L(%L)", this.creatorClass, AnnotationExpression.createMethodName(annotation.getType().getTypeElement()), XCodeBlocks.makeParametersCodeBlock((Iterable)annotation.getAnnotationValues().stream().map(this::getValueExpression).collect(DaggerStreams.toImmutableList())));
    }

    public static XClassName getAnnotationCreatorClassName(XTypeElement annotationType) {
        XClassName annotationTypeName = annotationType.asClassName();
        return XClassName.Companion.get(annotationTypeName.getPackageName(), SourceFiles.classFileName(annotationTypeName) + "Creator");
    }

    public static String createMethodName(XTypeElement annotationType) {
        return "create" + XElements.getSimpleName(annotationType);
    }

    XCodeBlock getValueExpression(XAnnotationValue value) {
        if (XTypeKt.isArray(value.getValueType())) {
            XType componentType = XTypes.asArray(value.getValueType()).getComponentType();
            return XCodeBlock.of("new %T[] {%L}", XTypes.isTypeOf(componentType, XTypeNames.KCLASS) ? XTypeNames.CLASS : componentType.getRawType().asTypeName(), value.asAnnotationValueList().stream().map(this::getValueExpression).collect(XCodeBlocks.toParametersCodeBlock()));
        }
        if (value.hasEnumValue()) {
            return XCodeBlock.of("%T.%L", value.asEnum().getEnclosingElement().asClassName(), XElements.getSimpleName(value.asEnum()));
        }
        if (value.hasAnnotationValue()) {
            return this.getAnnotationInstanceExpression(value.asAnnotation());
        }
        if (value.hasTypeValue()) {
            return XCodeBlock.of("%T.class", value.asType().getTypeElement().asClassName());
        }
        if (value.hasStringValue()) {
            return XCodeBlock.of("%S", value.asString());
        }
        if (value.hasByteValue()) {
            return XCodeBlock.of("(byte) %L", value.asByte());
        }
        if (value.hasCharValue()) {
            return XCodeBlock.of("%L", XAnnotationValues.characterLiteralWithSingleQuotes(value.asChar()));
        }
        if (value.hasDoubleValue()) {
            return XCodeBlock.of("%LD", value.asDouble());
        }
        if (value.hasFloatValue()) {
            return XCodeBlock.of("%LF", Float.valueOf(value.asFloat()));
        }
        if (value.hasLongValue()) {
            return XCodeBlock.of("%LL", value.asLong());
        }
        if (value.hasShortValue()) {
            return XCodeBlock.of("(short) %L", value.asShort());
        }
        return XCodeBlock.of("%L", value.getValue());
    }
}

