/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.Accessibility;
import dagger.internal.codegen.xprocessing.XCodeBlocks;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeSpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XConstructorElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XVariableElement;
import java.util.Optional;
import javax.lang.model.element.Modifier;

public final class SourceFileHjarGenerator<T>
extends SourceFileGenerator<T> {
    private final SourceFileGenerator<T> delegate;
    private final XProcessingEnv processingEnv;

    public static <T> SourceFileGenerator<T> wrap(SourceFileGenerator<T> delegate, XProcessingEnv processingEnv) {
        return new SourceFileHjarGenerator<T>(delegate, processingEnv);
    }

    private SourceFileHjarGenerator(SourceFileGenerator<T> delegate, XProcessingEnv processingEnv) {
        super(delegate);
        this.delegate = delegate;
        this.processingEnv = processingEnv;
    }

    @Override
    public XElement originatingElement(T input) {
        return this.delegate.originatingElement(input);
    }

    @Override
    public ImmutableList<XTypeSpec> topLevelTypes(T input) {
        String packageName = XElements.closestEnclosingTypeElement(this.originatingElement(input)).getPackageName();
        return (ImmutableList)this.delegate.topLevelTypes(input).stream().map(completeType -> this.skeletonType(packageName, XConverters.toJavaPoet(completeType))).collect(DaggerStreams.toImmutableList());
    }

    private XTypeSpec skeletonType(String packageName, TypeSpec completeType) {
        boolean isOpen = !completeType.modifiers.contains((Object)Modifier.FINAL);
        XTypeSpec.Builder skeleton = XTypeSpec.Companion.classBuilder(completeType.name, isOpen);
        XConverters.toJavaPoet(skeleton).addSuperinterfaces((Iterable)completeType.superinterfaces).addTypeVariables((Iterable)completeType.typeVariables).addModifiers(completeType.modifiers.toArray(new Modifier[0])).addAnnotations((Iterable)completeType.annotations);
        if (!completeType.superclass.equals((Object)ClassName.OBJECT)) {
            XConverters.toJavaPoet(skeleton).superclass(completeType.superclass);
        }
        completeType.methodSpecs.stream().filter(method -> !method.modifiers.contains((Object)Modifier.PRIVATE) || method.isConstructor()).map(completeMethod -> this.skeletonMethod(packageName, completeType, (MethodSpec)completeMethod)).forEach(method -> XConverters.toJavaPoet(skeleton).addMethod(method));
        completeType.fieldSpecs.stream().filter(field -> !field.modifiers.contains((Object)Modifier.PRIVATE)).map(this::skeletonField).forEach(field -> XConverters.toJavaPoet(skeleton).addField(field));
        completeType.typeSpecs.stream().map(type -> this.skeletonType(packageName, (TypeSpec)type)).forEach(skeleton::addType);
        completeType.alwaysQualifiedNames.forEach(names -> XConverters.toJavaPoet(skeleton).alwaysQualify(new String[]{names}));
        return skeleton.build();
    }

    private MethodSpec skeletonMethod(String packageName, TypeSpec completeType, MethodSpec completeMethod) {
        MethodSpec.Builder skeleton;
        MethodSpec.Builder builder = skeleton = completeMethod.isConstructor() ? MethodSpec.constructorBuilder() : MethodSpec.methodBuilder((String)completeMethod.name).returns(completeMethod.returnType);
        if (completeMethod.isConstructor()) {
            this.getRequiredSuperCall(packageName, completeType).ifPresent(superCall -> skeleton.addStatement("$L", new Object[]{superCall}));
        } else if (!completeMethod.returnType.equals((Object)XConverters.toJavaPoet(XTypeName.UNIT_VOID))) {
            skeleton.addStatement("return $L", new Object[]{XConverters.toJavaPoet(SourceFileHjarGenerator.getDefaultValueCodeBlock(completeMethod.returnType))});
        }
        return skeleton.addModifiers((Iterable)completeMethod.modifiers).addTypeVariables((Iterable)completeMethod.typeVariables).addParameters((Iterable)completeMethod.parameters).addExceptions((Iterable)completeMethod.exceptions).varargs(completeMethod.varargs).addAnnotations((Iterable)completeMethod.annotations).build();
    }

    private Optional<CodeBlock> getRequiredSuperCall(String packageName, TypeSpec completeType) {
        if (completeType.superclass.equals((Object)XConverters.toJavaPoet(XTypeName.ANY_OBJECT))) {
            return Optional.empty();
        }
        ClassName rawSuperClass = (ClassName)XTypeNames.rawJavaTypeName(completeType.superclass);
        XTypeElement superTypeElement = this.processingEnv.requireTypeElement(rawSuperClass.canonicalName());
        ImmutableSet accessibleConstructors = (ImmutableSet)superTypeElement.getConstructors().stream().filter(constructor -> constructor.isProtected() || Accessibility.isElementAccessibleFrom((XElement)constructor, packageName)).collect(DaggerStreams.toImmutableSet());
        if (accessibleConstructors.isEmpty() || accessibleConstructors.stream().anyMatch(constructor -> constructor.getParameters().isEmpty())) {
            return Optional.empty();
        }
        return Optional.of(CodeBlock.of((String)"super($L)", (Object[])new Object[]{XConverters.toJavaPoet(XCodeBlocks.makeParametersCodeBlock((Iterable)((XConstructorElement)accessibleConstructors.stream().findFirst().get()).getParameters().stream().map(XVariableElement::getType).map(XType::getTypeName).map(SourceFileHjarGenerator::getDefaultValueCodeBlock).collect(DaggerStreams.toImmutableList())))}));
    }

    private static XCodeBlock getDefaultValueCodeBlock(TypeName typeName) {
        if (typeName.isPrimitive()) {
            if (typeName.equals((Object)XConverters.toJavaPoet(XTypeName.PRIMITIVE_BOOLEAN))) {
                return XCodeBlock.of("false", new Object[0]);
            }
            if (typeName.equals((Object)XConverters.toJavaPoet(XTypeName.PRIMITIVE_CHAR))) {
                return XCodeBlock.of("'\u0000'", new Object[0]);
            }
            if (typeName.equals((Object)XConverters.toJavaPoet(XTypeName.PRIMITIVE_BYTE))) {
                return XCodeBlock.of("0", new Object[0]);
            }
            if (typeName.equals((Object)XConverters.toJavaPoet(XTypeName.PRIMITIVE_SHORT))) {
                return XCodeBlock.of("0", new Object[0]);
            }
            if (typeName.equals((Object)XConverters.toJavaPoet(XTypeName.PRIMITIVE_INT))) {
                return XCodeBlock.of("0", new Object[0]);
            }
            if (typeName.equals((Object)XConverters.toJavaPoet(XTypeName.PRIMITIVE_LONG))) {
                return XCodeBlock.of("0L", new Object[0]);
            }
            if (typeName.equals((Object)XConverters.toJavaPoet(XTypeName.PRIMITIVE_FLOAT))) {
                return XCodeBlock.of("0.0f", new Object[0]);
            }
            if (typeName.equals((Object)XConverters.toJavaPoet(XTypeName.PRIMITIVE_DOUBLE))) {
                return XCodeBlock.of("0.0d", new Object[0]);
            }
            throw new AssertionError((Object)("Unexpected type: " + typeName));
        }
        return XCodeBlock.of("null", new Object[0]);
    }

    private FieldSpec skeletonField(FieldSpec completeField) {
        FieldSpec.Builder skeleton = FieldSpec.builder((TypeName)completeField.type, (String)completeField.name, (Modifier[])completeField.modifiers.toArray(new Modifier[0])).addAnnotations((Iterable)completeField.annotations);
        if (completeField.modifiers.contains((Object)Modifier.FINAL)) {
            skeleton.initializer(XConverters.toJavaPoet(SourceFileHjarGenerator.getDefaultValueCodeBlock(completeField.type)));
        }
        return skeleton.build();
    }
}

