/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.base.Preconditions;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;

public final class SetType {
    private final XType type;

    public static SetType from(Key key) {
        return SetType.from(key.type().xprocessing());
    }

    public static SetType from(XType type) {
        Preconditions.checkArgument((boolean)SetType.isSet(type), (String)"%s must be a Set", (Object)type);
        return new SetType(type);
    }

    private SetType(XType type) {
        this.type = type;
    }

    XTypeName typeName() {
        return this.type.asTypeName();
    }

    public boolean isRawType() {
        return XTypes.isRawParameterizedType(this.type);
    }

    public XType elementType() {
        return XTypes.unwrapType(this.type);
    }

    public boolean elementsAreTypeOf(XClassName className) {
        return !this.isRawType() && XTypes.isTypeOf(this.elementType(), className);
    }

    public XType unwrappedElementType(XClassName wrappingClass) {
        Preconditions.checkArgument((boolean)this.elementsAreTypeOf(wrappingClass), (String)"expected elements to be %s, but this type is %s", (Object)wrappingClass, (Object)this.type);
        return XTypes.unwrapType(this.elementType());
    }

    public static boolean isSet(XType type) {
        return XTypes.isTypeOf(type, XTypeName.SET) || XTypes.isTypeOf(type, XTypeName.MUTABLE_SET) || XTypes.isTypeOf(type, XTypeNames.JAVA_UTIL_SET);
    }

    public static boolean isSet(Key key) {
        return SetType.isSet(key.type().xprocessing());
    }
}

