/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;

public final class OptionalType {
    private final XType type;

    public static OptionalType from(Key key) {
        return OptionalType.from(key.type().xprocessing());
    }

    public static OptionalType from(XType type) {
        Preconditions.checkArgument((boolean)OptionalType.isOptional(type), (String)"%s must be an Optional", (Object)type);
        return new OptionalType(type);
    }

    private OptionalType(XType type) {
        this.type = type;
    }

    XTypeName typeName() {
        return this.type.asTypeName();
    }

    public OptionalKind kind() {
        return OptionalKind.of(this.type.getTypeElement());
    }

    public XType valueType() {
        return this.type.getTypeArguments().get(0);
    }

    private static boolean isOptional(XType type) {
        return XTypes.isDeclared(type) && OptionalKind.isOptionalKind(type.getTypeElement());
    }

    public static boolean isOptional(Key key) {
        return OptionalType.isOptional(key.type().xprocessing());
    }

    public static boolean isOptionalProviderType(XType type) {
        return OptionalType.isOptional(type) && XTypes.isTypeOf(OptionalType.from(type).valueType(), XTypeNames.providerTypeNames());
    }

    public static enum OptionalKind {
        GUAVA_OPTIONAL(XTypeNames.GUAVA_OPTIONAL, "absent"),
        JDK_OPTIONAL(XTypeNames.JDK_OPTIONAL, "empty");

        private static final ImmutableMap<XClassName, OptionalKind> OPTIONAL_KIND_BY_CLASS_NAME;
        private final XClassName className;
        private final String absentMethodName;

        private OptionalKind(XClassName className, String absentMethodName) {
            this.className = className;
            this.absentMethodName = absentMethodName;
        }

        private static boolean isOptionalKind(XTypeElement type) {
            return OPTIONAL_KIND_BY_CLASS_NAME.containsKey((Object)type.asClassName());
        }

        private static OptionalKind of(XTypeElement type) {
            return (OptionalKind)((Object)OPTIONAL_KIND_BY_CLASS_NAME.get((Object)type.asClassName()));
        }

        public XClassName className() {
            return this.className;
        }

        public XTypeName of(XTypeName valueType) {
            return this.className.parametrizedBy(valueType);
        }

        public XCodeBlock absentValueExpression() {
            return XCodeBlock.of("%T.%N()", this.className, this.absentMethodName);
        }

        public XCodeBlock parameterizedAbsentValueExpression(OptionalType optionalType) {
            return XCodeBlock.of("%T.<%T>%N()", this.className, optionalType.valueType().asTypeName(), this.absentMethodName);
        }

        public XCodeBlock presentExpression(XCodeBlock value) {
            return XCodeBlock.of("%T.of(%L)", this.className, value);
        }

        public XCodeBlock presentObjectExpression(XCodeBlock value) {
            return XCodeBlock.of("%T.<%T>of(%L)", this.className, XTypeName.ANY_OBJECT, value);
        }

        static {
            OPTIONAL_KIND_BY_CLASS_NAME = (ImmutableMap)DaggerStreams.valuesOf(OptionalKind.class).collect(DaggerStreams.toImmutableMap(value -> value.className, value -> value));
        }
    }
}

