/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import dagger.internal.codegen.xprocessing.Accessibility;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XAnnotationValue;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import java.util.List;
import java.util.function.Predicate;

public final class MapKeyAccessibility {
    private MapKeyAccessibility() {
    }

    private static boolean checkAnnotation(XAnnotation annotation, Predicate<XType> accessibilityChecker) {
        return MapKeyAccessibility.checkValues(annotation.getAnnotationValues(), accessibilityChecker);
    }

    private static boolean checkValues(List<XAnnotationValue> values, Predicate<XType> accessibilityChecker) {
        return values.stream().allMatch(value -> MapKeyAccessibility.checkValue(value, accessibilityChecker));
    }

    private static boolean checkValue(XAnnotationValue value, Predicate<XType> accessibilityChecker) {
        if (value.hasListValue()) {
            return MapKeyAccessibility.checkValues(value.asAnnotationValueList(), accessibilityChecker);
        }
        if (value.hasAnnotationValue()) {
            return MapKeyAccessibility.checkAnnotation(value.asAnnotation(), accessibilityChecker);
        }
        if (value.hasEnumValue()) {
            return accessibilityChecker.test(value.asEnum().getEnclosingElement().getType());
        }
        if (value.hasTypeValue()) {
            return accessibilityChecker.test(value.asType());
        }
        return true;
    }

    public static boolean isMapKeyAccessibleFrom(XAnnotation annotation, String accessingPackage) {
        return MapKeyAccessibility.checkAnnotation(annotation, type -> Accessibility.isTypeAccessibleFrom(type, accessingPackage));
    }

    public static boolean isMapKeyPubliclyAccessible(XAnnotation annotation) {
        return MapKeyAccessibility.checkAnnotation(annotation, Accessibility::isTypePubliclyAccessible);
    }
}

