/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.base.Splitter;
import dagger.internal.codegen.base.ValidationReport;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.lang.model.SourceVersion;

public final class KeywordValidator {
    @Inject
    KeywordValidator() {
    }

    ValidationReport validateJavaKeyword(XElement element) {
        ValidationReport.Builder report = ValidationReport.about(element);
        if (element == null) {
            return report.build();
        }
        if (XElementKt.isTypeElement(element)) {
            this.keywordFromName(XElements.getSimpleName(element)).ifPresent(keyword -> report.addError(this.javaKeywordErrorMessage((String)keyword), element));
            this.validatePackageName(XElements.asTypeElement(element), report);
        } else if (XElements.isExecutable(element)) {
            if (XElementKt.isMethod(element)) {
                this.keywordFromName(XElements.getSimpleName(element)).ifPresent(keyword -> report.addError(this.javaKeywordErrorMessage((String)keyword), element));
                this.validateJavaKeywordType(XElements.asMethod(element).getReturnType(), report);
            }
            XElements.asExecutable(element).getParameters().forEach(parameter -> this.validateJavaKeywordType(parameter.getType(), report));
        } else if (XElementKt.isField(element)) {
            this.keywordFromName(XElements.getSimpleName(element)).ifPresent(keyword -> report.addError(this.javaKeywordErrorMessage((String)keyword), element));
            this.validateJavaKeywordType(XElements.asField(element).getType(), report);
        } else if (XElementKt.isMethodParameter(element)) {
            this.validateJavaKeywordType(XElements.asMethodParameter(element).getType(), report);
        }
        return report.build();
    }

    private void validatePackageName(XTypeElement element, ValidationReport.Builder report) {
        String packageName = element.getPackageName();
        if (packageName == null) {
            return;
        }
        Iterable names = Splitter.on((char)'.').split((CharSequence)packageName);
        for (String name : names) {
            this.keywordFromName(name).ifPresent(keyword -> report.addError(this.javaKeywordInPackageErrorMessage((String)keyword), element));
        }
    }

    private void validateJavaKeywordType(@Nullable XType type, ValidationReport.Builder report) {
        if (type == null || type.isError() || XTypes.isPrimitive(type)) {
            return;
        }
        if (type.getTypeElement() != null) {
            this.keywordFromName(XElements.getSimpleName(type.getTypeElement())).ifPresent(keyword -> report.addError(this.javaKeywordErrorMessage((String)keyword), type.getTypeElement()));
        }
        for (XType typeArgument : type.getTypeArguments()) {
            this.validateJavaKeywordType(typeArgument, report);
        }
        if (type.extendsBound() != null) {
            this.validateJavaKeywordType(type.extendsBound(), report);
        }
    }

    private Optional<String> keywordFromName(String name) {
        return this.isJavaKeyword(name) ? Optional.of(name) : Optional.empty();
    }

    boolean isJavaKeyword(String name) {
        return SourceVersion.isKeyword(name);
    }

    private String javaKeywordErrorMessage(String keyword) {
        return String.format("The name '%s' cannot be used because it is a Java keyword. Please use a different name.", keyword);
    }

    private String javaKeywordInPackageErrorMessage(String keyword) {
        return String.format("The name '%s' cannot be used as a package name because it is a Java keyword. Please use a different package name.", keyword);
    }
}

