/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;

public final class FrameworkTypes {
    private static final ImmutableSet<XClassName> PROVISION_TYPES = ImmutableSet.builder().addAll(XTypeNames.providerTypeNames()).add((Object)XTypeNames.LAZY).add((Object)XTypeNames.MEMBERS_INJECTOR).build();
    private static final ImmutableSet<XClassName> PRODUCTION_TYPES = ImmutableSet.of((Object)XTypeNames.PRODUCED, (Object)XTypeNames.PRODUCER);
    private static final ImmutableSet<XClassName> ALL_FRAMEWORK_TYPES = ImmutableSet.builder().addAll(PROVISION_TYPES).addAll(PRODUCTION_TYPES).build();
    public static final ImmutableSet<XClassName> SET_VALUE_FRAMEWORK_TYPES = ImmutableSet.of((Object)XTypeNames.PRODUCED);
    public static final ImmutableSet<XClassName> MAP_VALUE_FRAMEWORK_TYPES = ImmutableSet.builder().add((Object)XTypeNames.PROVIDER_OF_LAZY).add((Object)XTypeNames.LAZY).addAll(XTypeNames.providerTypeNames()).add((Object)XTypeNames.PRODUCED).add((Object)XTypeNames.PRODUCER).build();
    private static final ImmutableSet<XClassName> DISALLOWED_TYPES = ImmutableSet.of((Object)XTypeNames.DAGGER_PROVIDER);

    public static boolean isProducerType(XType type) {
        return XTypes.isTypeOf(type, PRODUCTION_TYPES);
    }

    public static boolean isFrameworkTypeName(XTypeName typeName) {
        return XTypeNames.isTypeOf(typeName, ALL_FRAMEWORK_TYPES);
    }

    public static boolean isFrameworkType(XType type) {
        return XTypes.isTypeOf(type, ALL_FRAMEWORK_TYPES);
    }

    public static boolean isSetValueFrameworkType(XType type) {
        return XTypes.isTypeOf(type, SET_VALUE_FRAMEWORK_TYPES);
    }

    public static boolean isMapValueFrameworkType(XType type) {
        return XTypes.isTypeOf(type, MAP_VALUE_FRAMEWORK_TYPES);
    }

    public static boolean isDisallowedType(XType type) {
        return XTypes.isTypeOf(type, DISALLOWED_TYPES);
    }

    private FrameworkTypes() {
    }
}

