/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.ClassName;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XAnnotationSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.JavaPoetExtKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import java.util.Collection;

public final class XAnnotationSpecs {
    public static XAnnotationSpec of(XAnnotation annotation) {
        return XConverters.toXPoet(JavaPoetExtKt.toAnnotationSpec(annotation, false), AnnotationSpec.builder((ClassName)XConverters.toKotlinPoet(XAnnotations.asClassName(annotation))).build());
    }

    public static XAnnotationSpec suppressWarnings(Suppression first, Suppression ... rest) {
        return XAnnotationSpecs.suppressWarnings((ImmutableSet<Suppression>)ImmutableSet.copyOf((Collection)Lists.asList((Object)((Object)first), (Object[])rest)));
    }

    public static XAnnotationSpec suppressWarnings(ImmutableSet<Suppression> suppressions) {
        Preconditions.checkArgument((!suppressions.isEmpty() ? 1 : 0) != 0);
        XAnnotationSpec.Builder builder = XAnnotationSpec.builder(XTypeName.SUPPRESS);
        suppressions.stream().flatMap(suppression -> ((Suppression)suppression).values.stream()).forEach(value -> builder.addMember("value", "%S", value));
        return builder.build();
    }

    private XAnnotationSpecs() {
    }

    public static enum Suppression {
        RAWTYPES("rawtypes"),
        UNCHECKED("unchecked"),
        FUTURE_RETURN_VALUE_IGNORED("FutureReturnValueIgnored"),
        KOTLIN_INTERNAL("KotlinInternal", "KotlinInternalInJava"),
        CAST("cast"),
        DEPRECATION("deprecation"),
        UNINITIALIZED("nullness:initialization.field.uninitialized");

        private final ImmutableList<String> values;

        private Suppression(String ... values) {
            this.values = ImmutableList.copyOf((Object[])values);
        }
    }
}

