/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSFunctionDeclaration;
import com.google.devtools.ksp.symbol.KSPropertyDeclaration;
import com.google.devtools.ksp.symbol.KSValueParameter;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.model.DaggerElement;
import dagger.spi.model.DaggerProcessingEnv;
import dagger.spi.model.DaggerType;

public final class DaggerElements {
    public static XElement toXProcessing(DaggerElement element, DaggerProcessingEnv daggerProcessingEnv) {
        XProcessingEnv processingEnv = DaggerElements.toXProcessing(daggerProcessingEnv);
        switch (element.backend()) {
            case JAVAC: {
                return XConverters.toXProcessing(element.javac(), processingEnv);
            }
            case KSP: {
                if (element.ksp() instanceof KSFunctionDeclaration) {
                    return XConverters.toXProcessing((KSFunctionDeclaration)element.ksp(), processingEnv);
                }
                if (element.ksp() instanceof KSClassDeclaration) {
                    return XConverters.toXProcessing((KSClassDeclaration)element.ksp(), processingEnv);
                }
                if (element.ksp() instanceof KSValueParameter) {
                    return XConverters.toXProcessing((KSValueParameter)element.ksp(), processingEnv);
                }
                if (element.ksp() instanceof KSPropertyDeclaration) {
                    return XConverters.toXProcessing((KSPropertyDeclaration)element.ksp(), processingEnv);
                }
                throw new IllegalStateException(String.format("Unsupported ksp declaration %s.", element.ksp()));
            }
        }
        throw new IllegalStateException(String.format("Backend %s not supported yet.", element.backend()));
    }

    public static XType toXProcessing(DaggerType type, DaggerProcessingEnv daggerProcessingEnv) {
        XProcessingEnv processingEnv = DaggerElements.toXProcessing(daggerProcessingEnv);
        switch (type.backend()) {
            case JAVAC: {
                return XConverters.toXProcessing(type.javac(), processingEnv);
            }
            case KSP: {
                return XConverters.toXProcessing(type.ksp(), processingEnv);
            }
        }
        throw new IllegalStateException(String.format("Backend %s not supported yet.", type.backend()));
    }

    public static XProcessingEnv toXProcessing(DaggerProcessingEnv processingEnv) {
        switch (processingEnv.backend()) {
            case JAVAC: {
                return XProcessingEnv.create(processingEnv.javac());
            }
            case KSP: {
                return XProcessingEnv.create(processingEnv.ksp(), processingEnv.resolver());
            }
        }
        throw new IllegalStateException(String.format("Backend %s not supported yet.", processingEnv.backend()));
    }

    private DaggerElements() {
    }
}

