/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.MultiboundMapBinding;
import dagger.internal.codegen.binding.MultiboundSetBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.writing.MemberSelect;
import dagger.internal.codegen.xprocessing.Accessibility;
import dagger.internal.codegen.xprocessing.XCodeBlocks;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;

final class StaticMemberSelects {
    static MemberSelect emptyMapFactory(MultiboundMapBinding binding) {
        BindingType bindingType = binding.bindingType();
        ImmutableList typeParameters = ImmutableList.copyOf(binding.key().type().xprocessing().getTypeArguments());
        return bindingType.equals((Object)BindingType.PRODUCTION) ? new ParameterizedStaticMethod(XTypeNames.PRODUCERS, (ImmutableList<XType>)typeParameters, XCodeBlock.of("emptyMapProducer()", new Object[0]), XTypeNames.PRODUCER) : new ParameterizedStaticMethod(XTypeNames.MAP_FACTORY, (ImmutableList<XType>)typeParameters, XCodeBlock.of("emptyMapProvider()", new Object[0]), XTypeNames.DAGGER_PROVIDER);
    }

    static MemberSelect emptySetFactory(MultiboundSetBinding binding) {
        return new ParameterizedStaticMethod(SourceFiles.setFactoryClassName(binding), (ImmutableList<XType>)ImmutableList.of((Object)SetType.from(binding.key()).elementType()), XCodeBlock.of("empty()", new Object[0]), XTypeNames.FACTORY);
    }

    static MemberSelect factoryCreateNoArgumentMethod(Binding binding) {
        ImmutableList<XTypeName> typeVariables;
        Preconditions.checkArgument((boolean)binding.bindingType().equals((Object)BindingType.PROVISION), (String)"Invalid binding type: %s", (Object)((Object)binding.bindingType()));
        Preconditions.checkArgument((binding.dependencies().isEmpty() && !binding.scope().isPresent() ? 1 : 0) != 0, (String)"%s should have no dependencies and be unscoped to create a no argument factory.", (Object)binding);
        XClassName factoryName = SourceFiles.generatedClassNameForBinding(binding);
        XType keyType = binding.key().type().xprocessing();
        if (XTypes.isDeclared(keyType) && !(typeVariables = SourceFiles.bindingTypeElementTypeVariableNames(binding)).isEmpty()) {
            ImmutableList typeArguments = ImmutableList.copyOf(keyType.getTypeArguments());
            return new ParameterizedStaticMethod(factoryName, (ImmutableList<XType>)typeArguments, XCodeBlock.of("create()", new Object[0]), XTypeNames.FACTORY);
        }
        return new StaticMethod(factoryName, XCodeBlock.of("create()", new Object[0]));
    }

    private StaticMemberSelects() {
    }

    private static final class ParameterizedStaticMethod
    extends MemberSelect {
        private final ImmutableList<XType> typeParameters;
        private final XCodeBlock methodCodeBlock;
        private final XClassName rawReturnType;

        ParameterizedStaticMethod(XClassName owningClass, ImmutableList<XType> typeParameters, XCodeBlock methodCodeBlock, XClassName rawReturnType) {
            super(owningClass, true);
            this.typeParameters = typeParameters;
            this.methodCodeBlock = methodCodeBlock;
            this.rawReturnType = rawReturnType;
        }

        @Override
        XCodeBlock getExpressionFor(XClassName usingClass) {
            boolean isAccessible = this.typeParameters.stream().allMatch(t -> Accessibility.isTypeAccessibleFrom(t, usingClass.getPackageName()));
            if (isAccessible) {
                return XCodeBlock.of("%T.<%L>%L", this.owningClass(), this.typeParameters.stream().map(XCodeBlocks::type).collect(XCodeBlocks.toParametersCodeBlock()), this.methodCodeBlock);
            }
            XCodeBlock expression = XCodeBlock.of("%T.%L", this.owningClass(), this.methodCodeBlock);
            return XCodeBlock.of("(%L)", XCodeBlock.ofCast(this.rawReturnType, expression));
        }
    }

    private static final class StaticMethod
    extends MemberSelect {
        private final XCodeBlock methodCodeBlock;

        StaticMethod(XClassName owningClass, XCodeBlock methodCodeBlock) {
            super(owningClass, true);
            this.methodCodeBlock = (XCodeBlock)Preconditions.checkNotNull((Object)methodCodeBlock);
        }

        @Override
        XCodeBlock getExpressionFor(XClassName usingClass) {
            return this.owningClass().equals(usingClass) ? this.methodCodeBlock : XCodeBlock.of("%T.%L", this.owningClass(), this.methodCodeBlock);
        }
    }
}

