/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.FrameworkType;
import dagger.internal.codegen.binding.KeyVariableNamer;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.FrameworkFieldInitializer;
import dagger.internal.codegen.writing.FrameworkInstanceRequestRepresentation;
import dagger.internal.codegen.writing.FrameworkInstanceSupplier;
import dagger.internal.codegen.xprocessing.XExpression;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import java.util.Optional;

final class ProducerNodeInstanceRequestRepresentation
extends FrameworkInstanceRequestRepresentation {
    private final ComponentImplementation.ShardImplementation shardImplementation;
    private final FrameworkFieldInitializer producerEntryPointViewFieldInitializer;
    private final Key key;

    @AssistedInject
    ProducerNodeInstanceRequestRepresentation(@Assisted ContributionBinding binding, @Assisted FrameworkInstanceSupplier frameworkInstanceSupplier, CompilerOptions compilerOptions, XProcessingEnv processingEnv, ComponentImplementation componentImplementation) {
        super(binding, frameworkInstanceSupplier, processingEnv);
        this.shardImplementation = componentImplementation.shardImplementation(binding);
        this.key = binding.key();
        this.producerEntryPointViewFieldInitializer = new FrameworkFieldInitializer(compilerOptions, componentImplementation, binding, new ProducerEntryPointViewCreationExpression());
    }

    @Override
    protected FrameworkType frameworkType() {
        return FrameworkType.PRODUCER_NODE;
    }

    @Override
    XExpression getDependencyExpression(XClassName requestingClass) {
        XExpression result = super.getDependencyExpression(requestingClass);
        this.shardImplementation.addCancellation(this.key, XCodeBlock.of("%T.cancel(%L, %N);", XTypeNames.PRODUCERS, result.codeBlock(), ComponentImplementation.MAY_INTERRUPT_IF_RUNNING_PARAM));
        return result;
    }

    @Override
    XExpression getDependencyExpressionForComponentMethod(ComponentDescriptor.ComponentMethodDescriptor componentMethod, ComponentImplementation component) {
        return this.requiresEntryPointView(componentMethod) ? XExpression.create(this.getDependencyExpression(this.shardImplementation.name()).type(), this.producerEntryPointViewFieldInitializer.memberSelect().getExpressionFor(component.name())) : super.getDependencyExpressionForComponentMethod(componentMethod, component);
    }

    private boolean requiresEntryPointView(ComponentDescriptor.ComponentMethodDescriptor componentMethod) {
        switch (componentMethod.dependencyRequest().get().kind()) {
            case PRODUCER: 
            case FUTURE: {
                return this.shardImplementation.componentDescriptor().isProduction();
            }
        }
        return false;
    }

    private class ProducerEntryPointViewCreationExpression
    implements FrameworkFieldInitializer.FrameworkInstanceCreationExpression {
        private ProducerEntryPointViewCreationExpression() {
        }

        @Override
        public XCodeBlock creationExpression() {
            return XCodeBlock.of("%T.entryPointViewOf(%L, %L)", XTypeNames.PRODUCERS, ProducerNodeInstanceRequestRepresentation.this.getDependencyExpression(ProducerNodeInstanceRequestRepresentation.this.shardImplementation.name()).codeBlock(), ProducerNodeInstanceRequestRepresentation.this.shardImplementation.isComponentShard() ? XCodeBlock.of("this", new Object[0]) : ProducerNodeInstanceRequestRepresentation.this.shardImplementation.getComponentImplementation().getComponentShard().shardFieldReference());
        }

        @Override
        public Optional<String> preferredFieldName() {
            return Optional.of(KeyVariableNamer.name(ProducerNodeInstanceRequestRepresentation.this.key) + "EntryPoint");
        }

        @Override
        public Optional<XClassName> alternativeFrameworkClass() {
            return Optional.of(XTypeNames.PRODUCER);
        }
    }

    @AssistedFactory
    static interface Factory {
        public ProducerNodeInstanceRequestRepresentation create(ContributionBinding var1, FrameworkInstanceSupplier var2);
    }
}

