/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.MultimapBuilder;
import dagger.internal.codegen.base.ComponentCreatorKind;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingNode;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.CancellationPolicy;
import dagger.internal.codegen.binding.ComponentCreatorDescriptor;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.KeyVariableNamer;
import dagger.internal.codegen.binding.MethodSignature;
import dagger.internal.codegen.binding.ModuleDescriptor;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.writing.ComponentCreatorImplementation;
import dagger.internal.codegen.writing.ComponentCreatorImplementationFactory;
import dagger.internal.codegen.writing.ComponentNames;
import dagger.internal.codegen.writing.ComponentRequestRepresentations;
import dagger.internal.codegen.writing.GeneratedImplementation;
import dagger.internal.codegen.writing.ParentComponent;
import dagger.internal.codegen.writing.PerComponentImplementation;
import dagger.internal.codegen.writing.SwitchingProviders;
import dagger.internal.codegen.writing.TopLevel;
import dagger.internal.codegen.xprocessing.Accessibility;
import dagger.internal.codegen.xprocessing.XAnnotationSpecs;
import dagger.internal.codegen.xprocessing.XCodeBlocks;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XFunSpecs;
import dagger.internal.codegen.xprocessing.XParameterSpecs;
import dagger.internal.codegen.xprocessing.XPropertySpecs;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypeSpecs;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XFunSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XParameterSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XPropertySpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMessager;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XVariableElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.lang.model.element.Modifier;
import javax.tools.Diagnostic;

@PerComponentImplementation
public final class ComponentImplementation {
    public static final XParameterSpec MAY_INTERRUPT_IF_RUNNING_PARAM = XParameterSpecs.of("mayInterruptIfRunning", XTypeName.PRIMITIVE_BOOLEAN);
    private static final String CANCELLATION_LISTENER_METHOD_NAME = "onProducerFutureCancelled";
    private static final int STATEMENTS_PER_METHOD = 25;
    private final ShardImplementation componentShard;
    private final Supplier<ImmutableMap<Binding, ShardImplementation>> shardsByBinding;
    private final Map<ShardImplementation, XPropertySpec> shardFieldsByImplementation = new HashMap<ShardImplementation, XPropertySpec>();
    private final List<XCodeBlock> shardInitializations = new ArrayList<XCodeBlock>();
    private final List<XCodeBlock> shardCancellations = new ArrayList<XCodeBlock>();
    private final Optional<ComponentImplementation> parent;
    private final ChildComponentImplementationFactory childComponentImplementationFactory;
    private final Provider<GeneratedImplementation> topLevelImplementationProvider;
    private final Provider<ComponentRequestRepresentations> componentRequestRepresentationsProvider;
    private final Provider<ComponentCreatorImplementationFactory> componentCreatorImplementationFactoryProvider;
    private final BindingGraph graph;
    private final ComponentNames componentNames;
    private final CompilerOptions compilerOptions;
    private final ImmutableMap<ComponentImplementation, XPropertySpec> componentFieldsByImplementation;
    private final XMessager messager;
    private final CompilerMode compilerMode;
    private final XProcessingEnv processingEnv;

    private static ImmutableMap<Binding, ShardImplementation> createShardsByBinding(ShardImplementation componentShard, BindingGraph graph, CompilerOptions compilerOptions) {
        ImmutableList<ImmutableList<Binding>> partitions = ComponentImplementation.bindingPartitions(graph, compilerOptions);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < partitions.size(); ++i) {
            ShardImplementation shard = i == 0 ? componentShard : componentShard.createShard();
            ((ImmutableList)partitions.get(i)).forEach(binding -> builder.put(binding, (Object)shard));
        }
        return builder.build();
    }

    private static ImmutableList<ImmutableList<Binding>> bindingPartitions(BindingGraph graph, CompilerOptions compilerOptions) {
        int bindingsPerShard = compilerOptions.keysPerComponentShard(graph.componentTypeElement());
        int maxPartitions = graph.localBindingNodes().size() / bindingsPerShard + 1;
        if (maxPartitions <= 1) {
            return ImmutableList.of((Object)((ImmutableList)graph.localBindingNodes().stream().map(BindingNode::delegate).collect(DaggerStreams.toImmutableList())));
        }
        ArrayList currPartition = new ArrayList(bindingsPerShard);
        ImmutableList.Builder partitions = ImmutableList.builderWithExpectedSize((int)maxPartitions);
        for (ImmutableSet nodes2 : graph.topLevelBindingGraph().stronglyConnectedNodes()) {
            nodes2.stream().flatMap(DaggerStreams.instancesOf(BindingNode.class)).filter(bindingNode -> bindingNode.componentPath().equals(graph.componentPath())).map(BindingNode::delegate).forEach(currPartition::add);
            if (currPartition.size() < bindingsPerShard) continue;
            partitions.add((Object)ImmutableList.copyOf(currPartition));
            currPartition = new ArrayList(bindingsPerShard);
        }
        if (!currPartition.isEmpty()) {
            partitions.add((Object)ImmutableList.copyOf(currPartition));
        }
        return partitions.build();
    }

    @Inject
    ComponentImplementation(@ParentComponent Optional<ComponentImplementation> parent, ChildComponentImplementationFactory childComponentImplementationFactory, @TopLevel Provider<GeneratedImplementation> topLevelImplementationProvider, Provider<ComponentRequestRepresentations> componentRequestRepresentationsProvider, Provider<ComponentCreatorImplementationFactory> componentCreatorImplementationFactoryProvider, BindingGraph graph, ComponentNames componentNames, CompilerOptions compilerOptions, XMessager messager, XProcessingEnv processingEnv) {
        this.parent = parent;
        this.childComponentImplementationFactory = childComponentImplementationFactory;
        this.topLevelImplementationProvider = topLevelImplementationProvider;
        this.componentRequestRepresentationsProvider = componentRequestRepresentationsProvider;
        this.componentCreatorImplementationFactoryProvider = componentCreatorImplementationFactoryProvider;
        this.graph = graph;
        this.componentNames = componentNames;
        this.compilerOptions = compilerOptions;
        this.processingEnv = processingEnv;
        this.componentShard = new ShardImplementation(componentNames.get(graph.componentPath()));
        XTypeElements.getAllNonPrivateInstanceMethods(graph.componentTypeElement()).stream().forEach(method -> this.componentShard.componentMethodNames.claim(XElements.getSimpleName(method)));
        this.shardsByBinding = Suppliers.memoize(() -> ComponentImplementation.createShardsByBinding(this.componentShard, graph, compilerOptions));
        this.componentFieldsByImplementation = ComponentImplementation.createComponentFieldsByImplementation(this, compilerOptions);
        this.messager = messager;
        XTypeElement typeElement = this.rootComponentImplementation().componentDescriptor().typeElement();
        this.compilerMode = compilerOptions.fastInit(typeElement) ? CompilerMode.FAST_INIT : CompilerMode.DEFAULT;
    }

    public ShardImplementation shardImplementation(Binding binding) {
        Preconditions.checkState((boolean)((ImmutableMap)this.shardsByBinding.get()).containsKey((Object)binding), (String)"No shard in %s for: %s", (Object)this.name().getCanonicalName(), (Object)binding);
        return (ShardImplementation)((ImmutableMap)this.shardsByBinding.get()).get((Object)binding);
    }

    private GeneratedImplementation topLevelImplementation() {
        return (GeneratedImplementation)this.topLevelImplementationProvider.get();
    }

    public ComponentImplementation rootComponentImplementation() {
        return this.parent.map(ComponentImplementation::rootComponentImplementation).orElse(this);
    }

    public XCodeBlock componentFieldReference() {
        return XCodeBlock.of("%N", this.componentFieldsByImplementation.get((Object)this));
    }

    public ImmutableList<XPropertySpec> componentFields() {
        return ImmutableList.copyOf((Collection)this.componentFieldsByImplementation.values());
    }

    public ImmutableList<XPropertySpec> creatorComponentFields() {
        return (ImmutableList)this.componentFieldsByImplementation.entrySet().stream().filter(entry -> !this.equals(entry.getKey())).map(Map.Entry::getValue).collect(DaggerStreams.toImmutableList());
    }

    private static ImmutableMap<ComponentImplementation, XPropertySpec> createComponentFieldsByImplementation(ComponentImplementation componentImplementation, CompilerOptions compilerOptions) {
        Preconditions.checkArgument((componentImplementation.componentShard != null ? 1 : 0) != 0, (Object)"The component shard must be set before computing the component fields.");
        ImmutableList.Builder builder = ImmutableList.builder();
        ComponentImplementation curr = componentImplementation;
        while (curr != null) {
            builder.add((Object)curr);
            curr = curr.parent.orElse(null);
        }
        return (ImmutableMap)builder.build().reverse().stream().collect(DaggerStreams.toImmutableMap(componentImpl -> componentImpl, componentImpl -> {
            XClassName component = componentImpl.graph.componentPath().currentComponent().xprocessing().asClassName();
            XClassName fieldType = componentImpl.name();
            String fieldName = componentImpl.isNested() ? SourceFiles.simpleVariableName(componentImpl.name()) : SourceFiles.simpleVariableName(component);
            XPropertySpecs.Builder field = XPropertySpecs.builder(fieldName.equals(componentImpl.name().getSimpleName()) ? "_" + fieldName : fieldName, fieldType, Modifier.PRIVATE, Modifier.FINAL);
            componentImplementation.componentShard.componentFieldNames.claim(fieldName);
            return field.build();
        }));
    }

    public ShardImplementation getComponentShard() {
        return this.componentShard;
    }

    public BindingGraph graph() {
        return this.componentShard.graph();
    }

    public ComponentDescriptor componentDescriptor() {
        return this.componentShard.componentDescriptor();
    }

    public XClassName name() {
        return this.componentShard.name;
    }

    public CompilerMode compilerMode() {
        return this.compilerMode;
    }

    private boolean isNested() {
        return XTypeNames.enclosingClassName(this.name()) != null;
    }

    public XClassName getCreatorName() {
        return this.componentNames.getCreatorName(this.graph.componentPath());
    }

    public XTypeSpec generate() {
        return this.componentShard.generate();
    }

    private static ImmutableList<ComponentRequirement> constructorRequirements(BindingGraph graph) {
        if (graph.componentDescriptor().hasCreator()) {
            return graph.componentRequirements().asList();
        }
        if (graph.factoryMethod().isPresent()) {
            return graph.factoryMethodParameters().keySet().asList();
        }
        throw new AssertionError((Object)"Expected either a component creator or factory method but found neither.");
    }

    private static ImmutableList<XParameterSpec> makeFinal(List<XParameterSpec> parameters) {
        return (ImmutableList)parameters.stream().map(param -> XParameterSpecs.builder(param.getName(), param.getType()).addModifiers(Modifier.FINAL).build()).collect(DaggerStreams.toImmutableList());
    }

    public static interface ChildComponentImplementationFactory {
        public ComponentImplementation create(BindingGraph var1);
    }

    public final class ShardImplementation
    implements GeneratedImplementation {
        private final XClassName name;
        private final UniqueNameSet componentFieldNames = new UniqueNameSet();
        private final UniqueNameSet componentMethodNames = new UniqueNameSet();
        private final UniqueNameSet componentClassNames = new UniqueNameSet();
        private final UniqueNameSet assistedParamNames = new UniqueNameSet();
        private final List<XCodeBlock> initializations = new ArrayList<XCodeBlock>();
        private final SwitchingProviders switchingProviders;
        private final Map<Key, XCodeBlock> cancellations = new LinkedHashMap<Key, XCodeBlock>();
        private final Map<XVariableElement, String> uniqueAssistedName = new LinkedHashMap<XVariableElement, String>();
        private final List<XCodeBlock> componentRequirementInitializations = new ArrayList<XCodeBlock>();
        private final ImmutableMap<ComponentRequirement, XParameterSpec> constructorParameters;
        private final ListMultimap<FieldSpecKind, XPropertySpec> fieldSpecsMap = MultimapBuilder.enumKeys(FieldSpecKind.class).arrayListValues().build();
        private final ListMultimap<MethodSpecKind, XFunSpec> methodSpecsMap = MultimapBuilder.enumKeys(MethodSpecKind.class).arrayListValues().build();
        private final ListMultimap<TypeSpecKind, XTypeSpec> typeSpecsMap = MultimapBuilder.enumKeys(TypeSpecKind.class).arrayListValues().build();
        private final List<Supplier<XTypeSpec>> typeSuppliers = new ArrayList<Supplier<XTypeSpec>>();
        private boolean initialized = false;

        private ShardImplementation(XClassName name) {
            this.name = name;
            this.switchingProviders = new SwitchingProviders(this, ComponentImplementation.this.processingEnv);
            if (ComponentImplementation.this.graph.componentDescriptor().isProduction()) {
                this.claimMethodName(ComponentImplementation.CANCELLATION_LISTENER_METHOD_NAME);
            }
            this.constructorParameters = (ImmutableMap)ComponentImplementation.constructorRequirements(ComponentImplementation.this.graph).stream().collect(DaggerStreams.toImmutableMap(requirement -> requirement, requirement -> XParameterSpecs.of(this.getUniqueFieldName(requirement.variableName() + "Param"), requirement.type().asTypeName(), requirement.getNullability(), ComponentImplementation.this.compilerOptions)));
        }

        private ShardImplementation createShard() {
            Preconditions.checkState((boolean)this.isComponentShard(), (Object)"Only the componentShard can create other shards.");
            return new ShardImplementation(ComponentImplementation.this.topLevelImplementation().name().nestedClass(ComponentImplementation.this.topLevelImplementation().getUniqueClassName(ComponentImplementation.this.getComponentShard().name().getSimpleName() + "Shard")));
        }

        public ImmutableList<XParameterSpec> constructorParameters() {
            return this.constructorParameters.values().asList();
        }

        public SwitchingProviders getSwitchingProviders() {
            return this.switchingProviders;
        }

        public ComponentImplementation getComponentImplementation() {
            return ComponentImplementation.this;
        }

        public boolean isComponentShard() {
            return this == ComponentImplementation.this.componentShard;
        }

        public ImmutableMap<ComponentImplementation, XPropertySpec> componentFieldsByImplementation() {
            return ComponentImplementation.this.componentFieldsByImplementation;
        }

        public XCodeBlock shardFieldReference() {
            if (!this.isComponentShard() && !ComponentImplementation.this.shardFieldsByImplementation.containsKey(this)) {
                String shardFieldName = ComponentImplementation.this.componentShard.getUniqueFieldName(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, this.name.getSimpleName()));
                XPropertySpec shardField = XPropertySpecs.builder(shardFieldName, this.name, new Modifier[0]).build();
                ComponentImplementation.this.shardFieldsByImplementation.put(this, shardField);
            }
            return this.isComponentShard() ? ComponentImplementation.this.componentFieldReference() : XCodeBlock.of("%L.%N", ComponentImplementation.this.componentFieldReference(), ComponentImplementation.this.shardFieldsByImplementation.get(this));
        }

        public BindingGraph graph() {
            return ComponentImplementation.this.graph;
        }

        public ComponentDescriptor componentDescriptor() {
            return ComponentImplementation.this.graph.componentDescriptor();
        }

        @Override
        public XClassName name() {
            return this.name;
        }

        XClassName getSubcomponentCreatorSimpleName(Key creatorKey) {
            return ComponentImplementation.this.componentNames.getSubcomponentCreatorName(ComponentImplementation.this.graph.componentPath(), creatorKey);
        }

        XTypeName accessibleTypeName(XType type) {
            return Accessibility.accessibleTypeName(type, this.name(), ComponentImplementation.this.processingEnv);
        }

        boolean isTypeAccessible(XType type) {
            return Accessibility.isTypeAccessibleFrom(type, this.name.getPackageName());
        }

        @Override
        public void addField(FieldSpecKind fieldKind, XPropertySpec fieldSpec) {
            this.fieldSpecsMap.put((Object)fieldKind, (Object)fieldSpec);
        }

        @Override
        public void addMethod(MethodSpecKind methodKind, XFunSpec methodSpec) {
            this.methodSpecsMap.put((Object)methodKind, (Object)methodSpec);
        }

        @Override
        public void addType(TypeSpecKind typeKind, XTypeSpec typeSpec) {
            this.typeSpecsMap.put((Object)typeKind, (Object)typeSpec);
        }

        @Override
        public void addTypeSupplier(Supplier<XTypeSpec> typeSpecSupplier) {
            this.typeSuppliers.add(typeSpecSupplier);
        }

        void addInitialization(XCodeBlock codeBlock) {
            this.initializations.add(codeBlock);
        }

        void addComponentRequirementInitialization(XCodeBlock codeBlock) {
            this.componentRequirementInitializations.add(codeBlock);
        }

        void addCancellation(Key key, XCodeBlock codeBlock) {
            this.cancellations.putIfAbsent(key, codeBlock);
        }

        String getUniqueFieldName(String name) {
            return this.componentFieldNames.getUniqueName(name);
        }

        String getUniqueAssistedParamName(String name) {
            if (!this.initialized) {
                this.componentFieldsByImplementation().values().forEach(fieldSpec -> this.assistedParamNames.getUniqueName(XConverters.toJavaPoet((XPropertySpec)fieldSpec).name));
                this.initialized = true;
            }
            return this.assistedParamNames.getUniqueName(name);
        }

        public String getUniqueFieldNameForAssistedParam(XExecutableParameterElement parameter) {
            if (this.uniqueAssistedName.containsKey(parameter)) {
                return this.uniqueAssistedName.get(parameter);
            }
            String name = this.getUniqueAssistedParamName(parameter.getJvmName());
            this.uniqueAssistedName.put(parameter, name);
            return name;
        }

        public String getUniqueMethodName(String name) {
            return this.componentMethodNames.getUniqueName(name);
        }

        String getUniqueMethodName(BindingRequest request) {
            return this.uniqueMethodName(request, KeyVariableNamer.name(request.key()));
        }

        @Override
        public String getUniqueClassName(String name) {
            return this.componentClassNames.getUniqueName(name);
        }

        private String uniqueMethodName(BindingRequest request, String bindingName) {
            String baseMethodName = bindingName + (request.isRequestKind(RequestKind.INSTANCE) ? "" : CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, request.kindName()));
            return this.getUniqueMethodName(baseMethodName);
        }

        public String getParameterName(ComponentRequirement requirement) {
            return XConverters.toJavaPoet((XParameterSpec)((XParameterSpec)this.constructorParameters.get((Object)requirement))).name;
        }

        public void claimMethodName(CharSequence name) {
            this.componentMethodNames.claim(name);
        }

        public boolean isShardClassPrivate() {
            return this.modifiers().contains((Object)Modifier.PRIVATE);
        }

        @Override
        public XTypeSpec generate() {
            XTypeSpecs.Builder builder = XTypeSpecs.classBuilder(this.name);
            if (ComponentImplementation.this.processingEnv.getBackend() == XProcessingEnv.Backend.KSP) {
                ComponentImplementation.this.graph.componentDescriptor().modules().stream().filter(ModuleDescriptor::isImplicitlyIncluded).forEach(module -> builder.addOriginatingElement(module.moduleElement()));
            }
            if (this.isComponentShard()) {
                builder.superType(ComponentImplementation.this.graph.componentTypeElement());
                this.addCreator();
                this.addFactoryMethods();
                this.addInterfaceMethods();
                this.addChildComponents();
                this.addShards();
            }
            this.addConstructorAndInitializationMethods();
            if (ComponentImplementation.this.graph.componentDescriptor().isProduction() && (this.isComponentShard() || !this.cancellations.isEmpty())) {
                builder.superType(ComponentImplementation.this.processingEnv.requireTypeElement(XTypeNames.CANCELLATION_LISTENER));
                this.addCancellationListenerImplementation();
            }
            this.modifiers().forEach(xva$0 -> builder.addModifiers((Modifier)((Object)xva$0)));
            this.fieldSpecsMap.asMap().values().forEach(builder::addProperties);
            this.methodSpecsMap.asMap().values().forEach(builder::addFunctions);
            this.typeSpecsMap.asMap().values().forEach(builder::addTypes);
            this.typeSuppliers.stream().map(Supplier::get).forEach(builder::addType);
            if (!ComponentImplementation.this.compilerOptions.generatedClassExtendsComponent() && this.isComponentShard() && ComponentImplementation.this.graph.componentPath().atRoot()) {
                ComponentImplementation.this.topLevelImplementation().addType(TypeSpecKind.COMPONENT_IMPL, builder.build());
                return ComponentImplementation.this.topLevelImplementation().generate();
            }
            return builder.build();
        }

        private ImmutableSet<Modifier> modifiers() {
            return ComponentImplementation.this.isNested() || !this.isComponentShard() ? ImmutableSet.of((Object)((Object)Modifier.PRIVATE), (Object)((Object)Modifier.STATIC), (Object)((Object)Modifier.FINAL)) : (ComponentImplementation.this.graph.componentTypeElement().isPublic() ? ImmutableSet.of((Object)((Object)Modifier.PUBLIC), (Object)((Object)Modifier.FINAL)) : ImmutableSet.of((Object)((Object)Modifier.FINAL)));
        }

        private void addCreator() {
            ((ComponentCreatorImplementationFactory)ComponentImplementation.this.componentCreatorImplementationFactoryProvider.get()).create().map(ComponentCreatorImplementation::spec).ifPresent(creator -> ComponentImplementation.this.topLevelImplementation().addType(TypeSpecKind.COMPONENT_CREATOR, (XTypeSpec)creator));
        }

        private void addFactoryMethods() {
            if (ComponentImplementation.this.parent.isPresent()) {
                ComponentImplementation.this.graph.factoryMethod().ifPresent(this::createSubcomponentFactoryMethod);
            } else {
                this.createRootComponentFactoryMethod();
            }
        }

        private void createRootComponentFactoryMethod() {
            boolean noArgFactoryMethod;
            String factoryMethodName;
            XClassName creatorType;
            ComponentCreatorKind creatorKind;
            Preconditions.checkState((!ComponentImplementation.this.parent.isPresent() ? 1 : 0) != 0);
            Optional<ComponentCreatorDescriptor> creatorDescriptor = ComponentImplementation.this.graph.componentDescriptor().creatorDescriptor();
            if (creatorDescriptor.isPresent()) {
                ComponentCreatorDescriptor descriptor = creatorDescriptor.get();
                creatorKind = descriptor.kind();
                creatorType = descriptor.typeElement().asClassName();
                factoryMethodName = XElements.getSimpleName(descriptor.factoryMethod());
                noArgFactoryMethod = descriptor.factoryParameters().isEmpty();
            } else {
                creatorKind = ComponentCreatorKind.BUILDER;
                creatorType = ComponentImplementation.this.getCreatorName();
                factoryMethodName = "build";
                noArgFactoryMethod = true;
            }
            this.validateMethodNameDoesNotOverrideGeneratedCreator(creatorKind.methodName());
            this.claimMethodName(creatorKind.methodName());
            ComponentImplementation.this.topLevelImplementation().addMethod(MethodSpecKind.BUILDER_METHOD, XFunSpecs.methodBuilder(creatorKind.methodName()).addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(creatorType).addStatement("return %L", XCodeBlock.ofNewInstance(ComponentImplementation.this.getCreatorName(), "", new Object[0])).build());
            if (noArgFactoryMethod && this.canInstantiateAllRequirements()) {
                this.validateMethodNameDoesNotOverrideGeneratedCreator("create");
                this.claimMethodName("create");
                ComponentImplementation.this.topLevelImplementation().addMethod(MethodSpecKind.BUILDER_METHOD, XFunSpecs.methodBuilder("create").returns(ComponentImplementation.this.graph.componentTypeElement().asClassName()).addModifiers(Modifier.PUBLIC, Modifier.STATIC).addStatement("return %L.%N()", XCodeBlock.ofNewInstance(ComponentImplementation.this.topLevelImplementation().name().nestedClass(creatorKind.typeName()), "", new Object[0]), factoryMethodName).build());
            }
        }

        private void validateMethodNameDoesNotOverrideGeneratedCreator(String creatorName) {
            XTypeElements.getAllMethods(ComponentImplementation.this.graph.componentTypeElement()).stream().filter(method -> XElements.getSimpleName(method).contentEquals(creatorName)).filter(method -> method.getParameters().isEmpty()).filter(method -> !method.isStatic()).forEach(method -> ComponentImplementation.this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("The method %s.%s() conflicts with a method of the same name Dagger is trying to generate as a way to instantiate the component. Please choose a different name for your method.", method.getEnclosingElement().getClassName().canonicalName(), XElements.getSimpleName(method))));
        }

        private boolean canInstantiateAllRequirements() {
            return !Iterables.any(ComponentImplementation.this.graph.componentRequirements(), ComponentRequirement::requiresAPassedInstance);
        }

        private void createSubcomponentFactoryMethod(XMethodElement factoryMethod) {
            Preconditions.checkState((boolean)ComponentImplementation.this.parent.isPresent());
            XType parentType = ((ComponentImplementation)ComponentImplementation.this.parent.get()).graph().componentTypeElement().getType();
            XFunSpecs.Builder method = XFunSpecs.overriding(factoryMethod, parentType, ComponentImplementation.this.compilerOptions);
            method.getParameters().forEach(param -> method.addStatement("%T.checkNotNull(%N)", XTypeNames.DAGGER_PRECONDITIONS, param.getName()));
            method.addStatement("return %L", XCodeBlock.ofNewInstance(this.name(), "%L", Stream.concat(ComponentImplementation.this.creatorComponentFields().stream().map(field -> XCodeBlock.of("%N", field)), method.getParameters().stream().map(param -> XCodeBlock.of("%N", param.getName()))).collect(XCodeBlocks.toParametersCodeBlock())));
            ((ComponentImplementation)ComponentImplementation.this.parent.get()).getComponentShard().addMethod(MethodSpecKind.COMPONENT_METHOD, method.build());
        }

        private void addInterfaceMethods() {
            XType componentType = ComponentImplementation.this.graph.componentTypeElement().getType();
            HashSet<MethodSignature> methodDescriptors = new HashSet<MethodSignature>();
            for (ComponentDescriptor.ComponentMethodDescriptor method : ComponentImplementation.this.graph.entryPointMethods()) {
                MethodSignature signature = MethodSignature.forComponentMethod(method, componentType, ComponentImplementation.this.processingEnv);
                if (!methodDescriptors.add(signature)) continue;
                this.addMethod(MethodSpecKind.COMPONENT_METHOD, ((ComponentRequestRepresentations)ComponentImplementation.this.componentRequestRepresentationsProvider.get()).getComponentMethod(method));
            }
        }

        private void addChildComponents() {
            for (BindingGraph subgraph : ComponentImplementation.this.graph.subgraphs()) {
                ComponentImplementation.this.topLevelImplementation().addType(TypeSpecKind.COMPONENT_IMPL, ComponentImplementation.this.childComponentImplementationFactory.create(subgraph).generate());
            }
        }

        private void addShards() {
            for (ShardImplementation shard : ImmutableSet.copyOf((Collection)((ImmutableMap)ComponentImplementation.this.shardsByBinding.get()).values())) {
                if (!ComponentImplementation.this.shardFieldsByImplementation.containsKey(shard)) continue;
                this.addField(FieldSpecKind.COMPONENT_SHARD_FIELD, (XPropertySpec)ComponentImplementation.this.shardFieldsByImplementation.get(shard));
                ComponentImplementation.this.topLevelImplementation().addType(TypeSpecKind.COMPONENT_SHARD_TYPE, shard.generate());
            }
        }

        private void addConstructorAndInitializationMethods() {
            XFunSpecs.Builder constructor = XFunSpecs.constructorBuilder();
            if (!this.isShardClassPrivate()) {
                constructor.addModifiers(Modifier.PRIVATE);
            }
            ImmutableList parameters = this.constructorParameters.values().asList();
            this.componentFieldsByImplementation().forEach((componentImplementation, field) -> {
                if (this.isComponentShard() && componentImplementation.equals(ComponentImplementation.this)) {
                    this.addField(FieldSpecKind.COMPONENT_REQUIREMENT_FIELD, field.toBuilder().initializer(XCodeBlock.of("this", new Object[0])).build());
                } else {
                    this.addField(FieldSpecKind.COMPONENT_REQUIREMENT_FIELD, (XPropertySpec)field);
                    constructor.addStatement("this.%1N = %1N", field);
                    constructor.addParameter(field.getName(), field.getType());
                }
            });
            if (this.isComponentShard()) {
                constructor.addCode(XCodeBlocks.concat(this.componentRequirementInitializations));
            }
            constructor.addParameters((Collection<XParameterSpec>)parameters);
            XCodeBlock args = XCodeBlocks.parameterNames((Iterable<XParameterSpec>)parameters);
            ImmutableList<XFunSpec> initializationMethods = this.createPartitionedMethods("initialize", (Collection<XParameterSpec>)ComponentImplementation.makeFinal((List)parameters), this.initializations, (Function<String, XFunSpecs.Builder>)((Function)methodName -> XFunSpecs.methodBuilder(methodName).addAnnotation(XAnnotationSpecs.suppressWarnings(XAnnotationSpecs.Suppression.UNCHECKED, new XAnnotationSpecs.Suppression[0]))));
            for (XFunSpec initializationMethod : initializationMethods) {
                constructor.addStatement("%N(%L)", initializationMethod, args);
                this.addMethod(MethodSpecKind.INITIALIZE_METHOD, initializationMethod);
            }
            if (this.isComponentShard()) {
                constructor.addCode(XCodeBlocks.concat(ComponentImplementation.this.shardInitializations));
            } else {
                XCodeBlock componentArgs = XCodeBlocks.parameterNames((Iterable<XParameterSpec>)((ComponentImplementation)ComponentImplementation.this).componentShard.constructorParameters.values().asList());
                XCodeBlock componentFields = this.componentFieldsByImplementation().values().stream().map(field -> XCodeBlock.of("%N", field)).collect(XCodeBlocks.toParametersCodeBlock());
                ComponentImplementation.this.shardInitializations.add(XCodeBlock.of("%N = %L;", ComponentImplementation.this.shardFieldsByImplementation.get(this), XCodeBlock.ofNewInstance(this.name, "%L", XCodeBlocks.isEmpty(componentArgs) ? componentFields : XCodeBlocks.makeParametersCodeBlock((Iterable<XCodeBlock>)ImmutableList.of((Object)componentFields, (Object)componentArgs)))));
            }
            this.addMethod(MethodSpecKind.CONSTRUCTOR, constructor.build());
        }

        private void addCancellationListenerImplementation() {
            XFunSpecs.Builder methodBuilder = XFunSpecs.methodBuilder(ComponentImplementation.CANCELLATION_LISTENER_METHOD_NAME).isOverride(true).addModifiers(Modifier.PUBLIC).addParameter(MAY_INTERRUPT_IF_RUNNING_PARAM);
            if (this.isComponentShard()) {
                methodBuilder.addCode(XCodeBlocks.concat((Iterable<XCodeBlock>)ImmutableList.copyOf((Collection)ComponentImplementation.this.shardCancellations).reverse()));
            } else if (!this.cancellations.isEmpty()) {
                ComponentImplementation.this.shardCancellations.add(XCodeBlock.of("%N.%N(%N);", ComponentImplementation.this.shardFieldsByImplementation.get(this), ComponentImplementation.CANCELLATION_LISTENER_METHOD_NAME, MAY_INTERRUPT_IF_RUNNING_PARAM.getName()));
            }
            ImmutableList cancellationStatements = ImmutableList.copyOf(this.cancellations.values()).reverse();
            if (cancellationStatements.size() < 25) {
                methodBuilder.addCode(XCodeBlocks.concat((Iterable<XCodeBlock>)cancellationStatements));
            } else {
                ImmutableList<XFunSpec> cancelProducersMethods = this.createPartitionedMethods("cancelProducers", (Collection<XParameterSpec>)ImmutableList.of((Object)MAY_INTERRUPT_IF_RUNNING_PARAM), (List<XCodeBlock>)cancellationStatements, (Function<String, XFunSpecs.Builder>)((Function)methodName -> XFunSpecs.methodBuilder(methodName).addModifiers(Modifier.PRIVATE)));
                for (XFunSpec cancelProducersMethod : cancelProducersMethods) {
                    methodBuilder.addStatement("%N(%N)", cancelProducersMethod, MAY_INTERRUPT_IF_RUNNING_PARAM.getName());
                    this.addMethod(MethodSpecKind.CANCELLATION_LISTENER_METHOD, cancelProducersMethod);
                }
            }
            if (this.isComponentShard()) {
                this.cancelParentStatement().ifPresent(methodBuilder::addCode);
            }
            this.addMethod(MethodSpecKind.CANCELLATION_LISTENER_METHOD, methodBuilder.build());
        }

        private Optional<XCodeBlock> cancelParentStatement() {
            if (!this.shouldPropagateCancellationToParent()) {
                return Optional.empty();
            }
            return Optional.of(XCodeBlock.builder().addStatement("%L.%N(%N)", ((ComponentImplementation)ComponentImplementation.this.parent.get()).componentFieldReference(), ComponentImplementation.CANCELLATION_LISTENER_METHOD_NAME, MAY_INTERRUPT_IF_RUNNING_PARAM.getName()).build());
        }

        private boolean shouldPropagateCancellationToParent() {
            return ComponentImplementation.this.parent.isPresent() && ((ComponentImplementation)ComponentImplementation.this.parent.get()).componentDescriptor().cancellationPolicy().map(policy -> policy.equals((Object)CancellationPolicy.PROPAGATE)).orElse(false) != false;
        }

        private ImmutableList<XFunSpec> createPartitionedMethods(String methodName, Collection<XParameterSpec> parameters, List<XCodeBlock> statements, Function<String, XFunSpecs.Builder> methodBuilderCreator) {
            return (ImmutableList)Lists.partition(statements, (int)25).stream().map(partition -> ((XFunSpecs.Builder)methodBuilderCreator.apply((Object)this.getUniqueMethodName(methodName))).addModifiers(Modifier.PRIVATE).addParameters(parameters).addCode(XCodeBlocks.concat(partition)).build()).collect(DaggerStreams.toImmutableList());
        }
    }

    public static enum CompilerMode {
        DEFAULT,
        FAST_INIT;


        public boolean isFastInit() {
            return this == FAST_INIT;
        }
    }

    public static enum TypeSpecKind {
        PRESENT_FACTORY,
        COMPONENT_CREATOR,
        COMPONENT_PROVISION_FACTORY,
        COMPONENT_IMPL,
        COMPONENT_SHARD_TYPE;

    }

    public static enum MethodSpecKind {
        CONSTRUCTOR,
        BUILDER_METHOD,
        PRIVATE_METHOD,
        INITIALIZE_METHOD,
        INITIALIZE_HELPER_METHOD,
        COMPONENT_METHOD,
        MEMBERS_INJECTION_METHOD,
        ABSENT_OPTIONAL_METHOD,
        CANCELLATION_LISTENER_METHOD;

    }

    public static enum FieldSpecKind {
        COMPONENT_SHARD_FIELD,
        COMPONENT_REQUIREMENT_FIELD,
        FRAMEWORK_FIELD,
        ABSENT_OPTIONAL_FIELD;

    }
}

