/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.devtools.ksp.symbol.Origin;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dagger.internal.codegen.base.Keys;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.AssistedInjectionBinding;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingDeclaration;
import dagger.internal.codegen.binding.BindingFactory;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.Declaration;
import dagger.internal.codegen.binding.InjectBindingRegistry;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.binding.InjectionBinding;
import dagger.internal.codegen.binding.KeyFactory;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.MembersInjectorBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.validation.InjectValidator;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFieldElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMessager;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.tools.Diagnostic;

@Singleton
final class InjectBindingRegistryImpl
implements InjectBindingRegistry {
    private final XProcessingEnv processingEnv;
    private final XMessager messager;
    private final InjectValidator injectValidator;
    private final KeyFactory keyFactory;
    private final BindingFactory bindingFactory;
    private final CompilerOptions compilerOptions;
    private final BindingsCollection<ContributionBinding> injectionBindings = new BindingsCollection(XTypeNames.JAVAX_PROVIDER);
    private final BindingsCollection<MembersInjectionBinding> membersInjectionBindings = new BindingsCollection(XTypeNames.MEMBERS_INJECTOR);

    @Inject
    InjectBindingRegistryImpl(XProcessingEnv processingEnv, XMessager messager, InjectValidator injectValidator, KeyFactory keyFactory, BindingFactory bindingFactory, CompilerOptions compilerOptions) {
        this.processingEnv = processingEnv;
        this.messager = messager;
        this.injectValidator = injectValidator;
        this.keyFactory = keyFactory;
        this.bindingFactory = bindingFactory;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public void generateSourcesForRequiredBindings(SourceFileGenerator<ContributionBinding> factoryGenerator, SourceFileGenerator<MembersInjectionBinding> membersInjectorGenerator) {
        this.injectionBindings.generateBindings(factoryGenerator);
        this.membersInjectionBindings.generateBindings(membersInjectorGenerator);
    }

    @Override
    public Optional<ContributionBinding> tryRegisterInjectConstructor(XConstructorElement constructorElement) {
        return this.tryRegisterConstructor(constructorElement, Optional.empty(), true);
    }

    @CanIgnoreReturnValue
    private Optional<ContributionBinding> tryRegisterConstructor(XConstructorElement constructorElement, Optional<XType> resolvedType, boolean isCalledFromInjectProcessor) {
        XTypeElement typeElement = constructorElement.getEnclosingElement();
        ValidationReport report = this.injectValidator.validate(typeElement);
        report.printMessagesTo(this.messager);
        if (!report.isClean()) {
            return Optional.empty();
        }
        XType type = typeElement.getType();
        Key key = this.keyFactory.forInjectConstructorWithResolvedType(type);
        ContributionBinding cachedBinding = this.injectionBindings.getBinding(key);
        if (cachedBinding != null) {
            return Optional.of(cachedBinding);
        }
        if (InjectionAnnotations.hasInjectAnnotation(constructorElement)) {
            InjectionBinding binding = this.bindingFactory.injectionBinding(constructorElement, resolvedType);
            this.injectionBindings.tryRegisterBinding(binding, isCalledFromInjectProcessor);
            if (!binding.injectionSites().isEmpty()) {
                this.tryRegisterMembersInjectedType(typeElement, resolvedType, isCalledFromInjectProcessor);
            }
            return Optional.of(binding);
        }
        if (constructorElement.hasAnnotation(XTypeNames.ASSISTED_INJECT)) {
            AssistedInjectionBinding binding = this.bindingFactory.assistedInjectionBinding(constructorElement, resolvedType);
            this.injectionBindings.tryRegisterBinding(binding, isCalledFromInjectProcessor);
            if (!binding.injectionSites().isEmpty()) {
                this.tryRegisterMembersInjectedType(typeElement, resolvedType, isCalledFromInjectProcessor);
            }
            return Optional.of(binding);
        }
        throw new AssertionError((Object)("Expected either an @Inject or @AssistedInject annotated constructor: " + constructorElement.getEnclosingElement().getQualifiedName()));
    }

    @Override
    public Optional<MembersInjectionBinding> tryRegisterInjectField(XFieldElement fieldElement) {
        if (!XElementKt.isTypeElement(fieldElement.getEnclosingElement())) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "@Inject fields must be enclosed in a type.", fieldElement);
        }
        return this.tryRegisterMembersInjectedType(XElements.asTypeElement(fieldElement.getEnclosingElement()), Optional.empty(), true);
    }

    @Override
    public Optional<MembersInjectionBinding> tryRegisterInjectMethod(XMethodElement methodElement) {
        if (!XElementKt.isTypeElement(methodElement.getEnclosingElement())) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "@Inject methods must be enclosed in a type.", methodElement);
        }
        return this.tryRegisterMembersInjectedType(XElements.asTypeElement(methodElement.getEnclosingElement()), Optional.empty(), true);
    }

    @CanIgnoreReturnValue
    private Optional<MembersInjectionBinding> tryRegisterMembersInjectedType(XTypeElement typeElement, Optional<XType> resolvedType, boolean isCalledFromInjectProcessor) {
        ValidationReport report = this.injectValidator.validateForMembersInjection(typeElement);
        report.printMessagesTo(this.messager);
        if (!report.isClean()) {
            return Optional.empty();
        }
        XType type = typeElement.getType();
        Key key = this.keyFactory.forInjectConstructorWithResolvedType(type);
        MembersInjectionBinding cachedBinding = this.membersInjectionBindings.getBinding(key);
        if (cachedBinding != null) {
            return Optional.of(cachedBinding);
        }
        MembersInjectionBinding binding = this.bindingFactory.membersInjectionBinding(type, resolvedType);
        this.membersInjectionBindings.tryRegisterBinding(binding, isCalledFromInjectProcessor);
        Optional<XType> supertype = XTypes.nonObjectSuperclass(type);
        while (supertype.isPresent()) {
            this.getOrFindMembersInjectionBinding(this.keyFactory.forMembersInjectedType(supertype.get()));
            supertype = XTypes.nonObjectSuperclass(supertype.get());
        }
        return Optional.of(binding);
    }

    @Override
    @CanIgnoreReturnValue
    public Optional<ContributionBinding> getOrFindInjectionBinding(Key key) {
        Preconditions.checkNotNull((Object)key);
        if (!Keys.isValidImplicitProvisionKey(key)) {
            return Optional.empty();
        }
        ContributionBinding binding = this.injectionBindings.getBinding(key);
        if (binding != null) {
            return Optional.of(binding);
        }
        XType type = key.type().xprocessing();
        XTypeElement element = type.getTypeElement();
        ValidationReport report = this.injectValidator.validate(element);
        report.printMessagesTo(this.messager);
        if (!report.isClean()) {
            return Optional.empty();
        }
        return ((Optional)Stream.concat(InjectionAnnotations.injectedConstructors(element).stream(), AssistedInjectionAnnotations.assistedInjectedConstructors(element).stream()).collect(DaggerCollectors.toOptional())).flatMap(constructor -> this.tryRegisterConstructor((XConstructorElement)constructor, Optional.of(type), false));
    }

    @Override
    @CanIgnoreReturnValue
    public Optional<MembersInjectionBinding> getOrFindMembersInjectionBinding(Key key) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((boolean)Keys.isValidMembersInjectionKey(key));
        MembersInjectionBinding binding = this.membersInjectionBindings.getBinding(key);
        if (binding != null) {
            return Optional.of(binding);
        }
        return this.tryRegisterMembersInjectedType(key.type().xprocessing().getTypeElement(), Optional.of(key.type().xprocessing()), false);
    }

    @Override
    public Optional<MembersInjectorBinding> getOrFindMembersInjectorBinding(Key key) {
        if (!Keys.isValidMembersInjectionKey(key)) {
            return Optional.empty();
        }
        Key membersInjectionKey = this.keyFactory.forMembersInjectedType(XTypes.unwrapType(key.type().xprocessing()));
        return this.getOrFindMembersInjectionBinding(membersInjectionKey).map(binding -> this.bindingFactory.membersInjectorBinding(key, (MembersInjectionBinding)binding));
    }

    private final class BindingsCollection<B extends Binding> {
        private final XClassName factoryClass;
        private final Map<Key, B> bindingsByKey = Maps.newLinkedHashMap();
        private final Deque<B> bindingsRequiringGeneration = new ArrayDeque<B>();
        private final Set<Key> materializedBindingKeys = Sets.newLinkedHashSet();

        BindingsCollection(XClassName factoryClass) {
            this.factoryClass = factoryClass;
        }

        void generateBindings(SourceFileGenerator<B> generator) {
            Binding binding = (Binding)this.bindingsRequiringGeneration.poll();
            while (binding != null) {
                Preconditions.checkState((!binding.unresolved().isPresent() ? 1 : 0) != 0);
                XType type = binding.key().type().xprocessing();
                if (!XTypes.isDeclared(type) || InjectBindingRegistryImpl.this.injectValidator.validateWhenGeneratingCode(type.getTypeElement()).isClean()) {
                    generator.generate(binding);
                }
                this.materializedBindingKeys.add(binding.key());
                binding = (Binding)this.bindingsRequiringGeneration.poll();
            }
            this.bindingsByKey.clear();
        }

        B getBinding(Key key) {
            return (B)((Binding)this.bindingsByKey.get(key));
        }

        void tryRegisterBinding(B binding, boolean isCalledFromInjectProcessor) {
            if (InjectBindingRegistryImpl.this.processingEnv.getBackend() == XProcessingEnv.Backend.KSP) {
                Origin origin = XConverters.toKS(XElements.closestEnclosingTypeElement(((Declaration)binding).bindingElement().get())).getOrigin();
                if (!(isCalledFromInjectProcessor || origin != Origin.JAVA && origin != Origin.KOTLIN)) {
                    return;
                }
            }
            this.tryToCacheBinding(binding);
            B maybeUnresolved = ((BindingDeclaration)binding).unresolved().isPresent() ? ((BindingDeclaration)binding).unresolved().get() : binding;
            this.tryToGenerateBinding(maybeUnresolved, isCalledFromInjectProcessor);
        }

        void tryToGenerateBinding(B binding, boolean isCalledFromInjectProcessor) {
            if (this.shouldGenerateBinding(binding)) {
                this.bindingsRequiringGeneration.offer(binding);
                if (InjectBindingRegistryImpl.this.compilerOptions.warnIfInjectionFactoryNotGeneratedUpstream() && !isCalledFromInjectProcessor) {
                    InjectBindingRegistryImpl.this.messager.printMessage(Diagnostic.Kind.NOTE, String.format("Generating a %s for %s. Prefer to run the dagger processor over that class instead.", this.factoryClass.getSimpleName(), XTypes.erasedTypeName(((Declaration)binding).key().type().xprocessing())));
                }
            }
        }

        private boolean shouldGenerateBinding(B binding) {
            if (binding instanceof MembersInjectionBinding) {
                boolean hasInjectConstructor;
                MembersInjectionBinding membersInjectionBinding = (MembersInjectionBinding)binding;
                if (membersInjectionBinding.injectionSites().isEmpty()) {
                    return false;
                }
                boolean bl = hasInjectConstructor = !InjectionAnnotations.injectedConstructors(membersInjectionBinding.membersInjectedType()).isEmpty() || !AssistedInjectionAnnotations.assistedInjectedConstructors(membersInjectionBinding.membersInjectedType()).isEmpty();
                if (!membersInjectionBinding.hasLocalInjectionSites() && !hasInjectConstructor) {
                    return false;
                }
            }
            return !((BindingDeclaration)binding).unresolved().isPresent() && !this.materializedBindingKeys.contains(((Declaration)binding).key()) && !this.bindingsRequiringGeneration.contains(binding) && InjectBindingRegistryImpl.this.processingEnv.findTypeElement(SourceFiles.generatedClassNameForBinding(binding)) == null;
        }

        private void tryToCacheBinding(B binding) {
            if (((BindingDeclaration)binding).unresolved().isPresent() || ((Declaration)binding).bindingTypeElement().get().getType().getTypeArguments().isEmpty()) {
                Key key = ((Declaration)binding).key();
                Binding previousValue = (Binding)this.bindingsByKey.put(key, binding);
                Preconditions.checkState((previousValue == null || binding.equals(previousValue) ? 1 : 0) != 0, (String)"couldn't register %s. %s was already registered for %s", binding, (Object)previousValue, (Object)key);
            }
        }
    }
}

