/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.xprocessing.XAnnotationSpecs;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypeSpecs;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.CodeLanguage;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XAnnotationSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XFileSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMessager;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Optional;

public abstract class SourceFileGenerator<T> {
    private static final String GENERATED_COMMENTS = "https://dagger.dev";
    private final XFiler filer;
    private final XProcessingEnv processingEnv;

    public SourceFileGenerator(XFiler filer, XProcessingEnv processingEnv) {
        this.filer = (XFiler)Preconditions.checkNotNull((Object)filer);
        this.processingEnv = (XProcessingEnv)Preconditions.checkNotNull((Object)processingEnv);
    }

    public SourceFileGenerator(SourceFileGenerator<T> delegate) {
        this(delegate.filer, delegate.processingEnv);
    }

    public void generate(T input, XMessager messager) {
        this.generate(input);
    }

    public void generate(T input) {
        for (XTypeSpec type : this.topLevelTypes(input)) {
            this.buildFile(input, XTypeSpecs.toBuilder(type)).writeTo(this.codeLanguage(), this.filer, XFiler.Mode.Isolating);
        }
    }

    public CodeLanguage codeLanguage() {
        return CodeLanguage.JAVA;
    }

    private XFileSpec buildFile(T input, XTypeSpec.Builder typeSpecBuilder) {
        XElement originatingElement = this.originatingElement(input);
        typeSpecBuilder.addOriginatingElement(originatingElement).addAnnotation(XAnnotationSpec.of(XTypeNames.DAGGER_GENERATED));
        Optional<XAnnotationSpec> generatedAnnotation = this.findGeneratedAnnotation().map(annotation -> XAnnotationSpecs.builder(annotation.asClassName()).addArrayMember("value", "%S", "dagger.internal.codegen.ComponentProcessor").addMember("comments", "%S", GENERATED_COMMENTS).build());
        generatedAnnotation.ifPresent(typeSpecBuilder::addAnnotation);
        typeSpecBuilder.addAnnotation(XAnnotationSpecs.suppressWarnings((ImmutableSet<XAnnotationSpecs.Suppression>)ImmutableSet.builder().addAll(this.warningSuppressions()).add((Object[])new XAnnotationSpecs.Suppression[]{XAnnotationSpecs.Suppression.UNCHECKED, XAnnotationSpecs.Suppression.RAWTYPES, XAnnotationSpecs.Suppression.KOTLIN_INTERNAL, XAnnotationSpecs.Suppression.CAST, XAnnotationSpecs.Suppression.DEPRECATION, XAnnotationSpecs.Suppression.UNINITIALIZED}).build()));
        String packageName = XElements.closestEnclosingTypeElement(originatingElement).getPackageName();
        XFileSpec.Builder fileBuilder = XFileSpec.builder(packageName, typeSpecBuilder.build());
        XConverters.toJavaPoet(fileBuilder).skipJavaLangImports(true);
        if (!generatedAnnotation.isPresent()) {
            fileBuilder.addFileComment("Generated by Dagger (%L).", GENERATED_COMMENTS);
        }
        return fileBuilder.build();
    }

    private Optional<XTypeElement> findGeneratedAnnotation() {
        return Optional.ofNullable(this.processingEnv.findTypeElement("javax.annotation.processing.Generated")).or(() -> Optional.ofNullable(this.processingEnv.findTypeElement("javax.annotation.Generated")));
    }

    public abstract XElement originatingElement(T var1);

    public abstract ImmutableList<XTypeSpec> topLevelTypes(T var1);

    protected ImmutableSet<XAnnotationSpecs.Suppression> warningSuppressions() {
        return ImmutableSet.of();
    }
}

