/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.base.RequestKinds;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;

public final class MapType {
    private static final ImmutableSet<RequestKind> VALID_FRAMEWORK_REQUEST_KINDS = ImmutableSet.of((Object)((Object)RequestKind.PROVIDER), (Object)((Object)RequestKind.PRODUCER), (Object)((Object)RequestKind.PRODUCED));
    private final XType type;

    public static MapType from(Key key) {
        return MapType.from(key.type().xprocessing());
    }

    public static MapType from(XType type) {
        Preconditions.checkArgument((boolean)MapType.isMap(type), (String)"%s is not a Map", (Object)type);
        return new MapType(type);
    }

    private MapType(XType type) {
        this.type = type;
    }

    XTypeName typeName() {
        return this.type.asTypeName();
    }

    public boolean isRawType() {
        return XTypes.isRawParameterizedType(this.type);
    }

    public XType keyType() {
        Preconditions.checkState((!this.isRawType() ? 1 : 0) != 0);
        return this.type.getTypeArguments().get(0);
    }

    public XType valueType() {
        Preconditions.checkState((!this.isRawType() ? 1 : 0) != 0);
        return this.type.getTypeArguments().get(1);
    }

    public boolean valuesAreTypeOf(XClassName className) {
        return !this.isRawType() && XTypes.isTypeOf(this.valueType(), className);
    }

    public boolean valuesAreFrameworkType() {
        return this.valueRequestKind() != RequestKind.INSTANCE;
    }

    public boolean valuesAreProvider() {
        return XTypeNames.providerTypeNames().stream().anyMatch(this::valuesAreTypeOf);
    }

    public XType unwrappedFrameworkValueType() {
        return this.valuesAreFrameworkType() ? XTypes.unwrapType(this.valueType()) : this.valueType();
    }

    public RequestKind valueRequestKind() {
        Preconditions.checkArgument((!this.isRawType() ? 1 : 0) != 0);
        RequestKind requestKind = RequestKinds.getRequestKind(this.valueType());
        if (VALID_FRAMEWORK_REQUEST_KINDS.contains((Object)requestKind)) {
            return requestKind;
        }
        if (requestKind == RequestKind.PROVIDER_OF_LAZY) {
            return RequestKind.PROVIDER;
        }
        return RequestKind.INSTANCE;
    }

    public static boolean isMap(XType type) {
        return XTypes.isTypeOf(type, XTypeName.MAP) || XTypes.isTypeOf(type, XTypeName.MUTABLE_MAP) || XTypes.isTypeOf(type, XTypeNames.JAVA_UTIL_MAP);
    }

    public static boolean isMap(Key key) {
        return MapType.isMap(key.type().xprocessing());
    }

    public static boolean isMapOfProvider(XType keyType) {
        if (MapType.isMap(keyType)) {
            return MapType.from(keyType).valuesAreProvider();
        }
        return false;
    }
}

