/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.ServiceLoader;
import javax.annotation.processing.ProcessingEnvironment;

final class ServiceLoaders {
    private ServiceLoaders() {
    }

    static <T> ImmutableSet<T> loadServices(XProcessingEnv processingEnv, Class<T> clazz) {
        return ImmutableSet.copyOf(ServiceLoader.load(clazz, ServiceLoaders.classLoaderFor(processingEnv, clazz)));
    }

    private static ClassLoader classLoaderFor(XProcessingEnv processingEnv, Class<?> clazz) {
        switch (processingEnv.getBackend()) {
            case JAVAC: {
                return ServiceLoaders.javaClassLoader(XConverters.toJavac(processingEnv), clazz);
            }
            case KSP: {
                return clazz.getClassLoader();
            }
        }
        throw new AssertionError((Object)("Unexpected backend: " + (Object)((Object)processingEnv.getBackend())));
    }

    private static ClassLoader javaClassLoader(ProcessingEnvironment javacProcessingEnv, Class<?> clazz) {
        return clazz.getClassLoader();
    }
}

