/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.Nullability;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XAnnotationSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import java.util.List;

public final class NullableTypeNames {
    public static XTypeName appendTypeUseNullable(XTypeName typeName, XAnnotationSpec nullable, CompilerOptions compilerOptions) {
        NullableTypeNames.checkIsNullable(nullable);
        return typeName;
    }

    private static void checkIsNullable(XAnnotationSpec annotation) {
        TypeName typeName = XConverters.toJavaPoet((XAnnotationSpec)annotation).type;
        Preconditions.checkState((boolean)(typeName instanceof ClassName), (String)"Type name %s is not a ClassName.", (Object)typeName);
        Preconditions.checkState((boolean)((ClassName)typeName).simpleName().contentEquals("Nullable"), (String)"Type name %s is not a Nullable type.", (Object)typeName);
    }

    public static XTypeName asNullableTypeName(XTypeName typeName, Nullability nullability, CompilerOptions compilerOptions) {
        return typeName;
    }

    public static XTypeName asNullableTypeName(XType type, CompilerOptions compilerOptions) {
        return type.asTypeName();
    }

    private static TypeName asNullableJavaTypeName(XType type, TypeName typeName) {
        if (typeName instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
            if (type.getTypeArguments().size() != parameterizedTypeName.typeArguments.size()) {
                throw new IllegalStateException(String.format("%s has %s type arguments but %s has %s type arguments", type, type.getTypeArguments().size(), parameterizedTypeName, parameterizedTypeName.typeArguments.size()));
            }
            TypeName[] typeArguments = new TypeName[parameterizedTypeName.typeArguments.size()];
            for (int i = 0; i < parameterizedTypeName.typeArguments.size(); ++i) {
                typeArguments[i] = NullableTypeNames.asNullableJavaTypeName(type.getTypeArguments().get(i), (TypeName)parameterizedTypeName.typeArguments.get(i));
            }
            typeName = ParameterizedTypeName.get((ClassName)parameterizedTypeName.rawType, (TypeName[])typeArguments);
        }
        return typeName.annotated((List)NullableTypeNames.getNullableAnnotations(type).stream().map(XConverters::toJavaPoet).map(AnnotationSpec::builder).map(AnnotationSpec.Builder::build).collect(DaggerStreams.toImmutableList()));
    }

    private static ImmutableSet<XClassName> getNullableAnnotations(XType type) {
        return (ImmutableSet)type.getAllAnnotations().stream().map(XAnnotations::asClassName).filter(annotation -> annotation.getSimpleName().contentEquals("Nullable")).collect(DaggerStreams.toImmutableSet());
    }

    private NullableTypeNames() {
    }
}

