/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.binding.ComponentCreatorDescriptor;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.writing.ComponentCreatorImplementation;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ModuleProxies;
import dagger.internal.codegen.xprocessing.Accessibility;
import dagger.internal.codegen.xprocessing.XCodeBlocks;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XFunSpecs;
import dagger.internal.codegen.xprocessing.XPropertySpecs;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypeSpecs;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XAnnotationSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XFunSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XParameterSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XPropertySpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeKt;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

final class ComponentCreatorImplementationFactory {
    private static final XAnnotationSpec JSPECIFY_NULLABLE = XAnnotationSpec.of(XClassName.get("org.jspecify.annotations", "Nullable"));
    private final CompilerOptions compilerOptions;
    private final ComponentImplementation componentImplementation;

    @Inject
    ComponentCreatorImplementationFactory(CompilerOptions compilerOptions, ComponentImplementation componentImplementation) {
        this.compilerOptions = compilerOptions;
        this.componentImplementation = componentImplementation;
    }

    Optional<ComponentCreatorImplementation> create() {
        if (!this.componentImplementation.componentDescriptor().hasCreator()) {
            return Optional.empty();
        }
        Optional<ComponentCreatorDescriptor> creatorDescriptor = this.componentImplementation.componentDescriptor().creatorDescriptor();
        Builder builder = creatorDescriptor.isPresent() ? new BuilderForCreatorDescriptor(creatorDescriptor.get()) : new BuilderForGeneratedRootComponentBuilder();
        return Optional.of(builder.build());
    }

    private final class BuilderForCreatorDescriptor
    extends Builder {
        final ComponentCreatorDescriptor creatorDescriptor;

        BuilderForCreatorDescriptor(ComponentCreatorDescriptor creatorDescriptor) {
            this.creatorDescriptor = creatorDescriptor;
        }

        @Override
        protected ImmutableMap<ComponentRequirement, RequirementStatus> userSettableRequirements() {
            return Maps.toMap(this.creatorDescriptor.userSettableRequirements(), this::requirementStatus);
        }

        @Override
        protected Optional<Modifier> visibility() {
            return Optional.of(Modifier.PRIVATE);
        }

        @Override
        protected void setSupertype() {
            ((Builder)this).classBuilder.superType(this.creatorDescriptor.typeElement());
        }

        @Override
        protected void addConstructor() {
            if (!ComponentCreatorImplementationFactory.this.componentImplementation.creatorComponentFields().isEmpty()) {
                super.addConstructor();
            }
        }

        @Override
        protected ImmutableSet<ComponentRequirement> setterMethods() {
            return ImmutableSet.copyOf((Collection)this.creatorDescriptor.setterMethods().keySet());
        }

        @Override
        protected ImmutableMap<ComponentRequirement, String> factoryMethodParameters() {
            return ImmutableMap.copyOf((Map)Maps.transformValues(this.creatorDescriptor.factoryParameters(), XElements::getSimpleName));
        }

        private XType creatorType() {
            return this.creatorDescriptor.typeElement().getType();
        }

        @Override
        protected XFunSpecs.Builder factoryMethodBuilder() {
            return XFunSpecs.overriding(this.creatorDescriptor.factoryMethod(), this.creatorType(), ComponentCreatorImplementationFactory.this.compilerOptions);
        }

        private RequirementStatus requirementStatus(ComponentRequirement requirement) {
            if (this.isRepeatedModule(requirement)) {
                return RequirementStatus.UNSETTABLE_REPEATED_MODULE;
            }
            return this.componentConstructorRequirements().contains((Object)requirement) ? RequirementStatus.NEEDED : RequirementStatus.UNNEEDED;
        }

        final boolean isRepeatedModule(ComponentRequirement requirement) {
            return !this.componentConstructorRequirements().contains((Object)requirement) && !this.isOwnedModule(requirement);
        }

        private boolean isOwnedModule(ComponentRequirement requirement) {
            return ComponentCreatorImplementationFactory.this.componentImplementation.graph().ownedModuleTypes().contains((Object)requirement.typeElement());
        }

        @Override
        protected XFunSpecs.Builder setterMethodBuilder(ComponentRequirement requirement) {
            XMethodElement supertypeMethod = (XMethodElement)this.creatorDescriptor.setterMethods().get((Object)requirement);
            XFunSpecs.Builder method = XFunSpecs.overriding(supertypeMethod, this.creatorType(), ComponentCreatorImplementationFactory.this.compilerOptions);
            if (!XTypeKt.isVoid(supertypeMethod.getReturnType())) {
                method.returns(ComponentCreatorImplementationFactory.this.componentImplementation.getCreatorName());
            }
            return method;
        }
    }

    private final class BuilderForGeneratedRootComponentBuilder
    extends Builder {
        private BuilderForGeneratedRootComponentBuilder() {
        }

        @Override
        protected ImmutableMap<ComponentRequirement, RequirementStatus> userSettableRequirements() {
            return Maps.toMap(this.setterMethods(), requirement -> this.componentConstructorRequirements().contains(requirement) ? RequirementStatus.NEEDED : RequirementStatus.UNNEEDED);
        }

        @Override
        protected Optional<Modifier> visibility() {
            return ComponentCreatorImplementationFactory.this.componentImplementation.componentDescriptor().typeElement().isPublic() ? Optional.of(Modifier.PUBLIC) : Optional.empty();
        }

        @Override
        protected void setSupertype() {
        }

        @Override
        protected ImmutableSet<ComponentRequirement> setterMethods() {
            return this.componentDescriptor().dependenciesAndConcreteModules();
        }

        @Override
        protected ImmutableMap<ComponentRequirement, String> factoryMethodParameters() {
            return ImmutableMap.of();
        }

        @Override
        protected XFunSpecs.Builder factoryMethodBuilder() {
            return XFunSpecs.methodBuilder("build");
        }

        @Override
        protected XFunSpecs.Builder setterMethodBuilder(ComponentRequirement requirement) {
            String name = SourceFiles.simpleVariableName(requirement.typeElement().asClassName());
            return XFunSpecs.methodBuilder(name).addModifiers(Modifier.PUBLIC).addParameter(name, requirement.type().asTypeName()).returns(ComponentCreatorImplementationFactory.this.componentImplementation.getCreatorName());
        }
    }

    private abstract class Builder {
        private final XTypeSpecs.Builder classBuilder;
        private final UniqueNameSet fieldNames;
        private ImmutableMap<ComponentRequirement, XPropertySpec> fields;

        private Builder() {
            this.classBuilder = XTypeSpecs.classBuilder(ComponentCreatorImplementationFactory.this.componentImplementation.getCreatorName());
            this.fieldNames = new UniqueNameSet();
        }

        ComponentCreatorImplementation build() {
            this.setModifiers();
            this.setSupertype();
            this.addConstructor();
            this.fields = this.addFields();
            this.addSetterMethods();
            this.addFactoryMethod();
            return ComponentCreatorImplementation.create(this.classBuilder.build(), ComponentCreatorImplementationFactory.this.componentImplementation.getCreatorName(), this.fields);
        }

        final ComponentDescriptor componentDescriptor() {
            return ComponentCreatorImplementationFactory.this.componentImplementation.componentDescriptor();
        }

        final ImmutableSet<ComponentRequirement> componentConstructorRequirements() {
            return ComponentCreatorImplementationFactory.this.componentImplementation.graph().componentRequirements();
        }

        abstract ImmutableSet<ComponentRequirement> setterMethods();

        abstract ImmutableMap<ComponentRequirement, String> factoryMethodParameters();

        abstract ImmutableMap<ComponentRequirement, RequirementStatus> userSettableRequirements();

        private Set<ComponentRequirement> neededUserSettableRequirements() {
            return Sets.intersection((Set)this.userSettableRequirements().keySet(), this.componentConstructorRequirements());
        }

        private void setModifiers() {
            this.visibility().ifPresent(xva$0 -> this.classBuilder.addModifiers((Modifier)((Object)xva$0)));
            this.classBuilder.addModifiers(Modifier.STATIC, Modifier.FINAL);
        }

        protected abstract Optional<Modifier> visibility();

        protected abstract void setSupertype();

        protected void addConstructor() {
            XFunSpecs.Builder constructor = XFunSpecs.constructorBuilder().addModifiers(Modifier.PRIVATE);
            ComponentCreatorImplementationFactory.this.componentImplementation.creatorComponentFields().forEach(field -> {
                this.fieldNames.claim(XConverters.toJavaPoet((XPropertySpec)field).name);
                this.classBuilder.addProperty((XPropertySpec)field);
                constructor.addParameter(field.getName(), field.getType());
                constructor.addStatement("this.%1N = %1N", field);
            });
            this.classBuilder.addFunction(constructor.build());
        }

        private ImmutableMap<ComponentRequirement, XPropertySpec> addFields() {
            ImmutableMap result = Maps.toMap((Iterable)Sets.intersection(this.neededUserSettableRequirements(), this.setterMethods()), requirement -> {
                XTypeName typeName = requirement.type().asTypeName();
                return XPropertySpecs.of(this.fieldNames.getUniqueName(requirement.variableName()), typeName, Modifier.PRIVATE);
            });
            this.classBuilder.addProperties((Collection<XPropertySpec>)result.values());
            return result;
        }

        private void addSetterMethods() {
            Maps.filterKeys(this.userSettableRequirements(), arg_0 -> this.setterMethods().contains(arg_0)).forEach((requirement, status) -> this.createSetterMethod((ComponentRequirement)requirement, (RequirementStatus)((Object)status)).ifPresent(this.classBuilder::addFunction));
        }

        protected abstract XFunSpecs.Builder setterMethodBuilder(ComponentRequirement var1);

        private Optional<XFunSpec> createSetterMethod(ComponentRequirement requirement, RequirementStatus status) {
            switch (status.ordinal()) {
                case 0: {
                    return Optional.of(this.normalSetterMethod(requirement));
                }
                case 1: {
                    if (!this.componentDescriptor().creatorDescriptor().isPresent() && !requirement.requiresModuleInstance()) {
                        return Optional.empty();
                    }
                    if (Accessibility.isElementAccessibleFrom((XElement)requirement.typeElement(), ComponentCreatorImplementationFactory.this.componentImplementation.name().getPackageName())) {
                        return Optional.of(this.noopSetterMethod(requirement));
                    }
                    return Optional.empty();
                }
                case 2: {
                    return Optional.of(this.repeatedModuleSetterMethod(requirement));
                }
            }
            throw new AssertionError();
        }

        private XFunSpec normalSetterMethod(ComponentRequirement requirement) {
            XFunSpecs.Builder builder = this.setterMethodBuilder(requirement);
            XParameterSpec parameter = (XParameterSpec)Iterables.getOnlyElement(builder.getParameters());
            builder.addStatement("this.%N = %L", this.fields.get((Object)requirement), requirement.nullPolicy().equals((Object)ComponentRequirement.NullPolicy.ALLOW) ? XCodeBlock.of("%N", parameter.getName()) : XCodeBlock.of("%T.checkNotNull(%N)", XTypeNames.DAGGER_PRECONDITIONS, parameter.getName()));
            return this.maybeReturnThis(builder);
        }

        private XFunSpec noopSetterMethod(ComponentRequirement requirement) {
            XFunSpecs.Builder builder = this.setterMethodBuilder(requirement);
            XParameterSpec parameter = (XParameterSpec)Iterables.getOnlyElement(builder.getParameters());
            builder.addAnnotation(XTypeNames.DEPRECATED).addJavadoc("@deprecated This module is declared, but an instance is not used in the component. This method is a no-op. For more, see https://dagger.dev/unused-modules.\n", new Object[0]).addStatement("%T.checkNotNull(%N)", XTypeNames.DAGGER_PRECONDITIONS, parameter.getName());
            return this.maybeReturnThis(builder);
        }

        private XFunSpec repeatedModuleSetterMethod(ComponentRequirement requirement) {
            return this.setterMethodBuilder(requirement).addStatement("throw %L", XCodeBlock.ofNewInstance(XTypeNames.UNSUPPORTED_OPERATION_EXCEPTION, "%T.format(%S, %T.class.getCanonicalName())", XTypeName.STRING, "%s cannot be set because it is inherited from the enclosing component", requirement.type().getTypeElement().asClassName())).build();
        }

        private XFunSpec maybeReturnThis(XFunSpecs.Builder method) {
            XFunSpec built = method.build();
            if (method.getReturnType().equals(XTypeName.UNIT_VOID)) {
                return built;
            }
            return method.addStatement("return this", new Object[0]).build();
        }

        private void addFactoryMethod() {
            this.classBuilder.addFunction(this.factoryMethod());
        }

        XFunSpec factoryMethod() {
            XFunSpecs.Builder factoryMethod = this.factoryMethodBuilder().returns(this.componentDescriptor().typeElement().asClassName()).addModifiers(Modifier.PUBLIC);
            ImmutableMap<ComponentRequirement, String> factoryMethodParameters = this.factoryMethodParameters();
            this.userSettableRequirements().keySet().forEach(requirement -> {
                if (this.fields.containsKey(requirement)) {
                    XPropertySpec field = (XPropertySpec)this.fields.get(requirement);
                    this.addNullHandlingForField((ComponentRequirement)requirement, field, factoryMethod);
                } else if (factoryMethodParameters.containsKey(requirement)) {
                    String parameterName = (String)factoryMethodParameters.get(requirement);
                    this.addNullHandlingForParameter((ComponentRequirement)requirement, parameterName, factoryMethod);
                }
            });
            factoryMethod.addStatement("return %L", XCodeBlock.ofNewInstance(ComponentCreatorImplementationFactory.this.componentImplementation.name(), "%L", this.componentConstructorArgs(factoryMethodParameters)));
            return factoryMethod.build();
        }

        private void addNullHandlingForField(ComponentRequirement requirement, XPropertySpec field, XFunSpecs.Builder factoryMethod) {
            switch (requirement.nullPolicy()) {
                case NEW: {
                    Preconditions.checkState((boolean)requirement.kind().isModule());
                    factoryMethod.beginControlFlow("if (%N == null)", field).addStatement("this.%N = %L", field, this.newModuleInstance(requirement)).endControlFlow();
                    break;
                }
                case THROW: {
                    factoryMethod.addStatement("%T.checkBuilderRequirement(%N, %L)", XTypeNames.DAGGER_PRECONDITIONS, field, XCodeBlocks.ofJavaClassLiteral(field.getType().getRawTypeName()));
                    break;
                }
            }
        }

        private void addNullHandlingForParameter(ComponentRequirement requirement, String parameter, XFunSpecs.Builder factoryMethod) {
            if (!requirement.nullPolicy().equals((Object)ComponentRequirement.NullPolicy.ALLOW)) {
                factoryMethod.addStatement("%T.checkNotNull(%N)", XTypeNames.DAGGER_PRECONDITIONS, parameter);
            }
        }

        protected abstract XFunSpecs.Builder factoryMethodBuilder();

        private XCodeBlock componentConstructorArgs(ImmutableMap<ComponentRequirement, String> factoryMethodParameters) {
            return Stream.concat(ComponentCreatorImplementationFactory.this.componentImplementation.creatorComponentFields().stream().map(field -> XCodeBlock.of("%N", field)), this.componentConstructorRequirements().stream().map(requirement -> {
                if (this.fields.containsKey(requirement)) {
                    return XCodeBlock.of("%N", this.fields.get(requirement));
                }
                if (factoryMethodParameters.containsKey(requirement)) {
                    return XCodeBlock.of("%N", factoryMethodParameters.get(requirement));
                }
                return this.newModuleInstance((ComponentRequirement)requirement);
            })).collect(XCodeBlocks.toParametersCodeBlock());
        }

        private XCodeBlock newModuleInstance(ComponentRequirement requirement) {
            Preconditions.checkArgument((boolean)requirement.kind().isModule());
            return ModuleProxies.newModuleInstance(requirement.typeElement(), ComponentCreatorImplementationFactory.this.componentImplementation.getCreatorName());
        }
    }

    static enum RequirementStatus {
        NEEDED,
        UNNEEDED,
        UNSETTABLE_REPEATED_MODULE;

    }
}

