/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.base.FrameworkTypes;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.base.RequestKinds;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.validation.MembersInjectionValidator;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFieldElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XVariableElement;
import java.util.Optional;
import javax.inject.Inject;

final class DependencyRequestValidator {
    private final XProcessingEnv processingEnv;
    private final MembersInjectionValidator membersInjectionValidator;
    private final InjectionAnnotations injectionAnnotations;
    private final KotlinMetadataUtil metadataUtil;

    @Inject
    DependencyRequestValidator(XProcessingEnv processingEnv, MembersInjectionValidator membersInjectionValidator, InjectionAnnotations injectionAnnotations, KotlinMetadataUtil metadataUtil) {
        this.processingEnv = processingEnv;
        this.membersInjectionValidator = membersInjectionValidator;
        this.injectionAnnotations = injectionAnnotations;
        this.metadataUtil = metadataUtil;
    }

    void validateDependencyRequest(ValidationReport.Builder report, XElement requestElement, XType requestType) {
        if (requestElement.hasAnnotation(XTypeNames.ASSISTED)) {
            return;
        }
        if (this.missingQualifierMetadata(requestElement)) {
            report.addError("Unable to read annotations on an injected Kotlin property. The Dagger compiler must also be applied to any project containing @Inject properties.", requestElement);
            return;
        }
        new Validator(report, requestElement, requestType).validate();
    }

    private boolean missingQualifierMetadata(XElement requestElement) {
        XFieldElement fieldElement;
        if (XElementKt.isField(requestElement) && !(fieldElement = XElements.asField(requestElement)).isStatic() && XElementKt.isTypeElement(fieldElement.getEnclosingElement()) && this.metadataUtil.hasMetadata(fieldElement) && this.metadataUtil.isMissingSyntheticPropertyForAnnotations(fieldElement)) {
            Optional<XTypeElement> membersInjector = Optional.ofNullable(this.processingEnv.findTypeElement(SourceFiles.membersInjectorNameForType(XElements.asTypeElement(fieldElement.getEnclosingElement()))));
            return !membersInjector.isPresent();
        }
        return false;
    }

    void checkNotProducer(ValidationReport.Builder report, XVariableElement requestElement) {
        XType requestType = requestElement.getType();
        if (FrameworkTypes.isProducerType(requestType)) {
            report.addError(String.format("%s may only be injected in @Produces methods", XElements.getSimpleName(requestType.getTypeElement())), requestElement);
        }
    }

    private final class Validator {
        private final ValidationReport.Builder report;
        private final XElement requestElement;
        private final XType requestType;
        private final ImmutableSet<XAnnotation> qualifiers;

        Validator(ValidationReport.Builder report, XElement requestElement, XType requestType) {
            this.report = report;
            this.requestElement = requestElement;
            this.requestType = requestType;
            this.qualifiers = DependencyRequestValidator.this.injectionAnnotations.getQualifiers(requestElement);
        }

        void validate() {
            this.checkQualifiers();
            this.checkType();
        }

        private void checkQualifiers() {
            if (this.qualifiers.size() > 1) {
                for (XAnnotation qualifier : this.qualifiers) {
                    this.report.addError("A single dependency request may not use more than one @Qualifier", this.requestElement, qualifier);
                }
            }
        }

        private void checkType() {
            MapType mapType;
            if (FrameworkTypes.isFrameworkType(this.requestType) && XTypes.isRawParameterizedType(this.requestType)) {
                this.report.addError("Dagger does not support injecting raw type: " + XTypes.toStableString(this.requestType), this.requestElement);
                return;
            }
            if (FrameworkTypes.isDisallowedType(this.requestType)) {
                this.report.addError("Dagger disallows injecting the type: " + XTypes.toStableString(this.requestType), this.requestElement);
                return;
            }
            XType keyType = RequestKinds.extractKeyType(this.requestType);
            if (this.qualifiers.isEmpty() && XTypes.isDeclared(keyType)) {
                RequestKind requestKind;
                XTypeElement typeElement = keyType.getTypeElement();
                if (AssistedInjectionAnnotations.isAssistedInjectionType(typeElement)) {
                    this.report.addError("Dagger does not support injecting @AssistedInject type, " + XTypes.toStableString(this.requestType) + ". Did you mean to inject its assisted factory type instead?", this.requestElement);
                }
                if ((requestKind = RequestKinds.getRequestKind(this.requestType)) != RequestKind.INSTANCE && requestKind != RequestKind.PROVIDER && AssistedInjectionAnnotations.isAssistedFactoryType(typeElement)) {
                    this.report.addError("Dagger does not support injecting Lazy<T>, Producer<T>, or Produced<T> when T is an @AssistedFactory-annotated type such as " + XTypes.toStableString(keyType), this.requestElement);
                }
            }
            if (XTypes.isWildcard(keyType)) {
                this.report.addError("Dagger does not support injecting Provider<T>, Lazy<T>, Producer<T>, or Produced<T> when T is a wildcard type such as " + XTypes.toStableString(keyType), this.requestElement);
            }
            if (XTypes.isTypeOf(keyType, XTypeNames.MEMBERS_INJECTOR)) {
                if (keyType.getTypeArguments().isEmpty()) {
                    this.report.addError("Cannot inject a raw MembersInjector", this.requestElement);
                } else {
                    this.report.addSubreport(DependencyRequestValidator.this.membersInjectionValidator.validateMembersInjectionRequest(this.requestElement, keyType.getTypeArguments().get(0)));
                }
            }
            if (MapType.isMap(keyType) && !(mapType = MapType.from(keyType)).isRawType()) {
                XType valueType = mapType.valueType();
                if (FrameworkTypes.isMapValueFrameworkType(valueType) && XTypes.isRawParameterizedType(valueType)) {
                    this.report.addError("Dagger does not support injecting maps of raw framework types: " + XTypes.toStableString(this.requestType), this.requestElement);
                }
                if (FrameworkTypes.isDisallowedType(valueType)) {
                    this.report.addError("Dagger does not support injecting maps of disallowed types: " + XTypes.toStableString(this.requestType), this.requestElement);
                }
            }
        }
    }
}

