/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import dagger.internal.codegen.base.ModuleKind;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.EnumSet;
import java.util.Optional;

public enum ComponentKind {
    COMPONENT(XTypeNames.COMPONENT),
    SUBCOMPONENT(XTypeNames.SUBCOMPONENT),
    PRODUCTION_COMPONENT(XTypeNames.PRODUCTION_COMPONENT),
    PRODUCTION_SUBCOMPONENT(XTypeNames.PRODUCTION_SUBCOMPONENT),
    MODULE(XTypeNames.MODULE),
    PRODUCER_MODULE(XTypeNames.PRODUCER_MODULE);

    private static final ImmutableSet<ComponentKind> PRODUCER_KINDS;
    private final XClassName annotation;

    public static ImmutableSet<XClassName> annotationsFor(Iterable<ComponentKind> kinds) {
        return (ImmutableSet)DaggerStreams.stream(kinds).map(ComponentKind::annotation).collect(DaggerStreams.toImmutableSet());
    }

    public static ImmutableSet<ComponentKind> getComponentKinds(XTypeElement element) {
        return (ImmutableSet)DaggerStreams.valuesOf(ComponentKind.class).filter(kind -> element.hasAnnotation(kind.annotation())).collect(DaggerStreams.toImmutableSet());
    }

    public static Optional<ComponentKind> forAnnotatedElement(XTypeElement element) {
        ImmutableSet<ComponentKind> kinds = ComponentKind.getComponentKinds(element);
        if (kinds.size() > 1) {
            throw new IllegalArgumentException(element + " cannot be annotated with more than one of " + ComponentKind.annotationsFor(kinds));
        }
        return kinds.stream().findAny();
    }

    private ComponentKind(XClassName annotation) {
        this.annotation = annotation;
    }

    public XClassName annotation() {
        return this.annotation;
    }

    public ImmutableSet<ModuleKind> legalModuleKinds() {
        return this.isProducer() ? Sets.immutableEnumSet(EnumSet.allOf(ModuleKind.class)) : Sets.immutableEnumSet((Enum)ModuleKind.MODULE, (Enum[])new ModuleKind[0]);
    }

    public ImmutableSet<ComponentKind> legalSubcomponentKinds() {
        return this.isProducer() ? Sets.immutableEnumSet((Enum)PRODUCTION_SUBCOMPONENT, (Enum[])new ComponentKind[0]) : Sets.immutableEnumSet((Enum)SUBCOMPONENT, (Enum[])new ComponentKind[]{PRODUCTION_SUBCOMPONENT});
    }

    public boolean isProducer() {
        return PRODUCER_KINDS.contains((Object)this);
    }

    static {
        PRODUCER_KINDS = ImmutableSet.of((Object)((Object)PRODUCTION_COMPONENT), (Object)((Object)PRODUCTION_SUBCOMPONENT), (Object)((Object)PRODUCER_MODULE));
    }
}

