/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.kotlinpoet.KModifier;
import dagger.internal.codegen.xprocessing.Nullability;
import dagger.internal.codegen.xprocessing.XCodeBlocks;
import dagger.internal.codegen.xprocessing.XParameterSpecs;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.VisibilityModifier;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XAnnotationSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XFunSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XParameterSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.Modifier;

public final class XFunSpecs {
    public static Builder overriding(XMethodElement method, XType owner) {
        Builder builder = XFunSpecs.overridingWithoutParameters(method, owner);
        XMethodType methodType = method.asMemberOf(owner);
        for (int i = 0; i < methodType.getParameterTypes().size(); ++i) {
            XExecutableParameterElement parameter = (XExecutableParameterElement)method.getParameters().get(i);
            XType parameterType = (XType)methodType.getParameterTypes().get(i);
            builder.addParameter(XParameterSpecs.parameterSpecOf(parameter, parameterType));
        }
        return builder;
    }

    public static Builder overridingWithoutParameters(XMethodElement method, XType owner) {
        XMethodType methodType = method.asMemberOf(owner);
        Nullability nullability = Nullability.of((XElement)method);
        TypeName returnType = Nullability.getTypeNameWithNullableAnnotations(methodType.getReturnType());
        Builder builder = XFunSpecs.methodBuilder(method.getJvmName()).addAnnotation(Override.class).addAnnotationNames((Collection<XClassName>)nullability.nonTypeUseNullableAnnotations()).addTypeVariables(methodType.getTypeVariables()).varargs(method.isVarArgs()).returns(returnType);
        if (method.isPublic()) {
            builder.addModifiers(Modifier.PUBLIC);
        } else if (method.isProtected()) {
            builder.addModifiers(Modifier.PROTECTED);
        }
        return builder;
    }

    public static Builder methodBuilder(String name) {
        return new Builder(Builder.Kind.FUNCTION).name(name);
    }

    public static Builder constructorBuilder() {
        return new Builder(Builder.Kind.CONSTRUCTOR);
    }

    private XFunSpecs() {
    }

    public static class Builder {
        private final Kind kind;
        private final XCodeBlock.Builder bodyBuilder = XCodeBlock.builder();
        private String name;
        private VisibilityModifier visibility = null;
        private boolean isStatic = false;
        private boolean isAbstract = false;
        private boolean isOpen = false;
        private boolean isOverride = false;
        private boolean isVarArgs = false;
        private final List<XCodeBlock> javadocs = new ArrayList<XCodeBlock>();
        private final List<XParameterSpec> parameters = new ArrayList<XParameterSpec>();
        private Object returnType = null;
        private final List<Object> annotations = new ArrayList<Object>();
        private final List<Object> typeVariableNames = new ArrayList<Object>();
        private final List<Object> exceptionNames = new ArrayList<Object>();

        Builder(Kind kind) {
            this.kind = kind;
        }

        public ImmutableList<XParameterSpec> getParameters() {
            return ImmutableList.copyOf(this.parameters);
        }

        @CanIgnoreReturnValue
        private Builder name(String name) {
            Preconditions.checkState((this.kind != Kind.CONSTRUCTOR ? 1 : 0) != 0);
            this.name = name;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder visibility(VisibilityModifier visibility) {
            this.visibility = visibility;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder isStatic(boolean isStatic) {
            Preconditions.checkState((this.kind != Kind.CONSTRUCTOR ? 1 : 0) != 0);
            this.isStatic = isStatic;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder isAbstract(boolean isAbstract) {
            Preconditions.checkState((this.kind != Kind.CONSTRUCTOR ? 1 : 0) != 0);
            this.isAbstract = isAbstract;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder isOpen(boolean isOpen) {
            Preconditions.checkState((this.kind != Kind.CONSTRUCTOR ? 1 : 0) != 0);
            this.isOpen = isOpen;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder isOverride(boolean isOverride) {
            Preconditions.checkState((this.kind != Kind.CONSTRUCTOR ? 1 : 0) != 0);
            this.isOverride = isOverride;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addJavadoc(String format, Object ... args) {
            this.javadocs.add(XCodeBlock.of((String)format, (Object[])args));
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addModifiers(Collection<Modifier> modifiers) {
            return this.addModifiers(modifiers.toArray(new Modifier[0]));
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addModifiers(Modifier ... modifiers) {
            block8: for (Modifier modifier : modifiers) {
                switch (modifier) {
                    case PUBLIC: {
                        this.visibility(VisibilityModifier.PUBLIC);
                        continue block8;
                    }
                    case PRIVATE: {
                        this.visibility(VisibilityModifier.PRIVATE);
                        continue block8;
                    }
                    case PROTECTED: {
                        this.visibility(VisibilityModifier.PROTECTED);
                        continue block8;
                    }
                    case ABSTRACT: {
                        this.isOpen(true);
                        this.isAbstract(true);
                        continue block8;
                    }
                    case STATIC: {
                        this.isStatic(true);
                        continue block8;
                    }
                    case FINAL: {
                        this.isOpen(false);
                        continue block8;
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected modifier: " + (Object)((Object)modifier)));
                    }
                }
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addTypeVariables(Collection<? extends XType> typeVariables) {
            typeVariables.forEach(this::addTypeVariable);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addTypeVariableNames(Collection<XTypeName> typeVariableNames) {
            typeVariableNames.forEach(this::addTypeVariable);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addJavaTypeVariableNames(Collection<TypeVariableName> typeVariableNames) {
            typeVariableNames.forEach(this::addTypeVariable);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addTypeVariable(XType type) {
            return this.addTypeVariable(type.asTypeName());
        }

        @CanIgnoreReturnValue
        public Builder addTypeVariable(XTypeName typeName) {
            this.typeVariableNames.add(typeName);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addTypeVariable(TypeVariableName typeVariableName) {
            this.typeVariableNames.add(typeVariableName);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAnnotations(Collection<XAnnotationSpec> annotations) {
            annotations.forEach(this::addAnnotation);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addJavaAnnotations(Collection<AnnotationSpec> annotations) {
            annotations.forEach(this::addAnnotation);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAnnotationNames(Collection<XClassName> annotationNames) {
            annotationNames.forEach(this::addAnnotation);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAnnotation(XAnnotationSpec annotation) {
            this.annotations.add(annotation);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAnnotation(XClassName annotationName) {
            return this.addAnnotation(XAnnotationSpec.of((XClassName)annotationName));
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addAnnotation(Class<?> clazz) {
            if (clazz.equals(Override.class)) {
                this.isOverride(true);
            }
            this.addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get(clazz)).build());
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addAnnotation(AnnotationSpec annotation) {
            this.annotations.add(annotation);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addParameters(Collection<XParameterSpec> parameters) {
            parameters.forEach(this::addParameter);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addParameter(XParameterSpec parameter) {
            this.parameters.add(parameter);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addParameter(XName name, XTypeName typeName) {
            return this.addParameter(XParameterSpecs.of(XConverters.toJavaPoet((XName)name), typeName));
        }

        @CanIgnoreReturnValue
        public Builder addParameter(String name, XTypeName typeName) {
            return this.addParameter(XParameterSpecs.of(name, typeName));
        }

        @CanIgnoreReturnValue
        public Builder addExceptions(Collection<? extends XType> exceptions) {
            exceptions.forEach(this::addException);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addExceptionNames(Collection<XTypeName> exceptionNames) {
            exceptionNames.forEach(this::addException);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addJavaExceptionNames(Collection<TypeName> exceptionNames) {
            exceptionNames.forEach(this::addException);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addException(XType exception) {
            return this.addException(exception.asTypeName());
        }

        @CanIgnoreReturnValue
        public Builder addException(XTypeName exceptionName) {
            this.exceptionNames.add(exceptionName);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addException(TypeName exceptionName) {
            this.exceptionNames.add(exceptionName);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addStatement(String format, Object ... args) {
            this.bodyBuilder.addStatement(format, args);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addStatement(XCodeBlock codeBlock) {
            this.bodyBuilder.addStatement("%L", new Object[]{codeBlock});
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addCode(String format, Object ... args) {
            this.bodyBuilder.add(format, args);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addCode(XCodeBlock codeBlock) {
            this.bodyBuilder.add(codeBlock);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder beginControlFlow(String controlFlow, Object ... args) {
            this.bodyBuilder.beginControlFlow(controlFlow, args);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder endControlFlow() {
            this.bodyBuilder.endControlFlow();
            return this;
        }

        @CanIgnoreReturnValue
        public Builder varargs(boolean isVarArgs) {
            this.isVarArgs = isVarArgs;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder returns(XTypeName returnType) {
            Preconditions.checkState((this.kind != Kind.CONSTRUCTOR ? 1 : 0) != 0);
            this.returnType = returnType;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder returns(TypeName returnType) {
            Preconditions.checkState((this.kind != Kind.CONSTRUCTOR ? 1 : 0) != 0);
            this.returnType = returnType;
            return this;
        }

        public XFunSpec build() {
            XFunSpec.Builder builder;
            VisibilityModifier initialVisibility = this.visibility == null ? VisibilityModifier.PRIVATE : this.visibility;
            switch (this.kind.ordinal()) {
                case 0: {
                    builder = XFunSpec.builder((String)this.name, (VisibilityModifier)initialVisibility, (boolean)this.isOpen, (boolean)this.isOverride, (boolean)false);
                    AnnotationSpec overrideAnnotation = AnnotationSpec.builder(Override.class).build();
                    if (!this.annotations.contains(overrideAnnotation)) break;
                    XConverters.toJavaPoet((XFunSpec.Builder)builder).annotations.remove(overrideAnnotation);
                    break;
                }
                case 1: {
                    Preconditions.checkState((this.name == null ? 1 : 0) != 0);
                    Preconditions.checkState((this.returnType == null ? 1 : 0) != 0);
                    builder = XFunSpec.constructorBuilder((VisibilityModifier)initialVisibility, (boolean)false);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (this.visibility == null) {
                XConverters.toJavaPoet((XFunSpec.Builder)builder).modifiers.remove((Object)Modifier.PRIVATE);
                XConverters.toKotlinPoet((XFunSpec.Builder)builder).getModifiers().remove(KModifier.PRIVATE);
            }
            for (XCodeBlock javadoc : this.javadocs) {
                XConverters.toJavaPoet((XFunSpec.Builder)builder).addJavadoc(XConverters.toJavaPoet((XCodeBlock)javadoc));
            }
            XCodeBlock body = this.bodyBuilder.build();
            if (!XCodeBlocks.isEmpty(body)) {
                builder.addCode(body);
            }
            if (this.isAbstract) {
                builder.addAbstractModifier();
            }
            if (this.isStatic) {
                XConverters.toJavaPoet((XFunSpec.Builder)builder).addModifiers(new Modifier[]{Modifier.STATIC});
            }
            if (this.isVarArgs) {
                XConverters.toJavaPoet((XFunSpec.Builder)builder).varargs(this.isVarArgs);
            }
            if (this.returnType != null) {
                if (this.returnType instanceof XTypeName) {
                    builder.returns((XTypeName)this.returnType);
                } else if (this.returnType instanceof TypeName) {
                    XConverters.toJavaPoet((XFunSpec.Builder)builder).returns((TypeName)this.returnType);
                } else {
                    throw new AssertionError((Object)("Unexpected returnType class: " + this.returnType.getClass()));
                }
            }
            builder.addParameters(this.parameters);
            for (Object typeVariableName : this.typeVariableNames) {
                if (typeVariableName instanceof XTypeName) {
                    builder.addTypeVariable((XTypeName)typeVariableName);
                    continue;
                }
                if (typeVariableName instanceof TypeVariableName) {
                    XConverters.toJavaPoet((XFunSpec.Builder)builder).addTypeVariable((TypeVariableName)typeVariableName);
                    continue;
                }
                throw new AssertionError((Object)("Unexpected typeVariableName class: " + typeVariableName.getClass()));
            }
            for (Object annotation : this.annotations) {
                if (annotation instanceof XAnnotationSpec) {
                    builder.addAnnotation((XAnnotationSpec)annotation);
                    continue;
                }
                if (annotation instanceof AnnotationSpec) {
                    XConverters.toJavaPoet((XFunSpec.Builder)builder).addAnnotation((AnnotationSpec)annotation);
                    continue;
                }
                throw new AssertionError((Object)("Unexpected annotation class: " + annotation.getClass()));
            }
            for (Object exceptionName : this.exceptionNames) {
                if (exceptionName instanceof XTypeName) {
                    XConverters.toJavaPoet((XFunSpec.Builder)builder).addException(XConverters.toJavaPoet((XTypeName)((XTypeName)exceptionName)));
                    continue;
                }
                if (exceptionName instanceof TypeName) {
                    XConverters.toJavaPoet((XFunSpec.Builder)builder).addException((TypeName)exceptionName);
                    continue;
                }
                throw new AssertionError((Object)("Unexpected exceptionName class: " + exceptionName.getClass()));
            }
            return builder.build();
        }

        private static enum Kind {
            FUNCTION,
            CONSTRUCTOR;

        }
    }
}

