/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.FrameworkFieldInitializer;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.xprocessing.XAnnotationSpecs;
import dagger.internal.codegen.xprocessing.XCodeBlocks;
import dagger.internal.codegen.xprocessing.XFunSpecs;
import dagger.internal.codegen.xprocessing.XProcessingEnvs;
import dagger.internal.codegen.xprocessing.XPropertySpecs;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypeSpecs;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XFunSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XPropertySpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;

final class SwitchingProviders {
    private static final int MAX_CASES_PER_SWITCH = 100;
    private static final long MAX_CASES_PER_CLASS = 10000L;
    private static final XTypeName typeVariable = XTypeNames.getTypeVariableName("T");
    private final Map<Key, SwitchingProviderBuilder> switchingProviderBuilders = new LinkedHashMap<Key, SwitchingProviderBuilder>();
    private final ComponentImplementation.ShardImplementation shardImplementation;
    private final XProcessingEnv processingEnv;

    SwitchingProviders(ComponentImplementation.ShardImplementation shardImplementation, XProcessingEnv processingEnv) {
        this.shardImplementation = (ComponentImplementation.ShardImplementation)Preconditions.checkNotNull((Object)shardImplementation);
        this.processingEnv = (XProcessingEnv)Preconditions.checkNotNull((Object)processingEnv);
    }

    FrameworkFieldInitializer.FrameworkInstanceCreationExpression newFrameworkInstanceCreationExpression(final ContributionBinding binding, final RequestRepresentation unscopedInstanceRequestRepresentation) {
        return new FrameworkFieldInitializer.FrameworkInstanceCreationExpression(){

            @Override
            public XCodeBlock creationExpression() {
                return SwitchingProviders.this.switchingProviderBuilders.computeIfAbsent(binding.key(), key -> SwitchingProviders.this.getSwitchingProviderBuilder()).getNewInstanceCodeBlock(binding, unscopedInstanceRequestRepresentation);
            }
        };
    }

    private SwitchingProviderBuilder getSwitchingProviderBuilder() {
        if ((long)this.switchingProviderBuilders.size() % 10000L == 0L) {
            String name = this.shardImplementation.getUniqueClassName("SwitchingProvider");
            SwitchingProviderBuilder switchingProviderBuilder = new SwitchingProviderBuilder(this.shardImplementation.name().nestedClass(name));
            this.shardImplementation.addTypeSupplier((Supplier<XTypeSpec>)((Supplier)() -> switchingProviderBuilder.build()));
            return switchingProviderBuilder;
        }
        return (SwitchingProviderBuilder)Iterables.getLast(this.switchingProviderBuilders.values());
    }

    private final class SwitchingProviderBuilder {
        private final Map<Integer, XCodeBlock> switchCases = new TreeMap<Integer, XCodeBlock>();
        private final Map<Key, Integer> switchIds = new HashMap<Key, Integer>();
        private final XClassName switchingProviderType;

        SwitchingProviderBuilder(XClassName switchingProviderType) {
            this.switchingProviderType = (XClassName)Preconditions.checkNotNull((Object)switchingProviderType);
        }

        private XCodeBlock getNewInstanceCodeBlock(ContributionBinding binding, RequestRepresentation unscopedInstanceRequestRepresentation) {
            Key key = binding.key();
            if (!this.switchIds.containsKey(key)) {
                int switchId = this.switchIds.size();
                this.switchIds.put(key, switchId);
                this.switchCases.put(switchId, this.createSwitchCaseCodeBlock(key, unscopedInstanceRequestRepresentation));
            }
            return XCodeBlock.of((String)"new %T<%L>(%L, %L)", (Object[])new Object[]{this.switchingProviderType, binding.scope().isPresent() || binding.kind().equals((Object)BindingKind.ASSISTED_FACTORY) || XProcessingEnvs.isPreJava8SourceVersion(SwitchingProviders.this.processingEnv) ? XCodeBlock.of((String)"%T", (Object[])new Object[]{SwitchingProviders.this.shardImplementation.accessibleTypeName(binding.contributedType())}) : "", SwitchingProviders.this.shardImplementation.componentFieldsByImplementation().values().stream().map(field -> XCodeBlock.of((String)"%N", (Object[])new Object[]{field})).collect(XCodeBlocks.toParametersCodeBlock()), this.switchIds.get(key)});
        }

        private XCodeBlock createSwitchCaseCodeBlock(Key key, RequestRepresentation unscopedInstanceRequestRepresentation) {
            XCodeBlock instanceCodeBlock = unscopedInstanceRequestRepresentation.getDependencyExpression(this.switchingProviderType).box().codeBlock();
            return XCodeBlock.builder().add("case %L: // %L\n", new Object[]{this.switchIds.get(key), key}).addStatement("return (%T) %L", new Object[]{typeVariable, instanceCodeBlock}).build();
        }

        private XTypeSpec build() {
            XTypeSpecs.Builder builder = XTypeSpecs.classBuilder(this.switchingProviderType).addModifiers(Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC).addTypeVariable(typeVariable).addSuperinterface(XTypeNames.daggerProviderOf(typeVariable)).addFunctions((Collection<XFunSpec>)this.getMethods());
            XFunSpecs.Builder constructor = XFunSpecs.constructorBuilder();
            Stream.concat(SwitchingProviders.this.shardImplementation.componentFieldsByImplementation().values().stream(), Stream.of(XPropertySpecs.of("id", XTypeName.PRIMITIVE_INT, Modifier.PRIVATE, Modifier.FINAL))).forEach(field -> {
                builder.addProperty((XPropertySpec)field);
                constructor.addParameter(field.getName(), field.getType());
                constructor.addStatement("this.%1N = %1N", field);
            });
            return builder.addFunction(constructor.build()).build();
        }

        private ImmutableList<XFunSpec> getMethods() {
            ImmutableList<XCodeBlock> switchCodeBlockPartitions = this.switchCodeBlockPartitions();
            if (switchCodeBlockPartitions.size() == 1) {
                return ImmutableList.of((Object)XFunSpecs.methodBuilder("get").addModifiers(Modifier.PUBLIC).addAnnotation(XAnnotationSpecs.suppressWarnings(XAnnotationSpecs.Suppression.UNCHECKED, new XAnnotationSpecs.Suppression[0])).addAnnotation(Override.class).returns(typeVariable).addCode((XCodeBlock)Iterables.getOnlyElement(switchCodeBlockPartitions)).build());
            }
            XFunSpecs.Builder routerMethod = XFunSpecs.methodBuilder("get").addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).returns(typeVariable).beginControlFlow("switch (id / %L)", 100);
            ImmutableList.Builder getMethods = ImmutableList.builder();
            for (int i = 0; i < switchCodeBlockPartitions.size(); ++i) {
                XFunSpec method = XFunSpecs.methodBuilder("get" + i).addModifiers(Modifier.PRIVATE).addAnnotation(XAnnotationSpecs.suppressWarnings(XAnnotationSpecs.Suppression.UNCHECKED, new XAnnotationSpecs.Suppression[0])).returns(typeVariable).addCode((XCodeBlock)switchCodeBlockPartitions.get(i)).build();
                getMethods.add((Object)method);
                routerMethod.addStatement("case %L: return %N()", i, method);
            }
            routerMethod.addStatement("default: throw %L", XCodeBlock.ofNewInstance((XTypeName)XTypeNames.ASSERTION_ERROR, (String)"id", (Object[])new Object[0])).endControlFlow();
            return getMethods.add((Object)routerMethod.build()).build();
        }

        private ImmutableList<XCodeBlock> switchCodeBlockPartitions() {
            return (ImmutableList)Lists.partition((List)ImmutableList.copyOf(this.switchCases.values()), (int)100).stream().map(partitionCases -> XCodeBlock.builder().beginControlFlow("switch (id)", new Object[0]).add(XCodeBlocks.concat(partitionCases)).addStatement("default: throw %L", new Object[]{XCodeBlock.ofNewInstance((XTypeName)XTypeNames.ASSERTION_ERROR, (String)"id", (Object[])new Object[0])}).endControlFlow().build()).collect(DaggerStreams.toImmutableList());
        }
    }
}

