/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.model.DaggerAnnotation;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.writing.GwtCompatibility;
import dagger.internal.codegen.writing.InjectionMethods;
import dagger.internal.codegen.xprocessing.Nullability;
import dagger.internal.codegen.xprocessing.XAnnotationSpecs;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XCodeBlocks;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XFunSpecs;
import dagger.internal.codegen.xprocessing.XParameterSpecs;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypeSpecs;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.VisibilityModifier;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XAnnotationSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XFunSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XParameterSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XPropertySpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFieldElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XVariableElement;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

public final class MembersInjectorGenerator
extends SourceFileGenerator<MembersInjectionBinding> {
    private final SourceFiles sourceFiles;

    @Inject
    MembersInjectorGenerator(XFiler filer, SourceFiles sourceFiles, XProcessingEnv processingEnv) {
        super(filer, processingEnv);
        this.sourceFiles = sourceFiles;
    }

    @Override
    public XElement originatingElement(MembersInjectionBinding binding) {
        return binding.membersInjectedType();
    }

    @Override
    public ImmutableList<XTypeSpec> topLevelTypes(MembersInjectionBinding binding) {
        Preconditions.checkState((!binding.unresolved().isPresent() ? 1 : 0) != 0, (String)"tried to generate a MembersInjector for a binding of a resolved generic type: %s", (Object)binding);
        XClassName generatedTypeName = SourceFiles.membersInjectorNameForType(binding.membersInjectedType());
        ImmutableList<XTypeName> typeParameters = SourceFiles.bindingTypeElementTypeVariableNames(binding);
        ImmutableMap<DependencyRequest, XPropertySpec> frameworkFields = MembersInjectorGenerator.frameworkFields(binding);
        XTypeSpecs.Builder injectorTypeBuilder = XTypeSpecs.classBuilder(generatedTypeName).addModifiers(Modifier.PUBLIC, Modifier.FINAL).addTypeVariableNames((Collection<XTypeName>)typeParameters).addAnnotation(this.qualifierMetadataAnnotation(binding)).addSuperinterface(XTypeNames.membersInjectorOf(binding.key().type().xprocessing().asTypeName())).addProperties((Collection<XPropertySpec>)frameworkFields.values()).addFunction(this.constructor(frameworkFields)).addFunction(this.createMethod(binding, frameworkFields)).addFunction(this.injectMembersMethod(binding, frameworkFields)).addFunctions((Collection)binding.injectionSites().stream().filter(site -> site.enclosingTypeElement().equals((Object)binding.membersInjectedType())).map(MembersInjectorGenerator::membersInjectionMethod).collect(DaggerStreams.toImmutableList()));
        GwtCompatibility.gwtIncompatibleAnnotation(binding).ifPresent(injectorTypeBuilder::addAnnotation);
        return ImmutableList.of((Object)injectorTypeBuilder.build());
    }

    private static XFunSpec membersInjectionMethod(MembersInjectionBinding.InjectionSite injectionSite) {
        String methodName = SourceFiles.membersInjectorMethodName(injectionSite);
        switch (injectionSite.kind()) {
            case METHOD: {
                return MembersInjectorGenerator.methodInjectionMethod(XElements.asMethod(injectionSite.element()), methodName);
            }
            case FIELD: {
                Optional<XAnnotation> qualifier = ((DependencyRequest)Iterables.getOnlyElement(injectionSite.dependencies())).key().qualifier().map(DaggerAnnotation::xprocessing);
                return MembersInjectorGenerator.fieldInjectionMethod(XElements.asField(injectionSite.element()), methodName, qualifier);
            }
        }
        throw new AssertionError(injectionSite);
    }

    private static XFunSpec methodInjectionMethod(XMethodElement method, String methodName) {
        XTypeElement enclosingType = XElements.asTypeElement((XElement)method.getEnclosingElement());
        XFunSpecs.Builder builder = XFunSpecs.methodBuilder(methodName).addModifiers(Modifier.PUBLIC, Modifier.STATIC).varargs(method.isVarArgs()).addTypeVariableNames((Collection<XTypeName>)XTypeElements.typeVariableNames(enclosingType)).addExceptions(method.getThrownTypes());
        UniqueNameSet parameterNameSet = new UniqueNameSet();
        XCodeBlock instance = MembersInjectorGenerator.copyInstance(builder, parameterNameSet, enclosingType.getType());
        XCodeBlock arguments = InjectionMethods.copyParameters(builder, parameterNameSet, method.getParameters());
        return builder.addStatement("%L.%N(%L)", instance, method.getJvmName(), arguments).build();
    }

    private static XFunSpec fieldInjectionMethod(XFieldElement field, String methodName, Optional<XAnnotation> qualifier) {
        XTypeElement enclosingType = XElements.asTypeElement((XElement)field.getEnclosingElement());
        XFunSpecs.Builder builder = XFunSpecs.methodBuilder(methodName).addModifiers(Modifier.PUBLIC, Modifier.STATIC).addAnnotation(XAnnotationSpec.builder((XClassName)XTypeNames.INJECTED_FIELD_SIGNATURE).addMember("value", "%S", new Object[]{SourceFiles.memberInjectedFieldSignatureForVariable(field)}).build()).addTypeVariableNames((Collection<XTypeName>)XTypeElements.typeVariableNames(enclosingType));
        qualifier.map(XAnnotations::getAnnotationSpec).ifPresent(builder::addAnnotation);
        UniqueNameSet parameterNameSet = new UniqueNameSet();
        XCodeBlock instance = MembersInjectorGenerator.copyInstance(builder, parameterNameSet, enclosingType.getType());
        XCodeBlock argument = InjectionMethods.copyParameters(builder, parameterNameSet, (List<? extends XVariableElement>)ImmutableList.of((Object)field));
        return builder.addStatement("%L.%N = %L", instance, XElements.getSimpleName((XElement)field), argument).build();
    }

    private static XCodeBlock copyInstance(XFunSpecs.Builder methodBuilder, UniqueNameSet parameterNameSet, XType type) {
        boolean useObject = !Accessibility.isRawTypePubliclyAccessible(type);
        XCodeBlock instance = InjectionMethods.copyParameter(methodBuilder, type, parameterNameSet.getUniqueName("instance"), useObject, Nullability.NOT_NULLABLE);
        return useObject ? XCodeBlock.of((String)"(%L)", (Object[])new Object[]{instance}) : instance;
    }

    private XFunSpec constructor(ImmutableMap<DependencyRequest, XPropertySpec> frameworkFields) {
        ImmutableList<XParameterSpec> parameters = this.constructorParameters(frameworkFields);
        return XFunSpecs.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameters((Collection<XParameterSpec>)parameters).addCode(parameters.stream().map(parameter -> XCodeBlock.of((String)"this.%1N = %1N;", (Object[])new Object[]{parameter.getName()})).collect(XCodeBlocks.toConcatenatedCodeBlock())).build();
    }

    private ImmutableList<XParameterSpec> constructorParameters(ImmutableMap<DependencyRequest, XPropertySpec> frameworkFields) {
        return (ImmutableList)frameworkFields.values().stream().map(field -> XParameterSpecs.builder(field.getName(), field.getType()).addJavaAnnotations(XConverters.toJavaPoet((XPropertySpec)field).annotations).build()).collect(DaggerStreams.toImmutableList());
    }

    private XFunSpec createMethod(MembersInjectionBinding binding, ImmutableMap<DependencyRequest, XPropertySpec> frameworkFields) {
        ImmutableList<XParameterSpec> params = this.constructorParameters(frameworkFields);
        return XFunSpecs.methodBuilder("create").addModifiers(Modifier.PUBLIC, Modifier.STATIC).addTypeVariableNames((Collection<XTypeName>)SourceFiles.bindingTypeElementTypeVariableNames(binding)).returns(XTypeNames.membersInjectorOf(binding.key().type().xprocessing().asTypeName())).addParameters((Collection<XParameterSpec>)params).addStatement("return %L", XCodeBlock.ofNewInstance((XTypeName)SourceFiles.parameterizedGeneratedTypeNameForBinding(binding), (String)"%L", (Object[])new Object[]{XCodeBlocks.parameterNames(params)})).build();
    }

    private XFunSpec injectMembersMethod(MembersInjectionBinding binding, ImmutableMap<DependencyRequest, XPropertySpec> frameworkFields) {
        XType instanceType = binding.key().type().xprocessing();
        ImmutableMap<DependencyRequest, XCodeBlock> dependencyCodeBlocks = this.sourceFiles.frameworkFieldUsages(binding.dependencies(), frameworkFields);
        XCodeBlock invokeInjectionSites = InjectionMethods.InjectionSiteMethod.invokeAll(binding.injectionSites(), SourceFiles.membersInjectorNameForType(binding.membersInjectedType()), XCodeBlock.of((String)"instance", (Object[])new Object[0]), instanceType, arg_0 -> dependencyCodeBlocks.get(arg_0));
        return XFunSpecs.methodBuilder("injectMembers").addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).addParameter("instance", instanceType.asTypeName()).addCode(invokeInjectionSites).build();
    }

    private XAnnotationSpec qualifierMetadataAnnotation(MembersInjectionBinding binding) {
        XAnnotationSpec.Builder builder = XAnnotationSpec.builder((XClassName)XTypeNames.QUALIFIER_METADATA);
        binding.injectionSites().stream().filter(injectionSite -> injectionSite.enclosingTypeElement().equals((Object)binding.membersInjectedType())).flatMap(injectionSite -> injectionSite.dependencies().stream()).map(DependencyRequest::key).map(Key::qualifier).flatMap(DaggerStreams.presentValues()).map(DaggerAnnotation::xprocessing).map(XAnnotation::getQualifiedName).distinct().forEach(qualifier -> builder.addMember("value", "%S", new Object[]{qualifier}));
        return builder.build();
    }

    private static ImmutableMap<DependencyRequest, XPropertySpec> frameworkFields(MembersInjectionBinding binding) {
        UniqueNameSet fieldNames = new UniqueNameSet();
        XClassName membersInjectorTypeName = SourceFiles.membersInjectorNameForType(binding.membersInjectedType());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        SourceFiles.generateBindingFieldsForDependencies(binding).forEach((request, bindingField) -> {
            boolean useRawFrameworkType = !Accessibility.isTypeAccessibleFrom(request.key().type().xprocessing(), membersInjectorTypeName.getPackageName());
            XTypeName fieldType = useRawFrameworkType ? bindingField.type().getRawTypeName() : bindingField.type();
            String fieldName = fieldNames.getUniqueName(bindingField.name());
            XPropertySpec.Builder fieldBuilder = XPropertySpec.builder((String)fieldName, (XTypeName)fieldType, (VisibilityModifier)VisibilityModifier.PRIVATE, (boolean)false, (boolean)false);
            if (useRawFrameworkType) {
                fieldBuilder.addAnnotation(XAnnotationSpecs.suppressWarnings(XAnnotationSpecs.Suppression.RAWTYPES, new XAnnotationSpecs.Suppression[0]));
            }
            builder.put(request, (Object)fieldBuilder.build());
        });
        return builder.buildOrThrow();
    }
}

