/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.AssistedFactoryBinding;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.AssistedInjectionBinding;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.writing.AssistedInjectionParameters;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.writing.SimpleMethodRequestRepresentation;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XExpression;
import dagger.internal.codegen.xprocessing.XFunSpecs;
import dagger.internal.codegen.xprocessing.XTypeSpecs;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XParameterSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Collection;
import java.util.Optional;

final class AssistedFactoryRequestRepresentation
extends RequestRepresentation {
    private final AssistedFactoryBinding binding;
    private final BindingGraph graph;
    private final SimpleMethodRequestRepresentation.Factory simpleMethodRequestRepresentationFactory;
    private final ComponentImplementation componentImplementation;

    @AssistedInject
    AssistedFactoryRequestRepresentation(@Assisted AssistedFactoryBinding binding, BindingGraph graph, ComponentImplementation componentImplementation, SimpleMethodRequestRepresentation.Factory simpleMethodRequestRepresentationFactory) {
        this.binding = (AssistedFactoryBinding)Preconditions.checkNotNull((Object)binding);
        this.graph = graph;
        this.componentImplementation = componentImplementation;
        this.simpleMethodRequestRepresentationFactory = simpleMethodRequestRepresentationFactory;
    }

    @Override
    XExpression getDependencyExpression(XClassName requestingClass) {
        Optional<Binding> localBinding = this.graph.localContributionBinding(this.binding.assistedInjectKey());
        Preconditions.checkArgument((boolean)localBinding.isPresent(), (Object)"assisted factory should have a dependency on an assisted injection binding");
        XExpression assistedInjectionExpression = this.simpleMethodRequestRepresentationFactory.create((AssistedInjectionBinding)localBinding.get()).getDependencyExpression(requestingClass.peerClass(""));
        return XExpression.create(assistedInjectionExpression.type(), XCodeBlock.of((String)"%L", (Object[])new Object[]{this.anonymousfactoryImpl(localBinding.get(), assistedInjectionExpression)}));
    }

    private XTypeSpec anonymousfactoryImpl(Binding assistedBinding, XExpression assistedInjectionExpression) {
        XTypeElement factory = XElements.asTypeElement(this.binding.bindingElement().get());
        XType factoryType = this.binding.key().type().xprocessing();
        XMethodElement factoryMethod = AssistedInjectionAnnotations.assistedFactoryMethod(factory);
        XTypeSpecs.Builder builder = XTypeSpecs.anonymousClassBuilder().addFunction(XFunSpecs.overridingWithoutParameters(factoryMethod, factoryType).addParameters((Collection<XParameterSpec>)AssistedInjectionParameters.assistedFactoryParameterSpecs(this.binding, this.componentImplementation.shardImplementation(assistedBinding))).addStatement("return %L", assistedInjectionExpression.codeBlock()).build());
        if (factory.isInterface()) {
            builder.addSuperinterface(factoryType.getTypeName());
        } else {
            builder.superclass(factoryType.getTypeName());
        }
        return builder.build();
    }

    @AssistedFactory
    static interface Factory {
        public AssistedFactoryRequestRepresentation create(AssistedFactoryBinding var1);
    }
}

