/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.processingstep;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import dagger.internal.codegen.binding.InjectBindingRegistry;
import dagger.internal.codegen.processingstep.TypeCheckingProcessingStep;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import java.util.Set;
import javax.inject.Inject;

final class InjectProcessingStep
extends TypeCheckingProcessingStep<XElement> {
    private final InjectBindingRegistry injectBindingRegistry;
    private final Set<XElement> processedElements = Sets.newHashSet();

    @Inject
    InjectProcessingStep(InjectBindingRegistry injectBindingRegistry) {
        this.injectBindingRegistry = injectBindingRegistry;
    }

    public ImmutableSet<XClassName> annotationClassNames() {
        return ImmutableSet.of((Object)XTypeNames.INJECT, (Object)XTypeNames.INJECT_JAVAX, (Object)XTypeNames.ASSISTED_INJECT);
    }

    @Override
    protected boolean requiresPreValidation() {
        return false;
    }

    @Override
    protected void process(XElement injectElement, ImmutableSet<XClassName> annotations) {
        if (this.processedElements.contains(injectElement)) {
            return;
        }
        if (XElementKt.isConstructor((XElement)injectElement)) {
            this.injectBindingRegistry.tryRegisterInjectConstructor(XElements.asConstructor(injectElement));
        } else if (XElementKt.isField((XElement)injectElement)) {
            this.injectBindingRegistry.tryRegisterInjectField(XElements.asField(injectElement));
        } else if (XElementKt.isMethod((XElement)injectElement)) {
            this.injectBindingRegistry.tryRegisterInjectMethod(XElements.asMethod(injectElement));
        }
        this.processedElements.add(injectElement);
    }
}

