/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.processingstep;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.AssistedFactoryBinding;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.AssistedInjectionBinding;
import dagger.internal.codegen.binding.BindingFactory;
import dagger.internal.codegen.binding.MethodSignatureFormatter;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.processingstep.SuperficialValidator;
import dagger.internal.codegen.processingstep.TypeCheckingProcessingStep;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.internal.codegen.xprocessing.XCodeBlocks;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XFunSpecs;
import dagger.internal.codegen.xprocessing.XMethodElements;
import dagger.internal.codegen.xprocessing.XParameterSpecs;
import dagger.internal.codegen.xprocessing.XProcessingEnvs;
import dagger.internal.codegen.xprocessing.XPropertySpecs;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypeSpecs;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XParameterSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMessager;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XVariableElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

final class AssistedFactoryProcessingStep
extends TypeCheckingProcessingStep<XTypeElement> {
    private final XProcessingEnv processingEnv;
    private final XMessager messager;
    private final XFiler filer;
    private final BindingFactory bindingFactory;
    private final MethodSignatureFormatter methodSignatureFormatter;
    private final SuperficialValidator superficialValidator;

    @Inject
    AssistedFactoryProcessingStep(XProcessingEnv processingEnv, XMessager messager, XFiler filer, BindingFactory bindingFactory, MethodSignatureFormatter methodSignatureFormatter, SuperficialValidator superficialValidator) {
        this.processingEnv = processingEnv;
        this.messager = messager;
        this.filer = filer;
        this.bindingFactory = bindingFactory;
        this.methodSignatureFormatter = methodSignatureFormatter;
        this.superficialValidator = superficialValidator;
    }

    public ImmutableSet<XClassName> annotationClassNames() {
        return ImmutableSet.of((Object)XTypeNames.ASSISTED_FACTORY);
    }

    @Override
    protected void process(XTypeElement factory, ImmutableSet<XClassName> annotations) {
        ValidationReport report = new AssistedFactoryValidator().validate(factory);
        report.printMessagesTo(this.messager);
        if (report.isClean()) {
            new AssistedFactoryImplGenerator().generate(this.bindingFactory.assistedFactoryBinding(factory, Optional.empty()));
        }
    }

    private final class AssistedFactoryValidator {
        private AssistedFactoryValidator() {
        }

        ValidationReport validate(XTypeElement factory) {
            ImmutableSet<XMethodElement> abstractFactoryMethods;
            ValidationReport.Builder report = ValidationReport.about((XElement)factory);
            if (!factory.isAbstract()) {
                return report.addError("The @AssistedFactory-annotated type must be either an abstract class or interface.", (XElement)factory).build();
            }
            if (factory.isNested() && !factory.isStatic()) {
                report.addError("Nested @AssistedFactory-annotated types must be static. ", (XElement)factory);
            }
            if ((abstractFactoryMethods = AssistedInjectionAnnotations.assistedFactoryMethods(factory)).isEmpty()) {
                report.addError("The @AssistedFactory-annotated type is missing an abstract, non-default method whose return type matches the assisted injection type.", (XElement)factory);
            }
            for (XMethodElement method : abstractFactoryMethods) {
                XType returnType = method.asMemberOf(factory.getType()).getReturnType();
                if (XTypes.isDeclared(returnType)) {
                    AssistedFactoryProcessingStep.this.superficialValidator.throwIfNearestEnclosingTypeNotValid((XElement)returnType.getTypeElement());
                }
                if (!this.isAssistedInjectionType(returnType)) {
                    report.addError(String.format("Invalid return type: %s. An assisted factory's abstract method must return a type with an @AssistedInject-annotated constructor.", XTypes.toStableString(returnType)), (XElement)method);
                }
                if (!XMethodElements.hasTypeParameters(method)) continue;
                report.addError("@AssistedFactory does not currently support type parameters in the creator method. See https://github.com/google/dagger/issues/2279", (XElement)method);
            }
            if (abstractFactoryMethods.size() > 1) {
                report.addError("The @AssistedFactory-annotated type should contain a single abstract, non-default method but found multiple: " + abstractFactoryMethods.stream().map(AssistedFactoryProcessingStep.this.methodSignatureFormatter::formatWithoutReturnType).collect(DaggerStreams.toImmutableList()), (XElement)factory);
            }
            if (!report.build().isClean()) {
                return report.build();
            }
            AssistedInjectionAnnotations.AssistedFactoryMetadata metadata = AssistedInjectionAnnotations.AssistedFactoryMetadata.create(factory.getType());
            HashSet<AssistedInjectionAnnotations.AssistedParameter> uniqueAssistedParameters = new HashSet<AssistedInjectionAnnotations.AssistedParameter>();
            for (AssistedInjectionAnnotations.AssistedParameter assistedParameter : metadata.assistedFactoryAssistedParameters()) {
                if (uniqueAssistedParameters.add(assistedParameter)) continue;
                report.addError("@AssistedFactory method has duplicate @Assisted types: " + assistedParameter, (XElement)assistedParameter.element());
            }
            if (!ImmutableSet.copyOf(metadata.assistedInjectAssistedParameters()).equals((Object)ImmutableSet.copyOf(metadata.assistedFactoryAssistedParameters()))) {
                report.addError(String.format("The parameters in the factory method must match the @Assisted parameters in %s.\n    Actual: %s#%s(%s)\n  Expected: %s#%s(%s)", XTypes.toStableString(metadata.assistedInjectType()), metadata.factory().getQualifiedName(), XElements.getSimpleName((XElement)metadata.factoryMethod()), metadata.factoryMethod().getParameters().stream().map(XVariableElement::getType).map(XTypes::toStableString).collect(Collectors.joining(", ")), metadata.factory().getQualifiedName(), XElements.getSimpleName((XElement)metadata.factoryMethod()), metadata.assistedInjectAssistedParameters().stream().map(AssistedInjectionAnnotations.AssistedParameter::type).map(XTypes::toStableString).collect(Collectors.joining(", "))), (XElement)metadata.factoryMethod());
            }
            return report.build();
        }

        private boolean isAssistedInjectionType(XType type) {
            return XTypes.isDeclared(type) && AssistedInjectionAnnotations.isAssistedInjectionType(type.getTypeElement());
        }
    }

    private final class AssistedFactoryImplGenerator
    extends SourceFileGenerator<AssistedFactoryBinding> {
        AssistedFactoryImplGenerator() {
            super(AssistedFactoryProcessingStep.this.filer, AssistedFactoryProcessingStep.this.processingEnv);
        }

        @Override
        public XElement originatingElement(AssistedFactoryBinding binding) {
            return binding.bindingElement().get();
        }

        @Override
        public ImmutableList<XTypeSpec> topLevelTypes(AssistedFactoryBinding binding) {
            XTypeElement factory = XElements.asTypeElement(binding.bindingElement().get());
            XClassName name = SourceFiles.generatedClassNameForBinding(binding);
            XTypeSpecs.Builder builder = XTypeSpecs.classBuilder(name).addModifiers(Modifier.PUBLIC, Modifier.FINAL).addTypeVariableNames((Collection<XTypeName>)XTypeElements.typeVariableNames(factory));
            if (factory.isInterface()) {
                builder.addSuperinterface(factory.getType().asTypeName());
            } else {
                builder.superclass(factory.getType().asTypeName());
            }
            AssistedInjectionAnnotations.AssistedFactoryMetadata metadata = AssistedInjectionAnnotations.AssistedFactoryMetadata.create(factory.getType());
            XParameterSpec delegateFactoryParam = XParameterSpecs.of("delegateFactory", this.delegateFactoryTypeName(metadata.assistedInjectType()));
            Object[] objectArray = new Object[2];
            objectArray[0] = delegateFactoryParam.getName();
            objectArray[1] = metadata.assistedInjectAssistedParameters().stream().map(arg_0 -> metadata.assistedFactoryAssistedParametersMap().get(arg_0)).map(param -> XCodeBlock.of((String)"%N", (Object[])new Object[]{param.getJvmName()})).collect(XCodeBlocks.toParametersCodeBlock());
            builder.addProperty(XPropertySpecs.builder(delegateFactoryParam.getName(), delegateFactoryParam.getType(), new Modifier[0]).addModifiers(Modifier.PRIVATE, Modifier.FINAL).build()).addFunction(XFunSpecs.constructorBuilder().addParameter(delegateFactoryParam).addStatement("this.%1N = %1N", delegateFactoryParam.getName()).build()).addFunction(XFunSpecs.overriding(metadata.factoryMethod(), metadata.factoryType()).addStatement("return %N.get(%L)", objectArray).build()).addFunction(XFunSpecs.methodBuilder("create").addModifiers(Modifier.PUBLIC, Modifier.STATIC).addParameter(delegateFactoryParam).addTypeVariableNames((Collection<XTypeName>)XTypeElements.typeVariableNames(metadata.assistedInjectElement())).returns(XTypeNames.providerOf(factory.getType().asTypeName())).addStatement("return %T.%Lcreate(%L)", XTypeNames.INSTANCE_FACTORY, XProcessingEnvs.isPreJava8SourceVersion(AssistedFactoryProcessingStep.this.processingEnv) ? XCodeBlock.of((String)"<%T>", (Object[])new Object[]{Accessibility.accessibleTypeName(metadata.factoryType(), name, AssistedFactoryProcessingStep.this.processingEnv)}) : XCodeBlock.of((String)"", (Object[])new Object[0]), XCodeBlock.ofNewInstance((XTypeName)name, (String)"%N", (Object[])new Object[]{delegateFactoryParam.getName()})).build()).addFunction(XFunSpecs.methodBuilder("createFactoryProvider").addModifiers(Modifier.PUBLIC, Modifier.STATIC).addParameter(delegateFactoryParam).addTypeVariableNames((Collection<XTypeName>)XTypeElements.typeVariableNames(metadata.assistedInjectElement())).returns(XTypeNames.daggerProviderOf(factory.getType().asTypeName())).addStatement("return %T.%Lcreate(%L)", XTypeNames.INSTANCE_FACTORY, XProcessingEnvs.isPreJava8SourceVersion(AssistedFactoryProcessingStep.this.processingEnv) ? XCodeBlock.of((String)"<%T>", (Object[])new Object[]{Accessibility.accessibleTypeName(metadata.factoryType(), name, AssistedFactoryProcessingStep.this.processingEnv)}) : XCodeBlock.of((String)"", (Object[])new Object[0]), XCodeBlock.ofNewInstance((XTypeName)name, (String)"%N", (Object[])new Object[]{delegateFactoryParam.getName()})).build());
            return ImmutableList.of((Object)builder.build());
        }

        private XTypeName delegateFactoryTypeName(XType assistedInjectType) {
            AssistedInjectionBinding binding = AssistedFactoryProcessingStep.this.bindingFactory.assistedInjectionBinding((XConstructorElement)Iterables.getOnlyElement(AssistedInjectionAnnotations.assistedInjectedConstructors(assistedInjectType.getTypeElement())), Optional.empty());
            XClassName generatedFactoryClassName = SourceFiles.generatedClassNameForBinding(binding);
            return assistedInjectType.getTypeArguments().isEmpty() ? generatedFactoryClassName : generatedFactoryClassName.parametrizedBy((XTypeName[])((ImmutableList)assistedInjectType.getTypeArguments().stream().map(XType::asTypeName).collect(DaggerStreams.toImmutableList())).toArray((Object[])new XTypeName[0]));
        }
    }
}

