/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.bindinggraphvalidation;

import dagger.internal.codegen.base.Scopes;
import dagger.internal.codegen.binding.MethodSignatureFormatter;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.model.Binding;
import dagger.internal.codegen.model.BindingGraph;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.DiagnosticReporter;
import dagger.internal.codegen.validation.DiagnosticMessageGenerator;
import dagger.internal.codegen.validation.ValidationBindingGraphPlugin;
import dagger.internal.codegen.xprocessing.XElements;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.tools.Diagnostic;

final class IncompatiblyScopedBindingsValidator
extends ValidationBindingGraphPlugin {
    private final MethodSignatureFormatter methodSignatureFormatter;
    private final CompilerOptions compilerOptions;
    private final DiagnosticMessageGenerator.Factory diagnosticMessageGeneratorFactory;

    @Inject
    IncompatiblyScopedBindingsValidator(MethodSignatureFormatter methodSignatureFormatter, CompilerOptions compilerOptions, DiagnosticMessageGenerator.Factory diagnosticMessageGeneratorFactory) {
        this.methodSignatureFormatter = methodSignatureFormatter;
        this.compilerOptions = compilerOptions;
        this.diagnosticMessageGeneratorFactory = diagnosticMessageGeneratorFactory;
    }

    @Override
    public String pluginName() {
        return "Dagger/IncompatiblyScopedBindings";
    }

    @Override
    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        DiagnosticMessageGenerator diagnosticMessageGenerator = this.diagnosticMessageGeneratorFactory.create(bindingGraph);
        bindingGraph.bindings().stream().filter(binding -> IncompatiblyScopedBindingsValidator.hasIncompatibleScope(bindingGraph, binding)).collect(Collectors.groupingBy(binding -> IncompatiblyScopedBindingsValidator.owningComponent(bindingGraph, binding))).forEach((owningComponent, bindings) -> this.report((BindingGraph.ComponentNode)owningComponent, (List<Binding>)bindings, diagnosticReporter, diagnosticMessageGenerator));
    }

    private static boolean hasIncompatibleScope(BindingGraph bindingGraph, Binding binding) {
        if (binding.scope().isEmpty() || binding.scope().get().isReusable() || binding.kind() == BindingKind.INJECTION && IncompatiblyScopedBindingsValidator.isSubcomponentOrModuleRoot(bindingGraph)) {
            return false;
        }
        return !IncompatiblyScopedBindingsValidator.owningComponent(bindingGraph, binding).scopes().contains((Object)binding.scope().get());
    }

    private static boolean isSubcomponentOrModuleRoot(BindingGraph bindingGraph) {
        BindingGraph.ComponentNode rootComponent = bindingGraph.rootComponentNode();
        return rootComponent.isSubcomponent() || !rootComponent.isRealComponent();
    }

    private static BindingGraph.ComponentNode owningComponent(BindingGraph bindingGraph, Binding binding) {
        return bindingGraph.componentNode(binding.componentPath()).get();
    }

    private void report(BindingGraph.ComponentNode componentNode, List<Binding> bindings, DiagnosticReporter diagnosticReporter, DiagnosticMessageGenerator diagnosticMessageGenerator) {
        Diagnostic.Kind diagnosticKind = Diagnostic.Kind.ERROR;
        StringBuilder message = new StringBuilder(componentNode.componentPath().currentComponent().xprocessing().getQualifiedName());
        if (!componentNode.isRealComponent()) {
            if (bindings.stream().map(Binding::scope).map(Optional::get).distinct().count() <= 1L) {
                return;
            }
            message.append(" contains bindings with different scopes:");
            diagnosticKind = this.compilerOptions.moduleHasDifferentScopesDiagnosticKind();
        } else if (componentNode.scopes().isEmpty()) {
            message.append(" (unscoped) may not reference scoped bindings:");
        } else {
            message.append(" scoped with ").append(componentNode.scopes().stream().map(Scopes::getReadableSource).collect(Collectors.joining(" "))).append(" may not reference bindings with different scopes:");
        }
        for (Binding binding : bindings) {
            message.append('\n').append("    ");
            switch (binding.kind()) {
                case DELEGATE: 
                case PROVISION: {
                    message.append(this.methodSignatureFormatter.format(XElements.asExecutable(binding.bindingElement().get().xprocessing())));
                    break;
                }
                case INJECTION: {
                    message.append(Scopes.getReadableSource(binding.scope().get())).append(" class ").append(XElements.closestEnclosingTypeElement(binding.bindingElement().get().xprocessing()).getQualifiedName()).append(diagnosticMessageGenerator.getMessage(binding));
                    break;
                }
                default: {
                    throw new AssertionError(binding);
                }
            }
            message.append('\n');
        }
        diagnosticReporter.reportComponent(diagnosticKind, componentNode, message.toString());
    }
}

