/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.CaseFormat;
import dagger.internal.codegen.base.RequestKinds;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.xprocessing.XExpression;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import java.util.Optional;

public enum FrameworkType {
    PROVIDER{

        @Override
        public XCodeBlock to(RequestKind requestKind, XCodeBlock from) {
            switch (requestKind) {
                case INSTANCE: {
                    return XCodeBlock.of((String)"%L.get()", (Object[])new Object[]{from});
                }
                case LAZY: {
                    return XCodeBlock.of((String)"%T.lazy(%L)", (Object[])new Object[]{XTypeNames.DOUBLE_CHECK, from});
                }
                case PROVIDER: {
                    return from;
                }
                case PROVIDER_OF_LAZY: {
                    return XCodeBlock.of((String)"%T.create(%L)", (Object[])new Object[]{XTypeNames.PROVIDER_OF_LAZY, from});
                }
                case PRODUCER: {
                    return XCodeBlock.of((String)"%T.producerFromProvider(%L)", (Object[])new Object[]{XTypeNames.PRODUCERS, from});
                }
                case FUTURE: {
                    return XCodeBlock.of((String)"%T.immediateFuture(%L)", (Object[])new Object[]{XTypeNames.FUTURES, this.to(RequestKind.INSTANCE, from)});
                }
                case PRODUCED: {
                    return XCodeBlock.of((String)"%T.successful(%L)", (Object[])new Object[]{XTypeNames.PRODUCED, this.to(RequestKind.INSTANCE, from)});
                }
            }
            throw new IllegalArgumentException(String.format("Cannot request a %s from a %s", new Object[]{requestKind, this}));
        }

        @Override
        public XExpression to(RequestKind requestKind, XExpression from, XProcessingEnv processingEnv) {
            XCodeBlock codeBlock = this.to(requestKind, from.codeBlock());
            switch (requestKind) {
                case INSTANCE: {
                    return XExpression.create(from.type().unwrapType(), codeBlock);
                }
                case PROVIDER: {
                    return from;
                }
                case PROVIDER_OF_LAZY: {
                    return XExpression.create(from.type().rewrapType(XTypeNames.LAZY).wrapType(XTypeNames.DAGGER_PROVIDER), codeBlock);
                }
                case FUTURE: {
                    return XExpression.create(from.type().rewrapType(XTypeNames.LISTENABLE_FUTURE), codeBlock);
                }
            }
            return XExpression.create(from.type().rewrapType(RequestKinds.frameworkClassName(requestKind)), codeBlock);
        }
    }
    ,
    PRODUCER_NODE{

        @Override
        public XCodeBlock to(RequestKind requestKind, XCodeBlock from) {
            switch (requestKind) {
                case FUTURE: {
                    return XCodeBlock.of((String)"%L.get()", (Object[])new Object[]{from});
                }
                case PRODUCER: {
                    return from;
                }
            }
            throw new IllegalArgumentException(String.format("Cannot request a %s from a %s", new Object[]{requestKind, this}));
        }

        @Override
        public XExpression to(RequestKind requestKind, XExpression from, XProcessingEnv processingEnv) {
            switch (requestKind) {
                case FUTURE: {
                    return XExpression.create(from.type().rewrapType(XTypeNames.LISTENABLE_FUTURE), this.to(requestKind, from.codeBlock()));
                }
                case PRODUCER: {
                    return from;
                }
            }
            throw new IllegalArgumentException(String.format("Cannot request a %s from a %s", new Object[]{requestKind, this}));
        }
    };


    public static FrameworkType forBindingType(BindingType bindingType) {
        switch (bindingType) {
            case PROVISION: {
                return PROVIDER;
            }
            case PRODUCTION: {
                return PRODUCER_NODE;
            }
        }
        throw new AssertionError((Object)bindingType);
    }

    public static Optional<FrameworkType> forRequestKind(RequestKind requestKind) {
        switch (requestKind) {
            case PROVIDER: {
                return Optional.of(PROVIDER);
            }
            case PRODUCER: {
                return Optional.of(PRODUCER_NODE);
            }
        }
        return Optional.empty();
    }

    public XClassName frameworkClassName() {
        switch (this.ordinal()) {
            case 0: {
                return XTypeNames.DAGGER_PROVIDER;
            }
            case 1: {
                return XTypeNames.PRODUCER;
            }
        }
        throw new AssertionError((Object)("Unknown value: " + this.name()));
    }

    public XTypeName frameworkClassOf(XTypeName valueType) {
        return this.frameworkClassName().parametrizedBy(new XTypeName[]{valueType});
    }

    public RequestKind requestKind() {
        switch (this.ordinal()) {
            case 0: {
                return RequestKind.PROVIDER;
            }
            case 1: {
                return RequestKind.PRODUCER;
            }
        }
        throw new AssertionError((Object)("Unknown value: " + this.name()));
    }

    public abstract XCodeBlock to(RequestKind var1, XCodeBlock var2);

    public abstract XExpression to(RequestKind var1, XExpression var2, XProcessingEnv var3);

    public String toString() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, super.toString());
    }
}

