/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.model.DaggerAnnotation;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.writing.GwtCompatibility;
import dagger.internal.codegen.writing.InjectionMethods;
import dagger.internal.codegen.xprocessing.Nullability;
import dagger.internal.codegen.xprocessing.XAnnotationSpecs;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XCodeBlocks;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.VisibilityModifier;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XPropertySpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFieldElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XVariableElement;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

public final class MembersInjectorGenerator
extends SourceFileGenerator<MembersInjectionBinding> {
    private final SourceFiles sourceFiles;

    @Inject
    MembersInjectorGenerator(XFiler filer, SourceFiles sourceFiles, XProcessingEnv processingEnv) {
        super(filer, processingEnv);
        this.sourceFiles = sourceFiles;
    }

    @Override
    public XElement originatingElement(MembersInjectionBinding binding) {
        return binding.membersInjectedType();
    }

    @Override
    public ImmutableList<TypeSpec.Builder> topLevelTypes(MembersInjectionBinding binding) {
        Preconditions.checkState((!binding.unresolved().isPresent() ? 1 : 0) != 0, (String)"tried to generate a MembersInjector for a binding of a resolved generic type: %s", (Object)binding);
        XClassName generatedTypeName = SourceFiles.membersInjectorNameForType(binding.membersInjectedType());
        ImmutableList<XTypeName> typeParameters = SourceFiles.bindingTypeElementTypeVariableNames(binding);
        ImmutableMap<DependencyRequest, XPropertySpec> frameworkFields = MembersInjectorGenerator.frameworkFields(binding);
        TypeSpec.Builder injectorTypeBuilder = TypeSpec.classBuilder((ClassName)XConverters.toJavaPoet((XClassName)generatedTypeName)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addTypeVariables((Iterable)typeParameters.stream().map(typeName -> (TypeVariableName)XConverters.toJavaPoet((XTypeName)typeName)).collect(DaggerStreams.toImmutableList())).addAnnotation(this.qualifierMetadataAnnotation(binding)).addSuperinterface(XConverters.toJavaPoet((XTypeName)XTypeNames.membersInjectorOf(binding.key().type().xprocessing().asTypeName()))).addFields((Iterable)frameworkFields.values().stream().map(XConverters::toJavaPoet).collect(DaggerStreams.toImmutableList())).addMethod(this.constructor(frameworkFields)).addMethod(this.createMethod(binding, frameworkFields)).addMethod(this.injectMembersMethod(binding, frameworkFields)).addMethods((Iterable)binding.injectionSites().stream().filter(site -> site.enclosingTypeElement().equals((Object)binding.membersInjectedType())).map(MembersInjectorGenerator::membersInjectionMethod).collect(DaggerStreams.toImmutableList()));
        GwtCompatibility.gwtIncompatibleAnnotation(binding).ifPresent(arg_0 -> ((TypeSpec.Builder)injectorTypeBuilder).addAnnotation(arg_0));
        return ImmutableList.of((Object)injectorTypeBuilder);
    }

    private static MethodSpec membersInjectionMethod(MembersInjectionBinding.InjectionSite injectionSite) {
        String methodName = SourceFiles.membersInjectorMethodName(injectionSite);
        switch (injectionSite.kind()) {
            case METHOD: {
                return MembersInjectorGenerator.methodInjectionMethod(XElements.asMethod(injectionSite.element()), methodName);
            }
            case FIELD: {
                Optional<XAnnotation> qualifier = ((DependencyRequest)Iterables.getOnlyElement(injectionSite.dependencies())).key().qualifier().map(DaggerAnnotation::xprocessing);
                return MembersInjectorGenerator.fieldInjectionMethod(XElements.asField(injectionSite.element()), methodName, qualifier);
            }
        }
        throw new AssertionError(injectionSite);
    }

    private static MethodSpec methodInjectionMethod(XMethodElement method, String methodName) {
        XTypeElement enclosingType = XElements.asTypeElement((XElement)method.getEnclosingElement());
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).varargs(method.isVarArgs()).addTypeVariables((Iterable)XTypeElements.typeVariableNames(enclosingType).stream().map(typeName -> (TypeVariableName)XConverters.toJavaPoet((XTypeName)typeName)).collect(DaggerStreams.toImmutableList())).addExceptions((Iterable)MembersInjectorGenerator.getThrownTypes((XExecutableElement)method).stream().map(XConverters::toJavaPoet).collect(DaggerStreams.toImmutableList()));
        UniqueNameSet parameterNameSet = new UniqueNameSet();
        XCodeBlock instance = MembersInjectorGenerator.copyInstance(builder, parameterNameSet, enclosingType.getType());
        XCodeBlock arguments = InjectionMethods.copyParameters(builder, parameterNameSet, method.getParameters());
        return builder.addStatement("$L.$L($L)", new Object[]{XConverters.toJavaPoet((XCodeBlock)instance), method.getJvmName(), XConverters.toJavaPoet((XCodeBlock)arguments)}).build();
    }

    private static MethodSpec fieldInjectionMethod(XFieldElement field, String methodName, Optional<XAnnotation> qualifier) {
        XTypeElement enclosingType = XElements.asTypeElement((XElement)field.getEnclosingElement());
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addAnnotation(AnnotationSpec.builder((ClassName)XConverters.toJavaPoet((XClassName)XTypeNames.INJECTED_FIELD_SIGNATURE)).addMember("value", "$S", new Object[]{SourceFiles.memberInjectedFieldSignatureForVariable(field)}).build()).addTypeVariables((Iterable)XTypeElements.typeVariableNames(enclosingType).stream().map(typeName -> (TypeVariableName)XConverters.toJavaPoet((XTypeName)typeName)).collect(DaggerStreams.toImmutableList()));
        qualifier.map(XAnnotations::getAnnotationSpec).ifPresent(arg_0 -> ((MethodSpec.Builder)builder).addAnnotation(arg_0));
        UniqueNameSet parameterNameSet = new UniqueNameSet();
        XCodeBlock instance = MembersInjectorGenerator.copyInstance(builder, parameterNameSet, enclosingType.getType());
        XCodeBlock argument = InjectionMethods.copyParameters(builder, parameterNameSet, (List<? extends XVariableElement>)ImmutableList.of((Object)field));
        return builder.addStatement("$L.$L = $L", new Object[]{XConverters.toJavaPoet((XCodeBlock)instance), XElements.getSimpleName((XElement)field), XConverters.toJavaPoet((XCodeBlock)argument)}).build();
    }

    private static ImmutableList<XTypeName> getThrownTypes(XExecutableElement executable) {
        return (ImmutableList)executable.getThrownTypes().stream().map(XType::asTypeName).collect(DaggerStreams.toImmutableList());
    }

    private static XCodeBlock copyInstance(MethodSpec.Builder methodBuilder, UniqueNameSet parameterNameSet, XType type) {
        boolean useObject = !Accessibility.isRawTypePubliclyAccessible(type);
        XCodeBlock instance = InjectionMethods.copyParameter(methodBuilder, type, parameterNameSet.getUniqueName("instance"), useObject, Nullability.NOT_NULLABLE);
        return useObject ? XCodeBlock.of((String)"(%L)", (Object[])new Object[]{instance}) : instance;
    }

    private MethodSpec constructor(ImmutableMap<DependencyRequest, XPropertySpec> frameworkFields) {
        ImmutableList dependencyParameters = (ImmutableList)frameworkFields.values().stream().map(field -> ParameterSpec.builder((TypeName)XConverters.toJavaPoet((XTypeName)field.getType()), (String)field.getName(), (Modifier[])new Modifier[0]).addAnnotations((Iterable)XConverters.toJavaPoet((XPropertySpec)field).annotations).build()).collect(DaggerStreams.toImmutableList());
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameters((Iterable)dependencyParameters).addCode(XConverters.toJavaPoet((XCodeBlock)dependencyParameters.stream().map(parameter -> XCodeBlock.of((String)"this.%1L = %1L;", (Object[])new Object[]{parameter.name})).collect(XCodeBlocks.toConcatenatedCodeBlock()))).build();
    }

    private MethodSpec createMethod(MembersInjectionBinding binding, ImmutableMap<DependencyRequest, XPropertySpec> frameworkFields) {
        List params = this.constructor(frameworkFields).parameters;
        return MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addTypeVariables((Iterable)SourceFiles.bindingTypeElementTypeVariableNames(binding).stream().map(typeName -> (TypeVariableName)XConverters.toJavaPoet((XTypeName)typeName)).collect(DaggerStreams.toImmutableList())).returns(XConverters.toJavaPoet((XTypeName)XTypeNames.membersInjectorOf(binding.key().type().xprocessing().asTypeName()))).addParameters((Iterable)params).addStatement("return new $T($L)", new Object[]{XConverters.toJavaPoet((XTypeName)SourceFiles.parameterizedGeneratedTypeNameForBinding(binding)), CodeBlocks.parameterNames(params)}).build();
    }

    private MethodSpec injectMembersMethod(MembersInjectionBinding binding, ImmutableMap<DependencyRequest, XPropertySpec> frameworkFields) {
        XType instanceType = binding.key().type().xprocessing();
        ImmutableMap<DependencyRequest, XCodeBlock> dependencyCodeBlocks = this.sourceFiles.frameworkFieldUsages(binding.dependencies(), frameworkFields);
        XCodeBlock invokeInjectionSites = InjectionMethods.InjectionSiteMethod.invokeAll(binding.injectionSites(), SourceFiles.membersInjectorNameForType(binding.membersInjectedType()), XCodeBlock.of((String)"instance", (Object[])new Object[0]), instanceType, arg_0 -> dependencyCodeBlocks.get(arg_0));
        return MethodSpec.methodBuilder((String)"injectMembers").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(XConverters.toJavaPoet((XTypeName)instanceType.asTypeName()), "instance", new Modifier[0]).addCode(XConverters.toJavaPoet((XCodeBlock)invokeInjectionSites)).build();
    }

    private AnnotationSpec qualifierMetadataAnnotation(MembersInjectionBinding binding) {
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)XConverters.toJavaPoet((XClassName)XTypeNames.QUALIFIER_METADATA));
        binding.injectionSites().stream().filter(injectionSite -> injectionSite.enclosingTypeElement().equals((Object)binding.membersInjectedType())).flatMap(injectionSite -> injectionSite.dependencies().stream()).map(DependencyRequest::key).map(Key::qualifier).flatMap(DaggerStreams.presentValues()).map(DaggerAnnotation::xprocessing).map(XAnnotation::getQualifiedName).distinct().forEach(qualifier -> builder.addMember("value", "$S", new Object[]{qualifier}));
        return builder.build();
    }

    private static ImmutableMap<DependencyRequest, XPropertySpec> frameworkFields(MembersInjectionBinding binding) {
        UniqueNameSet fieldNames = new UniqueNameSet();
        XClassName membersInjectorTypeName = SourceFiles.membersInjectorNameForType(binding.membersInjectedType());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        SourceFiles.generateBindingFieldsForDependencies(binding).forEach((request, bindingField) -> {
            boolean useRawFrameworkType = !Accessibility.isTypeAccessibleFrom(request.key().type().xprocessing(), membersInjectorTypeName.getPackageName());
            XTypeName fieldType = useRawFrameworkType ? bindingField.type().getRawTypeName() : bindingField.type();
            String fieldName = fieldNames.getUniqueName(bindingField.name());
            XPropertySpec.Builder fieldBuilder = XPropertySpec.builder((String)fieldName, (XTypeName)fieldType, (VisibilityModifier)VisibilityModifier.PRIVATE, (boolean)false, (boolean)false);
            if (useRawFrameworkType) {
                fieldBuilder.addAnnotation(XAnnotationSpecs.suppressWarnings(XAnnotationSpecs.Suppression.RAWTYPES, new XAnnotationSpecs.Suppression[0]));
            }
            builder.put(request, (Object)fieldBuilder.build());
        });
        return builder.buildOrThrow();
    }
}

