/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.AssistedFactoryBinding;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.AssistedInjectionBinding;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.writing.AssistedInjectionParameters;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.writing.SimpleMethodRequestRepresentation;
import dagger.internal.codegen.xprocessing.MethodSpecs;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XExpression;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Optional;

final class AssistedFactoryRequestRepresentation
extends RequestRepresentation {
    private final AssistedFactoryBinding binding;
    private final BindingGraph graph;
    private final SimpleMethodRequestRepresentation.Factory simpleMethodRequestRepresentationFactory;
    private final ComponentImplementation componentImplementation;

    @AssistedInject
    AssistedFactoryRequestRepresentation(@Assisted AssistedFactoryBinding binding, BindingGraph graph, ComponentImplementation componentImplementation, SimpleMethodRequestRepresentation.Factory simpleMethodRequestRepresentationFactory) {
        this.binding = (AssistedFactoryBinding)Preconditions.checkNotNull((Object)binding);
        this.graph = graph;
        this.componentImplementation = componentImplementation;
        this.simpleMethodRequestRepresentationFactory = simpleMethodRequestRepresentationFactory;
    }

    @Override
    XExpression getDependencyExpression(XClassName requestingClass) {
        Optional<Binding> localBinding = this.graph.localContributionBinding(this.binding.assistedInjectKey());
        Preconditions.checkArgument((boolean)localBinding.isPresent(), (Object)"assisted factory should have a dependency on an assisted injection binding");
        XExpression assistedInjectionExpression = this.simpleMethodRequestRepresentationFactory.create((AssistedInjectionBinding)localBinding.get()).getDependencyExpression(requestingClass.peerClass(""));
        return XExpression.create(assistedInjectionExpression.type(), CodeBlock.of((String)"$L", (Object[])new Object[]{this.anonymousfactoryImpl(localBinding.get(), assistedInjectionExpression)}));
    }

    private TypeSpec anonymousfactoryImpl(Binding assistedBinding, XExpression assistedInjectionExpression) {
        XTypeElement factory = XElements.asTypeElement(this.binding.bindingElement().get());
        XType factoryType = this.binding.key().type().xprocessing();
        XMethodElement factoryMethod = AssistedInjectionAnnotations.assistedFactoryMethod(factory);
        MethodSpec factoryOverride = MethodSpecs.overriding(factoryMethod, factoryType).build();
        TypeSpec.Builder builder = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addMethod(MethodSpec.methodBuilder((String)factoryMethod.getJvmName()).addModifiers((Iterable)factoryOverride.modifiers).addTypeVariables((Iterable)factoryOverride.typeVariables).returns(factoryOverride.returnType).addAnnotations((Iterable)factoryOverride.annotations).addExceptions((Iterable)factoryOverride.exceptions).addParameters(AssistedInjectionParameters.assistedFactoryParameterSpecs(this.binding, this.componentImplementation.shardImplementation(assistedBinding))).addStatement("return $L", new Object[]{XConverters.toJavaPoet((XCodeBlock)assistedInjectionExpression.codeBlock())}).build());
        if (factory.isInterface()) {
            builder.addSuperinterface(factoryType.getTypeName());
        } else {
            builder.superclass(factoryType.getTypeName());
        }
        return builder.build();
    }

    @AssistedFactory
    static interface Factory {
        public AssistedFactoryRequestRepresentation create(AssistedFactoryBinding var1);
    }
}

