/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.javapoet;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import java.util.stream.Collector;
import java.util.stream.StreamSupport;
import javax.lang.model.element.Modifier;

public final class CodeBlocks {
    public static Collector<CodeBlock, ?, CodeBlock> toParametersCodeBlock() {
        return CodeBlock.joining((String)", ");
    }

    public static Collector<CodeBlock, ?, CodeBlock> toConcatenatedCodeBlock() {
        return CodeBlock.joining((String)"\n", (String)"", (String)"\n");
    }

    public static CodeBlock makeParametersCodeBlock(Iterable<CodeBlock> codeBlocks) {
        return StreamSupport.stream(codeBlocks.spliterator(), false).collect(CodeBlocks.toParametersCodeBlock());
    }

    public static CodeBlock parameterNames(Iterable<ParameterSpec> parameters) {
        return StreamSupport.stream(parameters.spliterator(), false).map(p -> CodeBlock.of((String)"$N", (Object[])new Object[]{p})).collect(CodeBlocks.toParametersCodeBlock());
    }

    public static CodeBlock concat(Iterable<CodeBlock> codeBlocks) {
        return StreamSupport.stream(codeBlocks.spliterator(), false).collect(CodeBlocks.toConcatenatedCodeBlock());
    }

    public static CodeBlock anonymousLazy(XTypeName providedType, CodeBlock body) {
        return CodeBlock.of((String)"$L", (Object[])new Object[]{TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).superclass(XConverters.toJavaPoet((XTypeName)XTypeNames.lazyOf(providedType))).addMethod(MethodSpec.methodBuilder((String)"get").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(XConverters.toJavaPoet((XTypeName)providedType)).addCode(body).build()).build()});
    }

    public static CodeBlock cast(CodeBlock expression, XClassName castTo) {
        return CodeBlock.of((String)"($T) $L", (Object[])new Object[]{XConverters.toJavaPoet((XClassName)castTo), expression});
    }

    public static CodeBlock cast(CodeBlock expression, Class<?> castTo) {
        return CodeBlock.of((String)"($T) $L", (Object[])new Object[]{castTo, expression});
    }

    public static CodeBlock type(XType type) {
        return CodeBlock.of((String)"$T", (Object[])new Object[]{XConverters.toJavaPoet((XTypeName)type.asTypeName())});
    }

    public static CodeBlock stringLiteral(String toWrap) {
        return CodeBlock.of((String)"$S", (Object[])new Object[]{toWrap});
    }

    private CodeBlocks() {
    }
}

